/*
 * Decompiled with CFR 0.152.
 */
package am2.guis;

import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.events.SpellRecipeItemsEvent;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.RecipesEssenceRefiner;
import am2.bosses.IArsMagicaBoss;
import am2.entities.EntityFlicker;
import am2.guis.AMGuiHelper;
import am2.guis.GuiBlockAccess;
import am2.guis.GuiCompendiumIndex;
import am2.guis.controls.GuiButtonCompendiumNext;
import am2.guis.controls.GuiButtonCompendiumTab;
import am2.guis.controls.GuiButtonVariableDims;
import am2.guis.controls.GuiSpellImageButton;
import am2.items.ItemSpellPart;
import am2.items.ItemsCommonProxy;
import am2.items.RecipeArsMagica;
import am2.lore.ArcaneCompendium;
import am2.lore.CompendiumEntry;
import am2.lore.CompendiumEntrySpellComponent;
import am2.lore.CompendiumEntrySpellModifier;
import am2.lore.CompendiumEntrySpellShape;
import am2.spell.SkillManager;
import am2.spell.SpellRecipeManager;
import am2.texture.SpellIconManager;
import am2.utility.RecipeUtilities;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;

public class GuiArcaneCompendium
extends GuiScreen {
    protected static RenderItem itemRenderer = new RenderItem();
    protected static RenderBlocks blockRenderer = new RenderBlocks();
    Minecraft field_146297_k = Minecraft.func_71410_x();
    String entryName;
    private final HashMap<Item, Integer> forcedMetas;
    private static final ResourceLocation background = new ResourceLocation("arsmagica2", "textures/guis/ArcaneCompendiumGui.png");
    private static final ResourceLocation extras = new ResourceLocation("arsmagica2", "textures/guis/ArcaneCompendiumGuiExtras.png");
    private static final ResourceLocation red = new ResourceLocation("arsmagica2", "textures/blocks/red.png");
    public static final ResourceLocation terrain = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation items = new ResourceLocation("textures/atlas/items.png");
    int page = 0;
    int numPages = 0;
    int xSize = 360;
    int ySize = 256;
    int maxLines = 17;
    int lineWidth = 140;
    GuiButtonCompendiumNext nextPage;
    GuiButtonCompendiumNext prevPage;
    GuiButtonCompendiumTab backToIndex;
    GuiSpellImageButton updateButton;
    ItemStack stackTip;
    int tipX;
    int tipY;
    CompendiumEntry entry;
    ItemStack[] relatedEntries;
    ArrayList<String> lines;
    float framecount = 0.0f;
    ItemStack renderStack;
    int recipeWidth;
    int recipeHeight;
    Object[] craftingComponents;
    Block entryBlock;
    Item entryItem;
    int entryMeta;
    ArrayList<ItemStack> modifiers;
    Entity entryEntity;
    int curRotationH = 0;
    int lastMouseX = 0;
    boolean isDragging = false;
    MultiblockStructureDefinition entryMultiblock;
    GuiBlockAccess blockAccess;
    GuiButtonCompendiumNext nextLayer;
    GuiButtonCompendiumNext prevLayer;
    GuiButtonVariableDims pauseCycling;
    int maxLayers = 0;
    int curLayer = -1;
    IRitualInteraction ritualController;

    public GuiArcaneCompendium(Block block) {
        this(block.func_149739_a().replace("arsmagica2:", "").replace("tile.", ""));
        this.entryBlock = block;
        this.entryMeta = -1;
        this.renderStack = new ItemStack(this.entryBlock);
        this.getAndAnalyzeRecipe();
    }

    public GuiArcaneCompendium(Item item) {
        this(item.func_77658_a().replace("item.", "").replace("arsmagica2:", ""));
        this.entryItem = item;
        this.entryMeta = -1;
        this.renderStack = new ItemStack(this.entryItem);
        this.getAndAnalyzeRecipe();
    }

    public GuiArcaneCompendium(String entryID, Block block, int meta) {
        this(entryID);
        this.entryBlock = block;
        this.entryMeta = meta;
        this.renderStack = new ItemStack(this.entryBlock, 1, meta);
        this.getAndAnalyzeRecipe();
    }

    public GuiArcaneCompendium(String entryID, Item item, int meta) {
        this(entryID);
        this.entryItem = item;
        this.entryMeta = meta;
        this.renderStack = new ItemStack(this.entryItem, 1, meta);
        this.getAndAnalyzeRecipe();
    }

    public GuiArcaneCompendium(Entity entity) {
        this(EntityList.func_75621_b((Entity)entity).replace("arsmagica2.", ""));
        this.entryEntity = entity;
    }

    public GuiArcaneCompendium(MultiblockStructureDefinition multi, TileEntity controllingTileEntity) {
        this(multi.getID());
        this.entryMultiblock = multi;
        this.blockAccess = new GuiBlockAccess();
        this.blockAccess.setControllingTileEntity(controllingTileEntity);
        ReflectionHelper.setPrivateValue(RenderBlocks.class, (Object)blockRenderer, (Object)this.blockAccess, (int)0);
    }

    public GuiArcaneCompendium(String id, MultiblockStructureDefinition multi, IRitualInteraction ritualController) {
        this(id);
        this.entryMultiblock = multi;
        this.blockAccess = new GuiBlockAccess();
        this.ritualController = ritualController;
        this.setupRitualPage();
        ReflectionHelper.setPrivateValue(RenderBlocks.class, (Object)blockRenderer, (Object)this.blockAccess, (int)0);
    }

    private void setupRitualPage() {
        this.blockAccess.setControllingTileEntity(null);
        for (ItemStack stack : this.ritualController.getReagents()) {
            this.modifiers.add(stack);
        }
        ItemStack[] temp = new ItemStack[this.relatedEntries.length + 1];
        for (int i = 0; i < this.relatedEntries.length; ++i) {
            temp[i] = this.relatedEntries[i];
        }
        temp[temp.length - 1] = new ItemStack((Item)ItemsCommonProxy.spell_component, 1, SkillManager.instance.getShiftedPartID((ISkillTreeEntry)((Object)this.ritualController)));
        this.relatedEntries = temp;
    }

    public GuiArcaneCompendium(AMGuiHelper.CompendiumBreadcrumb breadcrumb) {
        this(breadcrumb.entryName);
        this.page = breadcrumb.page;
        if (breadcrumb.refData.length == 3) {
            if (breadcrumb.refData[0] instanceof MultiblockStructureDefinition) {
                this.entryMultiblock = (MultiblockStructureDefinition)breadcrumb.refData[0];
                this.blockAccess = new GuiBlockAccess();
                this.blockAccess.setControllingTileEntity((TileEntity)breadcrumb.refData[1]);
                ReflectionHelper.setPrivateValue(RenderBlocks.class, (Object)blockRenderer, (Object)this.blockAccess, (int)0);
                this.ritualController = (IRitualInteraction)breadcrumb.refData[2];
                this.setupRitualPage();
            }
        } else if (breadcrumb.refData.length == 2) {
            if (breadcrumb.refData[0] instanceof Block) {
                this.entryBlock = (Block)breadcrumb.refData[0];
                this.entryMeta = (Integer)breadcrumb.refData[1];
                this.renderStack = new ItemStack(this.entryBlock, 1, this.entryMeta);
                this.getAndAnalyzeRecipe();
            } else if (breadcrumb.refData[0] instanceof Item) {
                this.entryItem = (Item)breadcrumb.refData[0];
                this.entryMeta = (Integer)breadcrumb.refData[1];
                this.renderStack = new ItemStack(this.entryItem, 1, this.entryMeta);
                this.getAndAnalyzeRecipe();
            } else if (breadcrumb.refData[0] instanceof MultiblockStructureDefinition) {
                this.entryMultiblock = (MultiblockStructureDefinition)breadcrumb.refData[0];
                this.blockAccess = new GuiBlockAccess();
                this.blockAccess.setControllingTileEntity((TileEntity)breadcrumb.refData[1]);
                ReflectionHelper.setPrivateValue(RenderBlocks.class, (Object)blockRenderer, (Object)this.blockAccess, (int)0);
            }
        } else if (breadcrumb.refData.length == 1 && breadcrumb.refData[0] instanceof Entity) {
            this.entryEntity = (Entity)breadcrumb.refData[0];
        }
    }

    private void getAndAnalyzeRecipe() {
        if (this.renderStack == null) {
            return;
        }
        if (this.renderStack.func_77973_b() == ItemsCommonProxy.essence || this.renderStack.func_77973_b() == ItemsCommonProxy.deficitCrystal) {
            RecipeArsMagica essenceRecipe = RecipesEssenceRefiner.essenceRefinement().recipeFor(this.renderStack);
            if (essenceRecipe != null) {
                this.craftingComponents = essenceRecipe.getRecipeItems();
                this.recipeHeight = 2;
            } else {
                this.craftingComponents = null;
            }
        } else if (this.renderStack.func_77973_b() instanceof ItemSpellPart) {
            ISkillTreeEntry part = SkillManager.instance.getSkill(this.entryName);
            if (part == null) {
                return;
            }
            ArrayList<Object> recipe = new ArrayList<Object>();
            if (part instanceof ISpellPart) {
                Object[] recipeItems = ((ISpellPart)part).getRecipeItems();
                SpellRecipeItemsEvent event = new SpellRecipeItemsEvent(SkillManager.instance.getSkillName(part), SkillManager.instance.getShiftedPartID(part), recipeItems);
                MinecraftForge.EVENT_BUS.post((Event)event);
                recipeItems = event.recipeItems;
                if (recipeItems != null) {
                    for (int i = 0; i < recipeItems.length; ++i) {
                        String s;
                        Object o = recipeItems[i];
                        boolean matches = false;
                        if (o instanceof ItemStack) {
                            recipe.add(o);
                            continue;
                        }
                        if (o instanceof Item) {
                            recipe.add(new ItemStack((Item)o));
                            continue;
                        }
                        if (o instanceof Block) {
                            recipe.add(new ItemStack((Block)o));
                            continue;
                        }
                        if (!(o instanceof String)) continue;
                        if (((String)o).startsWith("P:")) {
                            s = ((String)o).substring(2);
                            int pfx = SpellRecipeManager.parsePotionMeta(s);
                            recipe.add(new ItemStack((Item)Items.field_151068_bn, 1, pfx));
                            continue;
                        }
                        if (((String)o).startsWith("E:")) {
                            s = (String)o;
                            try {
                                int[] types = SpellRecipeManager.ParseEssenceIDs(s);
                                int type = 0;
                                for (int t : types) {
                                    type |= t;
                                }
                                int amount = (Integer)recipeItems[++i];
                                recipe.add(new ItemStack((Item)ItemsCommonProxy.essence, amount, 12 + type));
                            }
                            catch (Throwable t) {}
                            continue;
                        }
                        recipe.add(OreDictionary.getOres((String)((String)o)));
                    }
                }
            }
            this.craftingComponents = recipe.toArray();
        } else {
            IRecipe recipe = RecipeUtilities.getRecipeFor(this.renderStack);
            if (recipe != null) {
                this.renderStack = recipe.func_77571_b();
                if (recipe instanceof ShapedRecipes) {
                    this.recipeWidth = ((ShapedRecipes)recipe).field_77576_b;
                    this.recipeHeight = ((ShapedRecipes)recipe).field_77577_c;
                    this.craftingComponents = ((ShapedRecipes)recipe).field_77574_d;
                } else if (recipe instanceof ShapedOreRecipe) {
                    this.recipeWidth = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"});
                    this.recipeHeight = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"});
                    this.craftingComponents = ((ShapedOreRecipe)recipe).getInput();
                } else if (recipe instanceof ShapelessRecipes) {
                    this.recipeWidth = ((ShapelessRecipes)recipe).func_77570_a();
                    this.recipeHeight = -1;
                    this.craftingComponents = ((ShapelessRecipes)recipe).field_77579_b.toArray();
                } else if (recipe instanceof ShapelessOreRecipe) {
                    this.recipeWidth = ((ShapelessOreRecipe)recipe).func_77570_a();
                    this.recipeHeight = -1;
                    this.craftingComponents = ((ShapelessOreRecipe)recipe).getInput().toArray();
                } else {
                    this.craftingComponents = null;
                }
            } else {
                this.craftingComponents = null;
            }
        }
    }

    public GuiArcaneCompendium(String entryName) {
        this.entry = ArcaneCompendium.instance.getEntry(entryName);
        this.entryName = entryName;
        this.forcedMetas = new HashMap();
        if (this.entry == null) {
            this.lines = new ArrayList();
            this.numPages = 0;
            this.relatedEntries = new ItemStack[0];
            this.modifiers = new ArrayList();
            return;
        }
        this.lines = GuiArcaneCompendium.splitStringToLines(Minecraft.func_71410_x().field_71466_p, this.entry.getDescription(entryName), this.lineWidth, this.maxLines);
        this.numPages = this.lines.size() - 1;
        this.entry.setIsNew(false);
        CompendiumEntry[] childEntries = this.entry.getRelatedItems();
        this.relatedEntries = new ItemStack[childEntries.length];
        String name = "";
        int meta = -1;
        for (int i = 0; i < childEntries.length; ++i) {
            if (childEntries[i].getID().indexOf(64) == -1) {
                name = childEntries[i].getID();
            } else {
                String[] split = childEntries[i].getID().split("@");
                name = split[0];
                try {
                    meta = Integer.parseInt(split[1]);
                }
                catch (Throwable t) {
                    meta = -1;
                }
            }
            this.relatedEntries[i] = childEntries[i].getRepresentItemStack(name, meta);
        }
        this.modifiers = new ArrayList();
        SpellModifiers[] modifiedBy = new SpellModifiers[]{};
        if (this.entry instanceof CompendiumEntrySpellComponent) {
            modifiedBy = ((CompendiumEntrySpellComponent)this.entry).getModifiedBy();
        } else if (this.entry instanceof CompendiumEntrySpellShape) {
            modifiedBy = ((CompendiumEntrySpellShape)this.entry).getModifiedBy();
        } else if (this.entry instanceof CompendiumEntrySpellModifier) {
            modifiedBy = ((CompendiumEntrySpellModifier)this.entry).getModifies();
        }
        if (modifiedBy == null) {
            modifiedBy = new SpellModifiers[]{};
        }
        if (modifiedBy.length > 0) {
            block3: for (Integer modid : SkillManager.instance.getAllModifiers()) {
                ISpellModifier modifier = SkillManager.instance.getModifier(modid);
                if (modifier == null) continue;
                for (SpellModifiers mod : modifiedBy) {
                    if (this.entry instanceof CompendiumEntrySpellModifier) {
                        if (modifier.getAspectsModified().size() != 1 || !modifier.getAspectsModified().contains((Object)mod)) continue;
                        this.modifiers.add(new ItemStack((Item)ItemsCommonProxy.spell_component, 1, modid.intValue()));
                        continue block3;
                    }
                    if (!modifier.getAspectsModified().contains((Object)mod)) continue;
                    this.modifiers.add(new ItemStack((Item)ItemsCommonProxy.spell_component, 1, modid.intValue()));
                    continue block3;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.prevPage = new GuiButtonCompendiumNext(0, l + 35, i1 + this.ySize - 25, false);
        this.nextPage = new GuiButtonCompendiumNext(1, l + 315, i1 + this.ySize - 25, true);
        this.backToIndex = new GuiButtonCompendiumTab(2, l - 10, i1 + 20, StatCollector.func_74838_a((String)"am2.gui.back"), "back", null);
        this.backToIndex.setActive(true);
        this.prevLayer = new GuiButtonCompendiumNext(3, l + 180, i1 + 19, false);
        this.nextLayer = new GuiButtonCompendiumNext(4, l + 305, i1 + 19, true);
        this.pauseCycling = new GuiButtonVariableDims(5, l + 285, i1 + 190, AMGuiHelper.instance.runCompendiumTicker ? StatCollector.func_74838_a((String)"am2.gui.pause") : StatCollector.func_74838_a((String)"am2.gui.cycle")).setDimensions(40, 20);
        if (this.entryMultiblock != null) {
            this.prevLayer.field_146125_m = true;
            this.nextLayer.field_146125_m = true;
            this.pauseCycling.field_146125_m = true;
            this.maxLayers = this.entryMultiblock.getHeight();
        } else {
            this.prevLayer.field_146125_m = false;
            this.nextLayer.field_146125_m = false;
            this.pauseCycling.field_146125_m = false;
        }
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.prevPage);
        this.field_146292_n.add(this.prevLayer);
        this.field_146292_n.add(this.nextLayer);
        this.field_146292_n.add(this.backToIndex);
        this.field_146292_n.add(this.pauseCycling);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        if (this.stackTip != null) {
            GuiArcaneCompendium newGuiToDisplay = null;
            if (this.stackTip.func_77973_b() instanceof ItemBlock) {
                String metaname;
                ItemBlock item = (ItemBlock)this.stackTip.func_77973_b();
                Block block = item.field_150939_a;
                String name = block.func_149739_a().replace("arsmagica2:", "").replace("tile.", "");
                String searchName = metaname = name + "@" + this.stackTip.func_77960_j();
                CompendiumEntry entry = ArcaneCompendium.instance.getEntry(metaname);
                if (entry == null) {
                    searchName = name;
                    entry = ArcaneCompendium.instance.getEntry(searchName);
                }
                if (entry != null) {
                    newGuiToDisplay = entry.getCompendiumGui(searchName);
                }
            } else if (this.stackTip.func_77973_b() == ItemsCommonProxy.spell_component) {
                String name = SkillManager.instance.getSkillName(SkillManager.instance.getSkill(this.stackTip.func_77960_j()));
                CompendiumEntry entry = ArcaneCompendium.instance.getEntry(name);
                if (entry != null) {
                    newGuiToDisplay = new GuiArcaneCompendium(name, this.stackTip.func_77973_b(), this.stackTip.func_77960_j());
                }
            } else {
                String metaname;
                String name = this.stackTip.func_77973_b().func_77658_a().replace("item.", "").replace("arsmagica2:", "");
                String searchName = metaname = name + "@" + this.stackTip.func_77960_j();
                CompendiumEntry entry = ArcaneCompendium.instance.getEntry(metaname);
                if (entry == null) {
                    searchName = name;
                    entry = ArcaneCompendium.instance.getEntry(searchName);
                }
                if (entry != null) {
                    newGuiToDisplay = entry.getCompendiumGui(searchName);
                }
            }
            if (newGuiToDisplay != null) {
                this.storeBreadcrumb();
                Minecraft.func_71410_x().func_147108_a(newGuiToDisplay);
            }
            return;
        }
        if (this.entryEntity != null) {
            this.isDragging = true;
            this.lastMouseX = par1;
        }
        super.func_73864_a(par1, par2, par3);
    }

    private void storeBreadcrumb() {
        if (this.ritualController != null) {
            AMGuiHelper.instance.pushCompendiumBreadcrumb(this.entryName, this.page, 1, this.entryMultiblock, this.blockAccess.func_147438_o(0, 0, 0), this.ritualController);
        } else if (this.entryItem != null) {
            AMGuiHelper.instance.pushCompendiumBreadcrumb(this.entryName, this.page, 1, this.entryItem, this.entryMeta);
        } else if (this.entryBlock != null) {
            AMGuiHelper.instance.pushCompendiumBreadcrumb(this.entryName, this.page, 1, this.entryBlock, this.entryMeta);
        } else if (this.entryEntity != null) {
            AMGuiHelper.instance.pushCompendiumBreadcrumb(this.entryName, this.page, 1, this.entryEntity);
        } else if (this.entryMultiblock != null) {
            AMGuiHelper.instance.pushCompendiumBreadcrumb(this.entryName, this.page, 1, this.entryMultiblock, this.blockAccess.func_147438_o(0, 0, 0));
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        if (this.isDragging && par3 == 1) {
            this.isDragging = false;
        }
        super.func_146286_b(par1, par2, par3);
    }

    protected void func_146273_a(int par1, int par2, int par3, long par4) {
        if (this.isDragging) {
            this.curRotationH -= this.lastMouseX - par1;
            this.lastMouseX = par1;
        }
        super.func_146273_a(par1, par2, par3, par4);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                if (this.page <= 0) break;
                --this.page;
                break;
            }
            case 1: {
                if (this.page >= this.numPages) break;
                ++this.page;
                break;
            }
            case 2: {
                AMGuiHelper.CompendiumBreadcrumb prevEntry = AMGuiHelper.instance.popCompendiumBreadcrumb();
                if (prevEntry != null) {
                    if (prevEntry.entryType == 1) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiArcaneCompendium(prevEntry));
                        break;
                    }
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCompendiumIndex(prevEntry));
                    break;
                }
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCompendiumIndex());
                break;
            }
            case 3: {
                --this.curLayer;
                if (this.curLayer >= -1) break;
                this.curLayer = this.maxLayers;
                break;
            }
            case 4: {
                ++this.curLayer;
                if (this.curLayer <= this.maxLayers) break;
                this.curLayer = -1;
                break;
            }
            case 5: {
                AMGuiHelper.instance.runCompendiumTicker = !AMGuiHelper.instance.runCompendiumTicker;
                this.pauseCycling.field_146126_j = AMGuiHelper.instance.runCompendiumTicker ? StatCollector.func_74838_a((String)"am2.gui.pause") : StatCollector.func_74838_a((String)"am2.gui.cycle");
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.framecount += 0.5f;
        this.framecount %= 360.0f;
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.stackTip = null;
        this.drawLeftPage(l, i1);
        this.drawRightPage(l, i1, par1, par2);
        this.prevPage.field_146125_m = this.page != 0;
        this.nextPage.field_146125_m = this.page != this.numPages;
        RenderHelper.func_74518_a();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(background);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect_Classic(l, i1, 0, 0, this.xSize, this.ySize, 256, 240);
        this.drawRightPageExtras(l, i1);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
        super.func_73863_a(par1, par2, par3);
        if (this.stackTip != null) {
            this.renderItemToolTip(this.stackTip, this.tipX, this.tipY);
        }
        if (this.entryMultiblock != null) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"am2.gui.mbb"), l + 190, i1 + 195, 0);
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.storeBreadcrumb();
            this.func_146281_b();
        }
        super.func_73869_a(par1, par2);
    }

    private void drawLeftPage(int l, int i1) {
        int y_start_line;
        if (this.entry == null) {
            return;
        }
        int y_start_title = i1 + 50;
        int x_start_title = l + 100 - this.field_146289_q.func_78256_a(this.entry.getName(this.entryName)) / 2;
        int x_start_line = l + 35;
        int n = y_start_line = this.page == 0 ? i1 + 65 : i1 + 50;
        if (this.page > this.numPages) {
            this.page = this.numPages;
        }
        if (this.entry != null) {
            if (this.page == 0) {
                this.field_146289_q.func_78276_b(this.entry.getName(this.entryName), x_start_title, y_start_title, 0);
            }
            AMGuiHelper.drawCompendiumText(this.lines.get(this.page), x_start_line, y_start_line, this.lineWidth, 0, this.field_146289_q);
        }
    }

    private void drawRightPage(int l, int i1, int mousex, int mousey) {
        int cx = l + 250;
        int cy = i1 + 120 - 6;
        if (this.entryBlock != null || this.entryItem != null) {
            this.drawRightPage_Block_Item(cx, cy, mousex, mousey);
        } else if (this.entryEntity != null) {
            this.drawRightPage_Entity(cx, cy);
        } else if (this.entryMultiblock != null) {
            this.drawRightPage_Multiblock(cx, cy, mousex, mousey);
        }
        this.drawRelatedItems(cx, cy, mousex, mousey);
        if (this.modifiers.size() > 0) {
            this.drawModifiers(cx, this.entryMultiblock == null ? cy : cy + 20, mousex, mousey);
        }
    }

    private void drawRightPageExtras(int l, int i1) {
        int cx = l + 256 - 6;
        int cy = i1 + 120 - 6;
        this.field_146297_k.field_71446_o.func_110577_a(extras);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawTexturedModalRect_Classic(l + 305, i1 + 15, 112, 145, 60, 40, 40, 40);
        this.drawTexturedModalRect_Classic(l + 180, i1 + 200, 112, 175, 60, 40, 40, 40);
        GL11.glDisable((int)3042);
        if (this.entryBlock != null || this.entryItem != null) {
            this.drawRightPageExtras_Block_Item(cx, cy);
        } else if (this.entryMultiblock == null) {
            this.drawRightPageExtras_Generic(cx, cy);
        }
    }

    private void drawRelatedItems(int cx, int cy, int mouseX, int mouseY) {
        if (this.relatedEntries.length == 0) {
            return;
        }
        int length = Math.min(this.relatedEntries.length, 5);
        int step = 18;
        int x = cx - length * step / 2 + step / 2;
        int y = cy + this.ySize / 2 - 32;
        y += 16;
        int count = 0;
        for (int i = 0; i < this.relatedEntries.length && count < 5; ++i) {
            ItemStack stack = this.relatedEntries[i];
            if (stack == null) continue;
            AMGuiHelper.DrawItemAtXY(stack, x, y, this.field_73735_i);
            if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
                this.stackTip = stack;
                this.tipX = mouseX;
                this.tipY = mouseY;
            }
            x += step;
            ++count;
        }
        y -= 16;
        if (count > 0) {
            String s = StatCollector.func_74838_a((String)"am2.gui.relatedItems");
            this.field_146289_q.func_78276_b(s, cx - this.xSize / 6, y, 0);
        }
    }

    private void drawModifiers(int cx, int cy, int mouseX, int mouseY) {
        int step = 18;
        String label = "";
        label = this.entryMultiblock != null ? StatCollector.func_74838_a((String)"am2.gui.ritual") : (this.entry instanceof CompendiumEntrySpellModifier ? StatCollector.func_74838_a((String)"am2.gui.modifies") : StatCollector.func_74838_a((String)"am2.gui.modifiedBy"));
        int x = cx - this.field_146289_q.func_78256_a(label) / 2;
        int y = cy - this.ySize / 2 + 28;
        this.field_146289_q.func_78276_b(label, x, y, 0);
        y += 12;
        x = cx - (int)((float)this.modifiers.size() / 2.0f * (float)step);
        for (ItemStack mod : this.modifiers) {
            if (mod != null) {
                AMGuiHelper.DrawItemAtXY(mod, x, y, this.field_73735_i);
                if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
                    this.stackTip = mod;
                    this.tipX = mouseX;
                    this.tipY = mouseY;
                }
            }
            x += step;
        }
    }

    private void drawRightPage_Entity(int cx, int cy) {
        double ex = cx;
        double ey = cy;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)(ex - 2.0)), (float)((float)(ey + 20.0)), (float)(-3.0f + GuiArcaneCompendium.itemRenderer.field_77023_b));
        GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
        GL11.glTranslatef((float)1.0f, (float)6.5f, (float)1.0f);
        GL11.glScalef((float)6.0f, (float)6.0f, (float)-1.0f);
        GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderEntityIntoUI();
        GL11.glPopMatrix();
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        String renderString = "Click and drag to rotate";
        this.field_146289_q.func_78276_b(renderString, cx - this.field_146289_q.func_78256_a(renderString) / 2, i1 + 20, 0);
    }

    private void renderEntityIntoUI() {
        Render render = (Render)RenderManager.field_78727_a.field_78729_o.get(this.entryEntity.getClass());
        if (render != null) {
            GL11.glPushMatrix();
            if (this.entryEntity instanceof IArsMagicaBoss) {
                float scaleFactorX = 1.0f / this.entryEntity.field_70130_N;
                float scaleFactorY = 2.0f / this.entryEntity.field_70131_O;
                GL11.glScalef((float)scaleFactorX, (float)scaleFactorY, (float)scaleFactorX);
            } else if (this.entryEntity instanceof EntityFlicker) {
                GL11.glTranslatef((float)0.0f, (float)1.3f, (float)0.0f);
            }
            GL11.glRotatef((float)this.curRotationH, (float)0.0f, (float)1.0f, (float)0.0f);
            render.func_76986_a(this.entryEntity, 0.0, 0.0, 0.0, 90.0f, 0.0f);
            GL11.glPopMatrix();
        }
    }

    private void drawRightPage_Block_Item(int cx, int cy, int mousex, int mousey) {
        RenderHelper.func_74518_a();
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        if (this.craftingComponents == null) {
            AMGuiHelper.DrawItemAtXY(this.renderStack, cx, cy, this.field_73735_i);
            if (mousex > cx && mousex < cx + 16 && mousey > cy && mousey < cy + 16) {
                this.stackTip = this.renderStack;
                this.tipX = mousex;
                this.tipY = mousey;
            }
        } else {
            this.RenderRecipe(cx, cy, mousex, mousey);
        }
        if (this.renderStack.func_77973_b() instanceof ItemSpellPart) {
            IIcon icon = SpellIconManager.instance.getIcon(this.entryName);
            this.field_146297_k.field_71446_o.func_110577_a(items);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.DrawIconAtXY(icon, cx, cy, 16, 16);
        }
        RenderHelper.func_74519_b();
    }

    private void drawRightPageExtras_Block_Item(int cx, int cy) {
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        if (this.craftingComponents == null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.drawTexturedModalRect_Classic(cx - 77, cy - 68, 0, 101, 150, 150, 100, 147);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.renderStack.func_77973_b() == ItemsCommonProxy.essence || this.renderStack.func_77973_b() == ItemsCommonProxy.deficitCrystal) {
                this.drawTexturedModalRect_Classic(cx - 43, cy - 45, 367, 0, 105, 105, 70, 105);
            } else if (this.renderStack.func_77973_b() != ItemsCommonProxy.spell_component) {
                this.drawTexturedModalRect_Classic(cx - 43, cy - 43, 0, 0, 100, 100, 67, 95);
            }
            GL11.glDisable((int)3042);
        }
    }

    private void renderItemToolTip(ItemStack stack, int x, int y) {
        try {
            FontRenderer font;
            CompendiumEntry entry;
            List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock item = (ItemBlock)stack.func_77973_b();
                Block block = item.field_150939_a;
                String name = block.func_149739_a().replace("arsmagica2:", "").replace("tile.", "");
                String metaname = name + "@" + stack.func_77960_j();
                entry = ArcaneCompendium.instance.getEntry(metaname);
                if (entry == null) {
                    entry = ArcaneCompendium.instance.getEntry(name);
                }
            } else if (stack.func_77973_b() == ItemsCommonProxy.spell_component) {
                list.clear();
                ISkillTreeEntry skill = SkillManager.instance.getSkill(stack.func_77960_j());
                if (skill == null) {
                    return;
                }
                list.add(SkillManager.instance.getDisplayName(skill));
                entry = ArcaneCompendium.instance.getEntry(SkillManager.instance.getSkillName(skill));
            } else {
                String name = stack.func_77973_b().func_77658_a().replace("item.", "").replace("arsmagica2:", "");
                String metaname = name + "@" + stack.func_77960_j();
                entry = ArcaneCompendium.instance.getEntry(metaname);
                if (entry == null) {
                    entry = ArcaneCompendium.instance.getEntry(name);
                }
            }
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    if (entry != null) {
                        list.set(k, "\u00a72" + (String)list.get(k));
                        continue;
                    }
                    list.set(k, "\u00a7" + stack.func_77953_t().field_77937_e.func_96298_a() + (String)list.get(k));
                    continue;
                }
                list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
            }
            if (((String)list.get(0)).indexOf(10) != -1) {
                String s = (String)list.get(0);
                String colorPrefix = "";
                list.remove(0);
                colorPrefix = entry != null ? "\u00a72" : "\u00a7" + stack.func_77953_t().field_77937_e.func_96298_a();
                String[] split = s.split("\n");
                for (int i = split.length - 1; i >= 0; --i) {
                    list.add(0, colorPrefix + split[i]);
                }
            }
            this.drawHoveringText(list, x, y, (font = stack.func_77973_b().getFontRenderer(stack)) == null ? this.field_146289_q : font);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    protected void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            GuiArcaneCompendium.itemRenderer.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GuiArcaneCompendium.itemRenderer.field_77023_b = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    private void drawRightPage_Multiblock(int cx, int cy, int mousex, int mousey) {
        String label = String.format("%s: %s", StatCollector.func_74838_a((String)"am2.gui.layer"), this.curLayer == -1 ? StatCollector.func_74838_a((String)"am2.gui.all") : "" + this.curLayer);
        this.field_146289_q.func_78276_b(label, cx - this.field_146289_q.func_78256_a(label) / 2, cy - 90, 0);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)278848);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        MultiblockStructureDefinition.BlockCoord pickedBlock = this.getPickedBlock(cx, cy, mousex, mousey);
        if (this.curLayer == -1) {
            for (int i = this.entryMultiblock.getMinLayer(); i <= this.entryMultiblock.getMaxLayer(); ++i) {
                int y = i - this.entryMultiblock.getMinLayer();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(20.0f * (float)y));
                this.drawMultiblockLayer(cx, cy, i, pickedBlock, mousex, mousey);
            }
        } else {
            int i = this.entryMultiblock.getMinLayer() + this.curLayer;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(20.0f * (float)this.curLayer));
            this.drawMultiblockLayer(cx, cy, i, pickedBlock, mousex, mousey);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private TreeMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>> getMultiblockLayer(int layer) {
        TreeMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>> layerBlocksSorted = new TreeMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>>();
        for (int mutex : this.entryMultiblock.getMutexList()) {
            ArrayList<MultiblockStructureDefinition.StructureGroup> groups = this.entryMultiblock.getGroupsForMutex(mutex);
            MultiblockStructureDefinition.StructureGroup selected = groups.get(AMGuiHelper.instance.getSlowTicker() % groups.size());
            HashMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>> layerBlocks = this.entryMultiblock.getStructureLayer(selected, layer);
            for (MultiblockStructureDefinition.BlockCoord bc : layerBlocks.keySet()) {
                layerBlocksSorted.put(bc, layerBlocks.get(bc));
            }
        }
        return layerBlocksSorted;
    }

    private MultiblockStructureDefinition.BlockCoord getPickedBlock(int cx, int cy, int mousex, int mousey) {
        MultiblockStructureDefinition.BlockCoord block = null;
        float step_x = 14.0f;
        float step_y = -16.0f;
        float step_z = 7.0f;
        cy = (int)((float)cy - step_y * (float)this.entryMultiblock.getMinLayer() / 2.0f);
        cy = (int)((float)cy - step_y * (float)this.entryMultiblock.getMaxLayer() / 2.0f);
        int start = this.curLayer == -1 ? this.entryMultiblock.getMinLayer() : this.entryMultiblock.getMinLayer() + this.curLayer;
        int end = this.curLayer == -1 ? this.entryMultiblock.getMaxLayer() : this.entryMultiblock.getMinLayer() + this.curLayer;
        for (int i = start; i <= end; ++i) {
            TreeMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>> layerBlocksSorted = this.getMultiblockLayer(i);
            float px = (float)cx - step_x * (float)(this.entryMultiblock.getWidth() / 2);
            float py = (float)cy - step_z * (float)(this.entryMultiblock.getLength() / 2);
            for (MultiblockStructureDefinition.BlockCoord bc : layerBlocksSorted.keySet()) {
                MultiblockStructureDefinition.BlockDec bd = layerBlocksSorted.get(bc).get(0);
                float x = px + (float)(bc.getX() - bc.getZ()) * step_x;
                float y = py + (float)(bc.getZ() + bc.getX()) * step_z + step_y * (float)i;
                x += 20.0f;
                y -= 10.0f;
                if (!((float)mousex > x) || !((float)mousex < x + 32.0f) || !((float)mousey > y) || !((float)mousey < y + 32.0f)) continue;
                block = bc;
            }
        }
        return block;
    }

    private void drawMultiblockLayer(int cx, int cy, int layer, MultiblockStructureDefinition.BlockCoord pickedBlock, int mousex, int mousey) {
        TreeMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>> layerBlocksSorted = this.getMultiblockLayer(layer);
        float step_x = 14.0f;
        float step_y = -16.0f;
        float step_z = 7.0f;
        cy = (int)((float)cy - step_y * (float)this.entryMultiblock.getMinLayer() / 2.0f);
        cy = (int)((float)cy - step_y * (float)this.entryMultiblock.getMaxLayer() / 2.0f);
        float px = (float)cx - step_x * (float)(this.entryMultiblock.getWidth() / 2);
        float py = (float)cy - step_z * (float)(this.entryMultiblock.getLength() / 2);
        for (MultiblockStructureDefinition.BlockCoord bc : layerBlocksSorted.keySet()) {
            ItemStack stack;
            MultiblockStructureDefinition.BlockDec bd = layerBlocksSorted.get(bc).get(AMGuiHelper.instance.getSlowTicker() % layerBlocksSorted.get(bc).size());
            float x = px + (float)(bc.getX() - bc.getZ()) * step_x;
            float y = py + (float)(bc.getZ() + bc.getX()) * step_z + step_y * (float)layer;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(15 * bc.getX()));
            boolean picked = pickedBlock != null && bc.equals(pickedBlock);
            this.renderBlock(bd.getBlock(), bd.getMeta(), x, y, bc.getX(), bc.getY(), bc.getZ(), picked);
            GL11.glPopMatrix();
            if (!picked || (stack = new ItemStack(bd.getBlock(), 1, bd.getMeta())).func_77973_b() == null) continue;
            this.stackTip = stack;
            this.tipX = mousex;
            this.tipY = mousey;
        }
    }

    private void drawRightPageExtras_Generic(int cx, int cy) {
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(extras);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawTexturedModalRect_Classic(cx - 77, cy - 68, 0, 101, 150, 150, 100, 147);
        GL11.glDisable((int)3042);
    }

    private void RenderRecipe(int cx, int cy, int mousex, int mousey) {
        int step = 32;
        int sx = cx - step;
        int sy = cy - step;
        if (this.craftingComponents == null) {
            return;
        }
        if (this.renderStack.func_77973_b() == ItemsCommonProxy.essence || this.renderStack.func_77973_b() == ItemsCommonProxy.deficitCrystal) {
            this.renderCraftingComponent(0, cx, cy - 36, mousex, mousey);
            this.renderCraftingComponent(1, cx - 30, cy - 2, mousex, mousey);
            this.renderCraftingComponent(2, cx, cy - 2, mousex, mousey);
            this.renderCraftingComponent(3, cx + 28, cy - 2, mousex, mousey);
            this.renderCraftingComponent(4, cx, cy + 30, mousex, mousey);
            return;
        }
        if (this.renderStack.func_77973_b() == ItemsCommonProxy.spell_component) {
            float angleStep = 360.0f / (float)this.craftingComponents.length;
            for (int i = 0; i < this.craftingComponents.length; ++i) {
                float angle = (float)Math.toRadians(angleStep * (float)i + this.framecount % 360.0f);
                float nextangle = (float)Math.toRadians(angleStep * (float)((i + 1) % this.craftingComponents.length) + this.framecount % 360.0f);
                float dist = 45.0f;
                int x = (int)Math.round((double)cx - Math.cos(angle) * (double)dist);
                int y = (int)Math.round((double)cy - Math.sin(angle) * (double)dist);
                int nextx = (int)Math.round((double)cx - Math.cos(nextangle) * (double)dist);
                int nexty = (int)Math.round((double)cy - Math.sin(nextangle) * (double)dist);
                AMGuiHelper.line2d(x + 8, y + 8, cx + 8, cy + 8, this.field_73735_i, 221);
                AMGuiHelper.gradientline2d(x + 8, y + 8, nextx + 8, nexty + 8, this.field_73735_i, 221, 0xDD00DD);
                this.renderCraftingComponent(i, x, y, mousex, mousey);
            }
            return;
        }
        if (this.recipeHeight > 0) {
            for (int i = 0; i < this.recipeHeight; ++i) {
                for (int j = 0; j < this.recipeWidth; ++j) {
                    int index = i * this.recipeWidth + j;
                    this.renderCraftingComponent(index, sx, sy, mousex, mousey);
                    sx += step;
                }
                sx = cx - step;
                sy += step;
            }
        } else {
            int col = 0;
            int row = 0;
            int widthSq = (int)Math.ceil(Math.sqrt(this.recipeWidth));
            String label = "\u00a7nShapeless";
            this.field_146289_q.func_78276_b(label, cx - (int)((double)this.field_146289_q.func_78256_a(label) / 2.5), cy - step * 3, 0x6600FF);
            for (int i = 0; i < this.recipeWidth; ++i) {
                sx = cx - step + step * col;
                sy = cy - step + step * row;
                int index = row * widthSq + col++;
                if (col >= widthSq) {
                    ++row;
                    col = 0;
                }
                this.renderCraftingComponent(index, sx, sy, mousex, mousey);
            }
        }
        sx = cx;
        sy = cy - (int)(2.5 * (double)step);
        if (this.renderStack != null) {
            AMGuiHelper.DrawItemAtXY(this.renderStack, sx, sy, this.field_73735_i);
            if (this.renderStack.field_77994_a > 1) {
                this.field_146289_q.func_85187_a("x" + this.renderStack.field_77994_a, sx + 16, sy + 8, 0, false);
            }
            if (mousex > sx && mousex < sx + 16 && mousey > sy && mousey < sy + 16) {
                this.stackTip = this.renderStack;
                this.tipX = mousex;
                this.tipY = mousey;
            }
        }
    }

    private void renderCraftingComponent(int index, int sx, int sy, int mousex, int mousey) {
        Object craftingComponent = this.craftingComponents[index];
        if (craftingComponent == null) {
            return;
        }
        ItemStack stack = null;
        if (craftingComponent instanceof ItemStack) {
            stack = (ItemStack)craftingComponent;
        } else if (craftingComponent instanceof List) {
            if (((List)craftingComponent).size() == 0) {
                return;
            }
            int idx = new Random(AMGuiHelper.instance.getSlowTicker()).nextInt(((List)craftingComponent).size());
            stack = ((ItemStack)((List)craftingComponent).get(idx)).func_77946_l();
        }
        ArrayList oredict = OreDictionary.getOres((String)stack.func_77973_b().func_77658_a());
        ArrayList<ItemStack> alternates = new ArrayList<ItemStack>();
        alternates.addAll(oredict);
        if (alternates.size() > 0) {
            alternates.add(stack);
            stack = (ItemStack)alternates.get(new Random(AMGuiHelper.instance.getSlowTicker()).nextInt(alternates.size()));
        }
        if (this.forcedMetas.containsKey(stack.func_77973_b())) {
            stack = new ItemStack(stack.func_77973_b(), stack.field_77994_a, this.forcedMetas.get(stack.func_77973_b()).intValue());
        }
        try {
            AMGuiHelper.DrawItemAtXY(stack, sx, sy, this.field_73735_i);
            RenderHelper.func_74518_a();
        }
        catch (Throwable t) {
            this.forcedMetas.put(stack.func_77973_b(), 0);
        }
        if (mousex > sx && mousex < sx + 16 && mousey > sy && mousey < sy + 16) {
            this.stackTip = stack;
            this.tipX = mousex;
            this.tipY = mousey;
        }
    }

    private void renderBlock(Block block, int meta, float x, float y, int offsetX, int offsetY, int offsetZ, boolean picked) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 15) {
            meta = 15;
        }
        RenderHelper.func_74518_a();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x + 15.0f), (float)(y + 3.0f), (float)(12.0f * (float)offsetZ));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)40.0f);
        GL11.glScalef((float)20.0f, (float)20.0f, (float)20.0f);
        GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.blockAccess.setFakeBlockAndMeta(block, meta);
        GuiArcaneCompendium.blockRenderer.field_147837_f = true;
        if (picked) {
            this.field_146297_k.field_71446_o.func_110577_a(red);
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(terrain);
        }
        if (block.func_149645_b() == BlocksCommonProxy.blockRenderID) {
            GuiArcaneCompendium.blockRenderer.field_147844_c = false;
            if (picked) {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glColor3f((float)0.8f, (float)0.8f, (float)0.8f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
            blockRenderer.func_147800_a(block, meta, 0.0f);
        } else {
            Tessellator.field_78398_a.func_78382_b();
            blockRenderer.func_147805_b(block, 0, 0, 0);
            Tessellator.field_78398_a.func_78381_a();
        }
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    public static ArrayList<String> splitStringToLines(FontRenderer fontRenderer, String string, int lineWidth, int maxLines) {
        ArrayList<String> toReturn = new ArrayList<String>();
        int numLines = 0;
        int len = 0;
        int pageCount = 0;
        String[] words = string.replace("\n", " ").replace("\t", "").split(" ");
        StringBuilder sb = new StringBuilder();
        String curLine = "";
        for (String s : words) {
            s = s.trim();
            int wordWidth = fontRenderer.func_78256_a(s + " ");
            if (s.equals("!p")) {
                sb.append(curLine);
                curLine = "";
                len = 0;
                ++numLines;
                toReturn.add(sb.toString());
                sb = new StringBuilder();
                ++pageCount;
                numLines = 0;
                continue;
            }
            if (s.equals("!l")) {
                sb.append(curLine + "\n");
                curLine = "";
                len = 0;
                if ((++numLines != maxLines || pageCount <= 0) && (pageCount != 0 || numLines != maxLines - 2)) continue;
                toReturn.add(sb.toString());
                sb = new StringBuilder();
                ++pageCount;
                numLines = 0;
                continue;
            }
            if (s.equals("!d")) {
                sb.append(curLine + "\n");
                curLine = "";
                len = 0;
                if (++numLines == maxLines && pageCount > 0 || pageCount == 0 && numLines == maxLines - 2) {
                    toReturn.add(sb.toString());
                    sb = new StringBuilder();
                    ++pageCount;
                    numLines = 0;
                }
                sb.append(curLine + "\n");
                curLine = "";
                len = 0;
                if ((++numLines != maxLines || pageCount <= 0) && (pageCount != 0 || numLines != maxLines - 2)) continue;
                toReturn.add(sb.toString());
                sb = new StringBuilder();
                ++pageCount;
                numLines = 0;
                continue;
            }
            if (len + wordWidth > lineWidth) {
                sb.append(curLine);
                curLine = "";
                len = 0;
                if (++numLines == maxLines && pageCount > 0 || pageCount == 0 && numLines == maxLines - 2) {
                    toReturn.add(sb.toString());
                    sb = new StringBuilder();
                    ++pageCount;
                    numLines = 0;
                }
            }
            curLine = curLine + " " + s;
            len += wordWidth + 1;
        }
        sb.append(curLine);
        if (sb.length() > 0) {
            toReturn.add(sb.toString());
        }
        return toReturn;
    }

    public void drawTexturedModalRect_Classic(int dst_x, int dst_y, int src_x, int src_y, int dst_width, int dst_height, int src_width, int src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(dst_x + 0), (double)(dst_y + dst_height), (double)this.field_73735_i, (double)((float)(src_x + 0) * var7), (double)((float)(src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.field_73735_i, (double)((float)(src_x + src_width) * var7), (double)((float)(src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + 0), (double)this.field_73735_i, (double)((float)(src_x + src_width) * var7), (double)((float)(src_y + 0) * var8));
        var9.func_78374_a((double)(dst_x + 0), (double)(dst_y + 0), (double)this.field_73735_i, (double)((float)(src_x + 0) * var7), (double)((float)(src_y + 0) * var8));
        var9.func_78381_a();
    }

    private void DrawIconAtXY(IIcon icon, float x, float y, int w, int h) {
        if (icon == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + (float)h), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)(y + (float)h), (double)this.field_73735_i, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)y, (double)this.field_73735_i, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public void func_146281_b() {
        ArcaneCompendium.instance.saveUnlockData();
        super.func_146281_b();
    }
}

