/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class SpawnBlacklists {
    private static ArrayListMultimap<Integer, Class> blacklistedDimensionSpawns = ArrayListMultimap.create();
    private static ArrayListMultimap<Integer, Class> blacklistedBiomeSpawns = ArrayListMultimap.create();
    private static ArrayList<Integer> blacklistedWorldgenDimensions = new ArrayList();
    private static ArrayList<Class> progenyBlacklist = new ArrayList();
    private static ArrayList<Class> butcheryBlacklist = new ArrayList();

    public static void addBlacklistedDimensionSpawn(String entityClass, Integer dimensionID) {
        try {
            Class<?> clazz = Class.forName(entityClass);
            blacklistedDimensionSpawns.put((Object)dimensionID, clazz);
            FMLLog.info((String)"Ars Magica 2 >> Blacklisted %s from spawning in dimension %d.", (Object[])new Object[]{entityClass, dimensionID});
        }
        catch (ClassNotFoundException e) {
            FMLLog.info((String)"Ars Magica 2 >> Unable to parse class name %s from IMC!  This needs to be corrected by the other mod author!", (Object[])new Object[]{entityClass});
        }
    }

    public static void addBlacklistedBiomeSpawn(String entityClass, Integer biomeID) {
        try {
            Class<?> clazz = Class.forName(entityClass);
            blacklistedBiomeSpawns.put((Object)biomeID, clazz);
            FMLLog.info((String)"Ars Magica 2 >> Blacklisted %s from spawning in biome %d.", (Object[])new Object[]{entityClass, biomeID});
        }
        catch (ClassNotFoundException e) {
            FMLLog.info((String)"Ars Magica 2 >> Unable to parse class name %s from IMC!  This needs to be corrected by the other mod author!", (Object[])new Object[]{entityClass});
        }
    }

    public static boolean entityCanSpawnHere(double x, double z, World world, EntityLivingBase entity) {
        if (blacklistedDimensionSpawns.containsEntry((Object)world.field_73011_w.field_76574_g, entity.getClass())) {
            return false;
        }
        BiomeGenBase biome = world.func_72807_a((int)x, (int)z);
        return !blacklistedBiomeSpawns.containsEntry((Object)biome.field_76756_M, entity.getClass());
    }

    public static void addBlacklistedDimensionForWorldgen(int dimensionID) {
        if (dimensionID == 0 || dimensionID == -1) {
            return;
        }
        blacklistedWorldgenDimensions.add(dimensionID);
    }

    public static boolean worldgenCanHappenInDimension(int dimensionID) {
        return !blacklistedWorldgenDimensions.contains(dimensionID);
    }

    public static void addButcheryBlacklist(Class clazz) {
        if (!butcheryBlacklist.contains(clazz)) {
            butcheryBlacklist.add(clazz);
        }
    }

    public static void addProgenyBlacklist(Class clazz) {
        if (!progenyBlacklist.contains(clazz)) {
            progenyBlacklist.add(clazz);
        }
    }

    public static boolean canButcheryAffect(Class clazz) {
        return !butcheryBlacklist.contains(clazz);
    }

    public static boolean canProgenyAffect(Class clazz) {
        return !progenyBlacklist.contains(clazz);
    }
}

