/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses.ai;

import am2.api.math.AMVector3;
import am2.bosses.BossActions;
import am2.bosses.EntityAirGuardian;
import am2.damage.DamageSources;
import am2.entities.EntityWhirlwind;
import am2.network.AMNetHandler;
import am2.utility.MathUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;

public class EntityAIHurricane
extends EntityAIBase {
    private final EntityAirGuardian host;
    private final float moveSpeed;
    private EntityLivingBase target;
    private int cooldownTicks = 0;

    public EntityAIHurricane(EntityAirGuardian host, float moveSpeed) {
        this.host = host;
        this.moveSpeed = moveSpeed;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.cooldownTicks-- > 0 || this.host.getCurrentAction() != BossActions.IDLE || !this.host.isActionValid(BossActions.SPINNING)) {
            return false;
        }
        EntityLivingBase AITarget = this.host.func_70638_az();
        if (AITarget == null || AITarget.field_70128_L || AITarget.func_70068_e((Entity)this.host) > 25.0) {
            return false;
        }
        this.target = AITarget;
        this.host.setCurrentAction(BossActions.SPINNING);
        return true;
    }

    public boolean func_75253_b() {
        EntityLivingBase AITarget = this.host.func_70638_az();
        if (this.host.hitCount >= 10) {
            this.host.setCurrentAction(BossActions.IDLE);
            this.cooldownTicks = 20;
            return false;
        }
        if (AITarget == null || AITarget.field_70128_L || this.host.getTicksInCurrentAction() > BossActions.SPINNING.getMaxActionTime()) {
            if (!this.host.field_70170_p.field_72995_K) {
                int y = (int)this.host.field_70163_u + 1;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        while (!this.host.field_70170_p.func_72937_j((int)this.host.field_70165_t + x, y, (int)this.host.field_70161_v + z) && this.host.field_70170_p.func_147439_a((int)this.host.field_70165_t + x, y, (int)this.host.field_70161_v + z) != Blocks.field_150357_h) {
                            this.host.field_70170_p.func_147478_e((int)this.host.field_70165_t + x, y++, (int)this.host.field_70161_v + z, true);
                        }
                        y = (int)this.host.field_70163_u + 2;
                    }
                }
            }
            List nearbyEntities = this.host.field_70170_p.func_72872_a(EntityLivingBase.class, this.host.field_70121_D.func_72314_b(2.0, 2.0, 2.0));
            for (EntityLivingBase ent : nearbyEntities) {
                if (ent == this.host) continue;
                AMVector3 movement = MathUtilities.GetMovementVectorBetweenPoints(new AMVector3((Entity)this.host), new AMVector3((Entity)ent));
                float factor = 2.15f;
                double x = -(movement.x * factor);
                double y = 2.5;
                double z = -(movement.z * factor);
                ent.func_70097_a((DamageSource)DamageSources.causeEntityWindDamage((EntityLivingBase)this.host), 12.0f);
                ent.func_70024_g(x, y, z);
                if (ent instanceof EntityPlayer) {
                    AMNetHandler.INSTANCE.sendVelocityAddPacket(this.host.field_70170_p, ent, x, y, z);
                }
                ent.field_70143_R = 0.0f;
            }
            this.host.setCurrentAction(BossActions.IDLE);
            this.cooldownTicks = 20;
            return false;
        }
        return true;
    }

    public void func_75246_d() {
        this.host.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        List nearbyEntities = this.host.field_70170_p.func_72872_a(EntityLivingBase.class, this.host.field_70121_D.func_72314_b(6.0, 3.0, 6.0));
        for (EntityLivingBase ent : nearbyEntities) {
            if (ent == this.host) continue;
            if (!this.host.field_70170_p.field_72995_K && ent instanceof EntityWhirlwind) {
                ent.func_70106_y();
                continue;
            }
            AMVector3 movement = MathUtilities.GetMovementVectorBetweenPoints(new AMVector3((Entity)this.host).add(new AMVector3(0.0, this.host.func_70047_e(), 0.0)), new AMVector3((Entity)ent));
            float factor = 0.18f;
            double x = movement.x * factor;
            double y = movement.y * factor;
            double z = movement.z * factor;
            double oX = ent.field_70159_w;
            double oY = ent.field_70181_x;
            double oZ = ent.field_70179_y;
            ent.func_70024_g(x, y, z);
            if (Math.abs(ent.field_70159_w) > Math.abs(x * 2.0)) {
                ent.field_70159_w = x * (ent.field_70159_w / ent.field_70159_w);
            }
            if (Math.abs(ent.field_70181_x) > Math.abs(y * 2.0)) {
                ent.field_70181_x = y * (ent.field_70181_x / ent.field_70181_x);
            }
            if (Math.abs(ent.field_70179_y) > Math.abs(z * 2.0)) {
                ent.field_70179_y = z * (ent.field_70179_y / ent.field_70179_y);
            }
            if (ent instanceof EntityPlayer) {
                AMNetHandler.INSTANCE.sendVelocityAddPacket(this.host.field_70170_p, ent, -(oX - ent.field_70159_w), -(oY - ent.field_70181_x), -(oZ - ent.field_70179_y));
            }
            ent.field_70143_R = 0.0f;
        }
    }
}

