/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAIDispel;
import am2.bosses.ai.ISpellCastCallback;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.utility.NPCSpells;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityArcaneGuardian
extends AM2Boss {
    private float runeRotationZ = 0.0f;
    private float runeRotationY = 0.0f;
    private static final int DW_TARGET_ID = 20;

    public EntityArcaneGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 2.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)-1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(115.0);
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.7999998927116394;
        }
        this.updateRotations();
        if (!this.field_70170_p.field_72995_K) {
            int eid = this.field_70180_af.func_75679_c(20);
            int tid = -1;
            if (this.func_70638_az() != null) {
                tid = this.func_70638_az().func_145782_y();
            }
            if (eid != tid) {
                this.field_70180_af.func_75692_b(20, (Object)tid);
            }
        }
        super.func_70071_h_();
    }

    private void updateRotations() {
        this.runeRotationZ = 0.0f;
        float targetRuneRotationY = 0.0f;
        float runeRotationSpeed = 0.3f;
        if (this.getTarget() != null) {
            double deltaX = this.getTarget().field_70165_t - this.field_70165_t;
            double deltaZ = this.getTarget().field_70161_v - this.field_70161_v;
            double angle = Math.atan2(deltaZ, deltaX);
            targetRuneRotationY = (float)(angle -= Math.toRadians(MathHelper.func_76142_g((float)(this.field_70177_z + 90.0f)) + 180.0f));
            runeRotationSpeed = 0.085f;
        }
        if (targetRuneRotationY > this.runeRotationY) {
            this.runeRotationY += runeRotationSpeed;
        } else if (targetRuneRotationY < this.runeRotationY) {
            this.runeRotationY -= runeRotationSpeed;
        }
        if (this.isWithin(this.runeRotationY, targetRuneRotationY, 0.25f)) {
            this.runeRotationY = targetRuneRotationY;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76364_f() == null) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        if (this.checkRuneRetaliation(par1DamageSource)) {
            return super.func_70097_a(par1DamageSource, par2);
        }
        return false;
    }

    private boolean checkRuneRetaliation(DamageSource damagesource) {
        Entity source = damagesource.func_76364_f();
        double deltaX = source.field_70165_t - this.field_70165_t;
        double deltaZ = source.field_70161_v - this.field_70161_v;
        double angle = Math.atan2(deltaZ, deltaX);
        float targetRuneRotationY = (float)(angle -= Math.toRadians(MathHelper.func_76142_g((float)(this.field_70177_z + 90.0f)) + 180.0f));
        if (this.isWithin(this.runeRotationY, targetRuneRotationY, 0.5f) && this.func_70068_e(source) < 9.0) {
            double speed = 2.5;
            double vertSpeed = 0.325;
            deltaZ = source.field_70161_v - this.field_70161_v;
            deltaX = source.field_70165_t - this.field_70165_t;
            double radians = angle = Math.atan2(deltaZ, deltaX);
            if (source instanceof EntityPlayer) {
                AMNetHandler.INSTANCE.sendVelocityAddPacket(source.field_70170_p, (EntityLivingBase)source, speed * Math.cos(radians), vertSpeed, speed * Math.sin(radians));
            }
            source.field_70159_w = speed * Math.cos(radians);
            source.field_70179_y = speed * Math.sin(radians);
            source.field_70181_x = vertSpeed;
            source.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        }
        return true;
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        return damageAmt;
    }

    private boolean isWithin(float source, float target, float tolerance) {
        return source + tolerance > target && source - tolerance < target;
    }

    private Entity getTarget() {
        int eid = this.field_70180_af.func_75679_c(20);
        if (eid == -1) {
            return null;
        }
        return this.field_70170_p.func_73045_a(eid);
    }

    public float getRuneRotationZ() {
        return this.runeRotationZ;
    }

    public float getRuneRotationY() {
        return this.runeRotationY;
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDispel(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICastSpell(this, NPCSpells.instance.healSelf, 16, 23, 60, BossActions.CASTING, new ISpellCastCallback<EntityArcaneGuardian>(){

            @Override
            public boolean shouldCast(EntityArcaneGuardian host, ItemStack spell) {
                return host.func_110143_aJ() < host.func_110138_aP();
            }
        }));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICastSpell(this, NPCSpells.instance.blink, 16, 23, 20, BossActions.CASTING));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICastSpell(this, NPCSpells.instance.arcaneBolt, 12, 23, 5, BossActions.CASTING));
    }

    @Override
    public void setCurrentAction(BossActions action) {
        super.setCurrentAction(action);
        if (!this.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendActionUpdateToAllAround(this);
        }
    }

    public int func_70658_aO() {
        return 9;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, 18), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.essence, 1, 0), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemsCommonProxy.arcaneSpellBookEnchanted.func_77946_l(), 0.0f);
        }
    }

    protected void func_70069_a(float par1) {
    }

    protected String func_70621_aR() {
        return "arsmagica2:mob.arcaneguardian.hit";
    }

    protected String func_70673_aS() {
        return "arsmagica2:mob.arcaneguardian.death";
    }

    protected String func_70639_aQ() {
        return "arsmagica2:mob.arcaneguardian.idle";
    }

    @Override
    public String getAttackSound() {
        return "arsmagica2:mob.arcaneguardian.spell";
    }
}

