/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FlickerOperatorContainment
implements IFlickerFunctionality {
    protected static final int BASE_RADIUS = 6;

    protected void setUtilityBlock(World world, int x, int y, int z, int meta) {
        if (world.func_147439_a(x, y, z) == BlocksCommonProxy.invisibleUtility) {
            int exMeta = world.func_72805_g(x, y, z);
            if (meta == exMeta) {
                return;
            }
            if ((meta == 3 || meta == 4) && exMeta == 7) {
                return;
            }
            if ((meta == 6 || meta == 5) && exMeta == 8) {
                return;
            }
            if (meta == 3 && exMeta == 4 || meta == 4 && exMeta == 3) {
                meta = 7;
            } else if (meta == 5 && exMeta == 6 || meta == 6 && exMeta == 5) {
                meta = 8;
            }
            world.func_147465_d(x, y, z, (Block)BlocksCommonProxy.invisibleUtility, meta, 2);
        } else if (world.func_147437_c(x, y, z)) {
            world.func_147465_d(x, y, z, (Block)BlocksCommonProxy.invisibleUtility, meta, 2);
        }
    }

    protected void clearUtilityBlock(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == BlocksCommonProxy.invisibleUtility) {
            world.func_147468_f(x, y, z);
        }
    }

    protected void setLastRadius(IFlickerController habitat, int radius) {
        habitat.setMetadata(this, new AMDataWriter().add(radius).generate());
    }

    protected int getLastRadius(IFlickerController habitat) {
        byte[] meta = habitat.getMetadata(this);
        if (meta == null || meta.length == 0) {
            return 6;
        }
        AMDataReader rdr = new AMDataReader(meta, false);
        return rdr.getInt();
    }

    protected int calculateRadius(Affinity[] flickers) {
        int rad = 6;
        for (Affinity aff : flickers) {
            if (aff != Affinity.ICE) continue;
            ++rad;
        }
        return rad;
    }

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 5;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        int calcRadius;
        if (worldObj.field_72995_K) {
            return true;
        }
        int lastRadius = this.getLastRadius(habitat);
        if (lastRadius != (calcRadius = this.calculateRadius(flickers))) {
            this.RemoveOperator(worldObj, habitat, powered, flickers);
        }
        boolean hasArcaneAugment = false;
        for (Affinity aff : flickers) {
            if (aff != Affinity.ARCANE) continue;
            hasArcaneAugment = true;
            break;
        }
        for (int i = 0; i < calcRadius * 2 + 1; ++i) {
            if (hasArcaneAugment) {
                this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c - calcRadius, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + calcRadius + 1 - i, 9);
                this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c + calcRadius + 1, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e - calcRadius + i, 9);
                this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c - calcRadius + i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e - calcRadius, 9);
                this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c + calcRadius + 1 - i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + calcRadius + 1, 9);
                continue;
            }
            this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c - calcRadius, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + calcRadius + 1 - i, i == 0 ? 9 : 3);
            this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c + calcRadius + 1, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e - calcRadius + i, i == 0 ? 9 : 4);
            this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c - calcRadius + i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e - calcRadius, i == 0 ? 9 : 5);
            this.setUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c + calcRadius + 1 - i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + calcRadius + 1, i == 0 ? 9 : 6);
        }
        this.setLastRadius(habitat, calcRadius);
        return true;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered) {
        int radius = this.getLastRadius(habitat);
        for (int i = 0; i < radius * 2 + 1; ++i) {
            this.clearUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c - radius, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + radius + 1 - i);
            this.clearUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c + radius + 1, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e - radius + i);
            this.clearUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c - radius + i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e - radius);
            this.clearUtilityBlock(worldObj, ((TileEntity)habitat).field_145851_c + radius + 1 - i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + radius + 1);
        }
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 200;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        this.RemoveOperator(worldObj, habitat, powered);
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[15];
        objectArray[0] = "FWF";
        objectArray[1] = "ARN";
        objectArray[2] = "IWI";
        objectArray[3] = Character.valueOf('F');
        objectArray[4] = Blocks.field_150422_aJ;
        objectArray[5] = Character.valueOf('W');
        objectArray[6] = Blocks.field_150463_bK;
        objectArray[7] = Character.valueOf('A');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.AIR.ordinal());
        objectArray[9] = Character.valueOf('R');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        objectArray[11] = Character.valueOf('N');
        objectArray[12] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.ENDER.ordinal());
        objectArray[13] = Character.valueOf('I');
        objectArray[14] = Blocks.field_150411_aY;
        return objectArray;
    }
}

