/*
 * Decompiled with CFR 0.152.
 */
package am2.armor.infusions;

import am2.api.items.armor.IArmorImbuement;
import am2.api.items.armor.IImbuementRegistry;
import am2.api.items.armor.ImbuementTiers;
import am2.armor.ArmorHelper;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;

public class ImbuementRegistry
implements IImbuementRegistry {
    private TreeMap<String, IArmorImbuement> registeredImbuements = new TreeMap();
    public static final ImbuementRegistry instance = new ImbuementRegistry();
    public static final int SLOT_BOOTS = 3;
    public static final int SLOT_LEGS = 2;
    public static final int SLOT_CHEST = 1;
    public static final int SLOT_HELM = 0;

    private ImbuementRegistry() {
    }

    @Override
    public void registerImbuement(IArmorImbuement imbuementInstance) {
        this.registeredImbuements.put(imbuementInstance.getID(), imbuementInstance);
        FMLLog.info((String)"Ars Magica 2 >> Registered imbuement: %s", (Object[])new Object[]{imbuementInstance.getID()});
    }

    @Override
    public IArmorImbuement getImbuementByID(String ID) {
        return this.registeredImbuements.get(ID);
    }

    @Override
    public IArmorImbuement[] getImbuementsForTier(ImbuementTiers tier, int armorType) {
        ArrayList<IArmorImbuement> list = new ArrayList<IArmorImbuement>();
        block0: for (IArmorImbuement imbuement : this.registeredImbuements.values()) {
            if (imbuement.getTier() != tier) continue;
            for (int i : imbuement.getValidSlots()) {
                if (i != armorType) continue;
                list.add(imbuement);
                continue block0;
            }
        }
        return list.toArray(new IArmorImbuement[list.size()]);
    }

    @Override
    public boolean isImbuementPresent(ItemStack stack, IArmorImbuement imbuement) {
        return this.isImbuementPresent(stack, imbuement.getID());
    }

    @Override
    public boolean isImbuementPresent(ItemStack stack, String id) {
        return ArmorHelper.isInfusionPreset(stack, id);
    }
}

