/*
 * Decompiled with CFR 0.152.
 */
package am2.affinity;

import am2.AMCore;
import am2.affinity.AffinityModifiers;
import am2.api.events.ManaCostEvent;
import am2.api.events.SpellCastingEvent;
import am2.api.math.AMVector3;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.buffs.BuffEffectClarity;
import am2.buffs.BuffEffectFrostSlowed;
import am2.buffs.BuffEffectSwiftSwim;
import am2.buffs.BuffEffectWaterBreathing;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.utility.MathUtilities;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class AffinityHelper {
    private final Random rand = new Random();

    @SubscribeEvent
    public void onEntityLivingBase(LivingEvent.LivingUpdateEvent event) {
        float airDepth;
        AffinityData affinityData;
        float enderDepth;
        EntityLivingBase ent = event.entityLiving;
        if (ent instanceof EntityEnderman && ent.func_110144_aD() != ent.func_70643_av() && ent.func_70643_av() instanceof EntityPlayer && (enderDepth = (affinityData = AffinityData.For(ent.func_70643_av())).getAffinityDepth(Affinity.ENDER)) == 1.0f) {
            ent.func_70604_c(null);
        }
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        affinityData = AffinityData.For(ent);
        affinityData.tickDiminishingReturns();
        float waterDepth = affinityData.getAffinityDepth(Affinity.WATER);
        float fireDepth = affinityData.getAffinityDepth(Affinity.FIRE);
        float natureDepth = affinityData.getAffinityDepth(Affinity.NATURE);
        float iceDepth = affinityData.getAffinityDepth(Affinity.ICE);
        float lifeDepth = affinityData.getAffinityDepth(Affinity.LIFE);
        float enderDepth2 = affinityData.getAffinityDepth(Affinity.ENDER);
        float lightningDepth = affinityData.getAffinityDepth(Affinity.LIGHTNING);
        AffinityModifiers.instance.applySpeedModifiersBasedOnDepth((EntityPlayer)ent, natureDepth, iceDepth, lightningDepth);
        AffinityModifiers.instance.applyHealthModifiers((EntityPlayer)ent, enderDepth2, waterDepth, fireDepth, lightningDepth);
        this.applyFulmintion((EntityPlayer)ent, lightningDepth);
        if (lightningDepth >= 0.5f) {
            ent.field_70138_W = 1.014f;
        } else if (ent.field_70138_W == 1.014f) {
            ent.field_70138_W = 0.5f;
        }
        affinityData.accumulatedLifeRegen = (float)((double)affinityData.accumulatedLifeRegen + 0.025 * (double)lifeDepth);
        if (affinityData.accumulatedLifeRegen > 1.0f) {
            affinityData.accumulatedLifeRegen -= 1.0f;
            ent.func_70691_i(1.0f);
        }
        if (natureDepth == 1.0f) {
            if (ent.field_70170_p.func_72937_j((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v) && ent.field_70170_p.func_72935_r()) {
                affinityData.accumulatedHungerRegen += 0.02f;
                if (affinityData.accumulatedHungerRegen > 1.0f) {
                    ((EntityPlayer)ent).func_71024_bL().func_75122_a(1, 0.025f);
                    affinityData.accumulatedHungerRegen -= 1.0f;
                }
            } else {
                ((EntityPlayer)ent).func_71020_j(0.025f);
            }
            if (ent.field_70123_F) {
                if (!ent.func_70093_af()) {
                    float movement = ExtendedProperties.For(ent).getIsFlipped() ? -0.25f : 0.25f;
                    ent.func_70091_d(0.0, (double)movement, 0.0);
                    ent.field_70181_x = 0.0;
                } else {
                    ent.field_70181_x *= 0.79999999;
                }
                ent.field_70143_R = 0.0f;
            }
        }
        if (enderDepth2 >= 0.75f) {
            float light = ent.field_70170_p.func_72849_a((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v, false);
            if (!(ent.field_70170_p.field_72995_K || !(light <= 5.0f) || ent.func_82165_m(Potion.field_76439_r.field_76415_H) && ent.func_70660_b(Potion.field_76439_r).func_76459_b() > 220)) {
                ent.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 1));
            }
        }
        if (ent.func_70090_H()) {
            float earthDepth = affinityData.getAffinityDepth(Affinity.EARTH);
            if (earthDepth > 0.25f && ent.field_70181_x > (double)-0.3f) {
                ent.func_70024_g(0.0, (double)(-0.01f * earthDepth), 0.0);
            }
            if (waterDepth > 0.5f && (!ent.func_82165_m(BuffList.swiftSwim.field_76415_H) || ent.func_70660_b((Potion)BuffList.swiftSwim).func_76459_b() < 10)) {
                ent.func_70690_d((PotionEffect)new BuffEffectSwiftSwim(100, waterDepth > 0.75f ? 2 : 1));
            }
            if ((double)waterDepth > 0.4 && this.rand.nextInt(20) < 4) {
                ent.func_70050_g(ent.func_70086_ai() + 1);
            }
            if (!ent.field_70170_p.field_72995_K && this.rand.nextInt(100) < 5) {
                ent.func_70050_g(ent.func_70086_ai() + 1);
                byte[] data = new AMDataWriter().add(ent.func_145782_y()).add(ent.func_70086_ai()).generate();
                AMNetHandler.INSTANCE.sendPacketToClientPlayer((EntityPlayerMP)ent, (byte)33, data);
            }
            boolean waterMovementFlag = false;
            if (ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71071_by.field_70460_b[1] != null && ((EntityPlayer)ent).field_71071_by.field_70460_b[1].func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
                waterMovementFlag = true;
                if (!(ent.field_70170_p.field_72995_K || ent.func_70644_a((Potion)BuffList.waterBreathing) && ent.func_70660_b((Potion)BuffList.waterBreathing).func_76459_b() > 200)) {
                    ent.func_70690_d((PotionEffect)new BuffEffectWaterBreathing(400, 2));
                }
            }
            if (waterDepth > 0.5f || waterMovementFlag) {
                this.applyReverseWaterMovement(ent);
            }
        }
        if (ent.field_70170_p.func_72896_J() && !ent.field_70170_p.field_72995_K && ent.field_70170_p.func_72807_a((int)Math.floor(ent.field_70165_t), (int)Math.floor(ent.field_70161_v)).func_76738_d() && (airDepth = affinityData.getAffinityDepth(Affinity.AIR)) > 0.5f && airDepth < 0.85f && !ent.field_70170_p.field_72995_K && this.rand.nextInt(100) < 10 && !ent.func_70093_af() && !ent.func_70644_a((Potion)BuffList.gravityWell) && !ent.func_70055_a(Material.field_151586_h) && ent.func_70026_G()) {
            double velX = this.rand.nextDouble() - 0.5;
            double velY = this.rand.nextDouble() - 0.5;
            double velZ = this.rand.nextDouble() - 0.5;
            ent.func_70024_g(velX, velY, velZ);
            AMNetHandler.INSTANCE.sendVelocityAddPacket(ent.field_70170_p, ent, velX, velY, velZ);
        }
        if (ent.func_70093_af() && iceDepth >= 0.5f) {
            this.makeIceBridge((EntityPlayer)ent, iceDepth);
        }
    }

    private void applyFulmintion(EntityPlayer ent, float lightningDepth) {
        if (!ent.field_70170_p.field_72995_K) {
            int offsetZ;
            int offsetY;
            int offsetX;
            Block block;
            if (lightningDepth > 0.5f && lightningDepth <= 0.8f && (block = ent.field_70170_p.func_147439_a(offsetX = (int)ent.field_70165_t - 5 + ent.func_70681_au().nextInt(11), offsetY = (int)ent.field_70163_u - 5 + ent.func_70681_au().nextInt(11), offsetZ = (int)ent.field_70161_v - 5 + ent.func_70681_au().nextInt(11))) == Blocks.field_150335_W) {
                ent.field_70170_p.func_147468_f(offsetX, offsetY, offsetZ);
                ((BlockTNT)Blocks.field_150335_W).func_150114_a(ent.field_70170_p, offsetX, offsetY, offsetZ, 1, (EntityLivingBase)ent);
            }
            if (lightningDepth >= 0.7f && lightningDepth <= 0.95f && ent.func_70681_au().nextDouble() < (double)0.05f) {
                List creepers = ent.field_70170_p.func_72872_a(EntityCreeper.class, ent.field_70121_D.func_72314_b(5.0, 5.0, 5.0));
                for (EntityCreeper creeper : creepers) {
                    creeper.func_70096_w().func_75692_b(17, (Object)1);
                    AMCore.proxy.particleManager.BoltFromEntityToEntity(ent.field_70170_p, (Entity)ent, (Entity)ent, (Entity)creeper, 0, 1, -1);
                }
            }
        }
        if (lightningDepth > 0.25f && ent.func_70026_G()) {
            ExtendedProperties.For((EntityLivingBase)ent).deductMana(100.0f);
            if (ent.field_70170_p.field_72995_K) {
                AMCore.proxy.particleManager.BoltFromEntityToPoint(ent.field_70170_p, (Entity)ent, ent.field_70165_t - 2.0 + ent.func_70681_au().nextDouble() * 4.0, ent.field_70163_u + (double)ent.func_70047_e() - 2.0 + ent.func_70681_au().nextDouble() * 4.0, ent.field_70161_v - 2.0 + ent.func_70681_au().nextDouble() * 4.0);
            } else if (ent.func_70681_au().nextDouble() < (double)0.4f) {
                ent.field_70170_p.func_72956_a((Entity)ent, "arsmagica2:misc.event.mana_shield_block", 1.0f, this.rand.nextFloat() + 0.5f);
            }
        }
    }

    private void makeIceBridge(EntityPlayer ent, float iceDepth) {
        AMVector3[] blocks = MathUtilities.GetHorizontalBlocksInFrontOfCharacter((EntityLivingBase)ent, 1, (int)Math.round(ent.field_70165_t), (int)Math.floor(ent.field_70163_u) - 1, (int)Math.round(ent.field_70161_v));
        for (int i = 0; i < blocks.length; ++i) {
            AMVector3 current = blocks[i];
            for (int n = -1; n <= 1; ++n) {
                for (int p = -1; p <= 1; ++p) {
                    Block block = ent.field_70170_p.func_147439_a((int)current.x + n, (int)current.y, (int)current.z + p);
                    if (iceDepth == 1.0f && block == Blocks.field_150353_l) {
                        ent.field_70170_p.func_147449_b((int)current.x + n, (int)current.y, (int)current.z + p, Blocks.field_150343_Z);
                    } else if (iceDepth == 1.0f && block == Blocks.field_150356_k) {
                        ent.field_70170_p.func_147449_b((int)current.x + n, (int)current.y, (int)current.z + p, Blocks.field_150347_e);
                    } else if (block == Blocks.field_150355_j) {
                        ent.field_70170_p.func_147449_b((int)current.x + n, (int)current.y, (int)current.z + p, Blocks.field_150432_aD);
                    } else if (block == Blocks.field_150358_i) {
                        ent.field_70170_p.func_147449_b((int)current.x + n, (int)current.y, (int)current.z + p, Blocks.field_150432_aD);
                    }
                    block = ent.field_70170_p.func_147439_a((int)current.x + n, (int)current.y + 1, (int)current.z + p);
                    if (block != Blocks.field_150480_ab) continue;
                    ent.field_70170_p.func_147449_b((int)current.x + n, (int)current.y + 1, (int)current.z + p, Blocks.field_150350_a);
                }
            }
        }
    }

    private void applyReverseWaterMovement(EntityLivingBase entity) {
        int j1;
        AxisAlignedBB par1AxisAlignedBB = entity.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001);
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        if (!entity.field_70170_p.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0)))) {
            return;
        }
        boolean flag = false;
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == null || block.func_149688_o() != Material.field_151586_h || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockLiquid.func_149801_b((int)entity.field_70170_p.func_72805_g(k1, l1, i2)))))) continue;
                    flag = true;
                    block.func_149640_a(entity.field_70170_p, k1, l1, i2, (Entity)entity, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && entity.func_70090_H()) {
            vec3 = vec3.func_72432_b();
            double d1 = -0.014;
            entity.field_70159_w += vec3.field_72450_a * d1;
            entity.field_70181_x += vec3.field_72448_b * d1;
            entity.field_70179_y += vec3.field_72449_c * d1;
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase ent = event.entityLiving;
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        AffinityData affinityData = AffinityData.For(ent);
        float airDepth = affinityData.getAffinityDepth(Affinity.AIR);
        if (airDepth >= 0.5f) {
            float velocity = airDepth * 0.35f;
            if (ExtendedProperties.For(ent).getIsFlipped()) {
                velocity *= -1.0f;
            }
            ent.func_70024_g(0.0, (double)velocity, 0.0);
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        float airDepth;
        EntityLivingBase ent = event.entityLiving;
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        AffinityData affinityData = AffinityData.For(ent);
        float earthDepth = affinityData.getAffinityDepth(Affinity.EARTH);
        if (earthDepth > 0.25f) {
            event.distance = (float)((double)event.distance + 1.25 * (double)earthDepth);
        }
        if ((airDepth = affinityData.getAffinityDepth(Affinity.AIR)) >= 0.5f) {
            event.distance -= 2.0f * airDepth;
            if (event.distance < 0.0f) {
                event.distance = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        float waterDepth;
        float arcaneDepth;
        EntityLivingBase ent = event.entityLiving;
        AffinityData affinityData = AffinityData.For(ent);
        if (event.source.func_76364_f() instanceof EntityPlayer) {
            float attackerLightningDepth;
            float attackerFireDepth = AffinityData.For((EntityLivingBase)event.source.func_76364_f()).getAffinityDepth(Affinity.FIRE);
            if (attackerFireDepth > 0.8f && ((EntityPlayer)event.source.func_76364_f()).func_71045_bC() == null) {
                ent.func_70015_d(4);
                event.ammount += 3.0f;
            }
            if ((attackerLightningDepth = AffinityData.For((EntityLivingBase)event.source.func_76364_f()).getAffinityDepth(Affinity.LIGHTNING)) > 0.75f && !ent.field_70170_p.field_72995_K && ((EntityPlayer)event.source.func_76364_f()).func_71045_bC() == null) {
                EntityLightningBolt elb = new EntityLightningBolt(ent.field_70170_p, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                elb.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                ent.field_70170_p.func_72942_c((Entity)elb);
            }
        }
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        float earthDepth = affinityData.getAffinityDepth(Affinity.EARTH);
        if (earthDepth > 0.25f) {
            float reduction = 0.1f * earthDepth;
            event.ammount -= event.ammount * reduction;
        }
        if ((arcaneDepth = affinityData.getAffinityDepth(Affinity.ARCANE)) > 0.25f) {
            event.ammount *= 1.1f;
        }
        if ((waterDepth = affinityData.getAffinityDepth(Affinity.WATER)) > 0.9f && event.source.func_76364_f() instanceof EntityEnderman) {
            event.source.func_76364_f().func_70097_a(DamageSource.field_76369_e, 2.0f);
        }
        float fireDepth = affinityData.getAffinityDepth(Affinity.FIRE);
        if (event.source.func_76347_k()) {
            float reduction = 1.0f - 0.6f * fireDepth;
            event.ammount *= reduction;
        }
        float enderDepth = affinityData.getAffinityDepth(Affinity.ENDER);
        if (event.source == DamageSource.field_76376_m || event.source == DamageSource.field_82727_n) {
            float reduction = 1.0f - 0.75f * enderDepth;
            event.ammount *= reduction;
        }
        if (event.source.func_76364_f() instanceof EntityLivingBase) {
            float natureDepth = affinityData.getAffinityDepth(Affinity.NATURE);
            if (natureDepth == 1.0f) {
                ((EntityLivingBase)event.source.func_76364_f()).func_70097_a(DamageSource.field_76367_g, 3.0f);
            } else if (natureDepth >= 0.75f) {
                ((EntityLivingBase)event.source.func_76364_f()).func_70097_a(DamageSource.field_76367_g, 2.0f);
            } else if (natureDepth >= 0.5f) {
                ((EntityLivingBase)event.source.func_76364_f()).func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
            float iceDepth = affinityData.getAffinityDepth(Affinity.ICE);
            BuffEffectFrostSlowed effect = null;
            if (iceDepth == 1.0f) {
                effect = new BuffEffectFrostSlowed(200, 2);
            } else if (iceDepth >= 0.75f) {
                effect = new BuffEffectFrostSlowed(160, 1);
            } else if (iceDepth >= 0.5f) {
                effect = new BuffEffectFrostSlowed(100, 0);
            }
            if (effect != null) {
                ((EntityLivingBase)event.source.func_76364_f()).func_70690_d((PotionEffect)effect);
            }
        }
        if (event.ammount == 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityPlayer source;
        float lifeDepth;
        if (event.entityLiving.func_70668_bt() != EnumCreatureAttribute.UNDEAD && event.source.func_76364_f() instanceof EntityPlayer && (lifeDepth = AffinityData.For((EntityLivingBase)(source = (EntityPlayer)event.source.func_76364_f())).getAffinityDepth(Affinity.LIFE)) >= 0.6f) {
            source.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 1));
            source.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 40, 1));
            source.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 100, 1));
            source.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 1));
        }
    }

    @SubscribeEvent
    public void onPreSpellCast(SpellCastingEvent.Pre event) {
        if (event.caster.func_82165_m(BuffList.clarity.field_76415_H) && !event.caster.field_70170_p.field_72995_K) {
            event.caster.func_82170_o(BuffList.clarity.field_76415_H);
        }
    }

    @SubscribeEvent
    public void onSpellCast(SpellCastingEvent.Post event) {
        float affinityDepth;
        if (event.caster instanceof EntityPlayer && event.castResult == SpellCastResult.SUCCESS && (affinityDepth = AffinityData.For(event.caster).getAffinityDepth(Affinity.ARCANE)) > 0.4f && this.rand.nextInt(100) < 5 && !event.caster.field_70170_p.field_72995_K) {
            event.caster.func_70690_d((PotionEffect)new BuffEffectClarity(140, 0));
        }
    }

    @SubscribeEvent
    public void onSpellManaCost(ManaCostEvent event) {
        if (event.caster instanceof EntityPlayer && AffinityData.For(event.caster).getAffinityDepth(Affinity.ARCANE) > 0.5f) {
            event.manaCost *= 0.95f;
            event.burnout *= 0.95f;
            if (event.caster.func_82165_m(BuffList.clarity.field_76415_H)) {
                event.manaCost = 0.0f;
                event.burnout = 0.0f;
            }
        }
    }
}

