/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.blocks.BlocksCommonProxy;
import am2.bosses.BossSpawnHelper;
import am2.items.ItemsCommonProxy;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public class EntityItemWatcher {
    private final ArrayList<EntityItem> watchedItems = new ArrayList();
    private final ArrayList<EntityItem> toRemove = new ArrayList();
    private final ArrayList<Block> inlayBlocks = new ArrayList();
    private final ArrayList<Item> itemsToWatch = new ArrayList();
    public static EntityItemWatcher instance = new EntityItemWatcher();

    private EntityItemWatcher() {
    }

    public void init() {
        this.registerInlayBlock((Block)BlocksCommonProxy.redstoneInlay);
        this.registerInlayBlock((Block)BlocksCommonProxy.ironInlay);
        this.registerInlayBlock((Block)BlocksCommonProxy.goldInlay);
        this.registerWatchableItem(Items.field_151124_az);
        this.registerWatchableItem(Items.field_151131_as);
        this.registerWatchableItem(ItemsCommonProxy.essence);
        this.registerWatchableItem(ItemsCommonProxy.itemOre);
        this.registerWatchableItem(Items.field_151166_bC);
        this.registerWatchableItem(Items.field_151061_bv);
    }

    public void tick() {
        this.watchedItems.removeAll(this.toRemove);
        this.toRemove.clear();
        for (EntityItem item : this.watchedItems) {
            if (item.field_70128_L) {
                this.removeWatchedItem(item);
                continue;
            }
            if (!item.func_70027_ad() && (Math.abs(item.field_70159_w) > 0.01 || Math.abs(item.field_70181_x) > 0.01 || Math.abs(item.field_70179_y) > 0.01)) continue;
            int x = (int)Math.floor(item.field_70165_t);
            int y = (int)Math.floor(item.field_70163_u);
            int z = (int)Math.floor(item.field_70161_v);
            if (item.func_70027_ad()) {
                ++y;
            }
            boolean insideRing = true;
            Block ringType = null;
            for (int i = -1; i <= 1 && insideRing; ++i) {
                for (int j = -1; j <= 1 && insideRing; ++j) {
                    if (i == 0 && j == 0) continue;
                    Block blockID1 = item.field_70170_p.func_147439_a(x + i, y, z + j);
                    Block blockID2 = item.field_70170_p.func_147439_a(x + i, y + 1, z + j);
                    Block blockID3 = item.field_70170_p.func_147439_a(x + i, y - 1, z + j);
                    if (this.inlayBlocks.contains(blockID1) || this.inlayBlocks.contains(blockID2) || this.inlayBlocks.contains(blockID3)) {
                        if (ringType == null) {
                            ringType = this.inlayBlocks.contains(blockID1) ? blockID1 : (this.inlayBlocks.contains(blockID2) ? blockID2 : blockID3);
                            continue;
                        }
                        if (ringType == blockID1 || ringType == blockID2 || ringType == blockID3) continue;
                        insideRing = false;
                        continue;
                    }
                    insideRing = false;
                }
            }
            if (insideRing) {
                BossSpawnHelper.instance.onItemInRing(item, ringType);
            }
            this.removeWatchedItem(item);
        }
    }

    public void addWatchedItem(EntityItem item) {
        if (this.itemsToWatch.contains(item.func_92059_d().func_77973_b())) {
            this.watchedItems.add(item);
        }
    }

    public void registerInlayBlock(Block inlayBlock) {
        if (!this.inlayBlocks.contains(inlayBlock)) {
            this.inlayBlocks.add(inlayBlock);
        }
    }

    public void registerWatchableItem(Item item) {
        if (!this.itemsToWatch.contains(item)) {
            this.itemsToWatch.add(item);
        }
    }

    private void removeWatchedItem(EntityItem item) {
        this.toRemove.add(item);
    }
}

