/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.InventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xreliquary.Reliquary;

@ContentInit
public class ItemDestructionCatalyst
extends ItemToggleable {
    public static List<String> ids = ImmutableList.of((Object)"minecraft:dirt", (Object)"minecraft:grass", (Object)"minecraft:gravel", (Object)"minecraft:cobblestone", (Object)"minecraft:stone", (Object)"minecraft:sand", (Object)"minecraft:sandstone", (Object)"minecraft:snow", (Object)"minecraft:soul_sand", (Object)"minecraft:netherrack", (Object)"minecraft:end_stone");

    public ItemDestructionCatalyst() {
        super("destruction_catalyst");
        this.func_77656_e(257);
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (ist.func_77960_j() != 0 && ist.func_77958_k() - 1 >= ist.func_77960_j() + this.gunpowderCost() || player.field_71075_bZ.field_75098_d) {
            this.doExplosion(world, x, y, z, side, player, ist);
        }
        return true;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist) && (ist.func_77960_j() == 0 || ist.func_77960_j() > 1) && InventoryHelper.consumeItem((Object)new ItemStack(Items.field_151016_H), (EntityPlayer)player)) {
            ist.func_77964_b(ist.func_77960_j() == 0 ? ist.func_77958_k() - 1 : ist.func_77960_j() - 1);
        }
    }

    public void doExplosion(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack ist) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        y += side == 0 ? 1 : (side == 1 ? -1 : 0);
        z += side == 2 ? 1 : (side == 3 ? -1 : 0);
        x += side == 4 ? 1 : (side == 5 ? -1 : 0);
        for (int xD = -1; xD <= 1; ++xD) {
            for (int yD = -1; yD <= 1; ++yD) {
                for (int zD = -1; zD <= 1; ++zD) {
                    if (!this.isBreakable(ContentHelper.getIdent((Block)world.func_147439_a(x + xD, y + yD, z + zD)))) continue;
                    world.func_147449_b(x + xD, y + yD, z + zD, Blocks.field_150350_a);
                    if (world.field_73012_v.nextInt(2) == 0) {
                        world.func_72869_a("largeexplode", (double)(x + xD), (double)(y + yD), (double)(z + zD), 1.0, 0.0, 0.0);
                    }
                    destroyedSomething = true;
                    if (!playOnce) continue;
                    world.func_72908_a((double)x, (double)y, (double)z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    playOnce = false;
                }
            }
        }
        if (destroyedSomething) {
            ist.func_77964_b(ist.func_77960_j() + this.gunpowderCost());
        }
    }

    public boolean isBreakable(String id) {
        return ((List)Reliquary.CONFIG.get("destruction_catalyst", "mundane_blocks")).indexOf(id) != -1;
    }

    private int gunpowderCost() {
        return Reliquary.CONFIG.getInt("destruction_catalyst", "gunpowder_cost");
    }
}

