/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lib.enderwizards.sandstone.init.ContentHandler;
import lib.enderwizards.sandstone.init.ContentInit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.blocks.tile.TileEntityAltar;

public class BlockAlkahestryAltar
extends BlockContainer {
    private final boolean isActive;
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] icons;

    public BlockAlkahestryAltar(boolean par1) {
        super(Material.field_151576_e);
        this.isActive = par1;
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149663_c(this.isActive ? "altar" : "altar_idle");
        this.func_149715_a(this.isActive ? 1.0f : 0.0f);
        this.func_149647_a(Reliquary.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return icons[this.isActive ? 1 : 0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        icons = new IIcon[2];
        BlockAlkahestryAltar.icons[0] = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "altar_idle");
        BlockAlkahestryAltar.icons[1] = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "altar");
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return ItemBlock.func_150898_a((Block)ContentHandler.getBlock((String)"altar_idle"));
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        int worldTime = (int)(world.func_72820_D() % 24000L);
        if (worldTime >= 12000) {
            return;
        }
        if (!world.func_72937_j(x, y + 1, z)) {
            return;
        }
        if (rand.nextInt(3) != 0) {
            return;
        }
        world.func_72869_a("mobSpell", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 1.1, (double)z + 0.5 + rand.nextGaussian() / 8.0, 0.9, 0.9, 0.0);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOff, float yOff, float zOff) {
        if (this.isActive) {
            return true;
        }
        TileEntityAltar altar = (TileEntityAltar)world.func_147438_o(x, y, z);
        if (altar == null) {
            return true;
        }
        if (player.func_71045_bC() == null) {
            return true;
        }
        if (player.func_71045_bC().func_77973_b() == Items.field_151137_ax) {
            int slot = this.getSlotWithRedstoneDust(player);
            if (slot == -1) {
                return true;
            }
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(world.field_73012_v.nextGaussian() / 8.0));
            for (int particles = world.field_73012_v.nextInt(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
                world.func_72869_a("reddust", (double)x + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)y + 1.2, (double)z + 0.5 + world.field_73012_v.nextGaussian() / 5.0, 1.0, 0.0, 0.0);
            }
            if (world.field_72995_K) {
                return true;
            }
            player.field_71071_by.func_70298_a(slot, 1);
            altar.addRedstone();
        }
        return true;
    }

    private int getSlotWithRedstoneDust(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != Items.field_151137_ax) continue;
            return slot;
        }
        return -1;
    }

    public static void updateAltarBlockState(boolean active, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (active) {
            world.func_147449_b(x, y, z, ContentHandler.getBlock((String)"altar"));
        } else {
            world.func_147449_b(x, y, z, ContentHandler.getBlock((String)"altar_idle"));
        }
        world.func_72921_c(x, y, z, meta, 3);
        if (te != null) {
            te.func_145829_t();
            world.func_147455_a(x, y, z, te);
        }
    }

    public TileEntity func_149915_a(World var1, int dunnoWhatThisIs) {
        return new TileEntityAltar();
    }

    @ContentInit
    public static class BlockIdleAlkahestryAltar
    extends BlockAlkahestryAltar {
        public BlockIdleAlkahestryAltar() {
            super(false);
        }
    }

    @ContentInit
    public static class BlockActiveAlkahestryAltar
    extends BlockAlkahestryAltar {
        public BlockActiveAlkahestryAltar() {
            super(true);
        }
    }
}

