/*
 * Decompiled with CFR 0.152.
 */
package openmods.access;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import openmods.access.ApiImplementation;
import openmods.access.ApiSingleton;

public class ApiProviderBase<A> {
    private final Class<? super A> markerType = new TypeToken<A>(this.getClass()){}.getRawType();
    private final Map<Class<? extends A>, IApiInstanceProvider<?>> providers = Maps.newHashMap();

    private void findAllImplementedApis(Collection<Class<? extends A>> output, Class<?> ... intfs) {
        for (Class<?> cls : intfs) {
            Preconditions.checkArgument((boolean)cls.isInterface());
            if (!this.markerType.isAssignableFrom(cls) || this.markerType == cls) continue;
            output.add(cls);
        }
    }

    private void addAllApiInterfaces(Set<Class<? extends A>> interfaces) {
        Class cls;
        LinkedList queue = Lists.newLinkedList(interfaces);
        while ((cls = (Class)queue.poll()) != null) {
            interfaces.add(cls);
            this.findAllImplementedApis(queue, cls.getInterfaces());
        }
    }

    private <T extends A> void registerInterfaces(Class<? extends T> cls, IApiInstanceProvider<T> provider, boolean includeSuper) {
        HashSet implemented = Sets.newHashSet();
        this.findAllImplementedApis(implemented, cls.getInterfaces());
        if (includeSuper) {
            this.addAllApiInterfaces(implemented);
        }
        for (Class impl : implemented) {
            IApiInstanceProvider<T> prev = this.providers.put(impl, provider);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Conflict on %s: %s -> %s", (Object[])new Object[]{impl, prev, provider});
        }
    }

    public <T extends A> void registerClass(Class<? extends T> cls) {
        Preconditions.checkArgument((!Modifier.isAbstract(cls.getModifiers()) ? 1 : 0) != 0);
        ApiImplementation meta = cls.getAnnotation(ApiImplementation.class);
        Preconditions.checkNotNull((Object)meta);
        IApiInstanceProvider<? extends T> provider = meta.cacheable() ? new SingleInstanceProvider<T>(cls) : new NewInstanceProvider<T>(cls);
        this.registerInterfaces(cls, provider, meta.includeSuper());
    }

    public <T extends A> void registerInstance(T obj) {
        Class<?> cls = obj.getClass();
        ApiSingleton meta = cls.getAnnotation(ApiSingleton.class);
        Preconditions.checkNotNull((Object)meta);
        SingletonProvider<T> provider = new SingletonProvider<T>(obj);
        this.registerInterfaces(cls, provider, meta.includeSuper());
    }

    public <T extends A> T getApi(Class<T> cls) {
        IApiInstanceProvider<?> provider = this.providers.get(cls);
        Preconditions.checkNotNull(provider, (String)"Can't get implementation for class %s", (Object[])new Object[]{cls});
        return (T)provider.getInterface();
    }

    public <T extends A> boolean isApiPresent(Class<T> cls) {
        return this.providers.containsKey(cls);
    }

    private static class SingletonProvider<T>
    implements IApiInstanceProvider<T> {
        private final T obj;

        public SingletonProvider(T obj) {
            this.obj = obj;
        }

        @Override
        public T getInterface() {
            return this.obj;
        }

        public String toString() {
            return "SingletonProvider [obj=" + this.obj + "]";
        }
    }

    private static class NewInstanceProvider<T>
    implements IApiInstanceProvider<T> {
        private final Class<? extends T> cls;

        public NewInstanceProvider(Class<? extends T> cls) {
            this.cls = cls;
        }

        @Override
        public T getInterface() {
            try {
                return this.cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        public String toString() {
            return "NewInstanceProvider [cls=" + this.cls + "]";
        }
    }

    private static class SingleInstanceProvider<T>
    implements IApiInstanceProvider<T> {
        private final T instance;

        public SingleInstanceProvider(Class<? extends T> cls) {
            try {
                this.instance = cls.newInstance();
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }

        @Override
        public T getInterface() {
            return this.instance;
        }

        public String toString() {
            return "SingleInstanceProvider [instance=" + this.instance + "]";
        }
    }

    public static interface IApiInstanceProvider<T> {
        public T getInterface();
    }
}

