/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.common;

import cpw.mods.fml.common.registry.GameRegistry;
import glassmaker.extratic.common.ConfigurationHandler;
import glassmaker.extratic.common.ModHandler;
import glassmaker.extratic.metals.MoltenMetalBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import tconstruct.library.crafting.FluidType;

public class MoltenMetals {
    public static void addMoltenMetal(String tag, String unlocalizedName, String fluidName, String iconFlow, String iconStill) {
        Fluid fluid = new Fluid(fluidName).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300);
        boolean registered = FluidRegistry.registerFluid((Fluid)fluid);
        MoltenMetalBlock moltenMetal = new MoltenMetalBlock(fluid, unlocalizedName, iconStill, iconFlow, registered);
        GameRegistry.registerBlock((Block)moltenMetal, (String)tag);
    }

    public static void addMoltenMetals() {
        ModHandler modHandler = ModHandler.getInstance();
        if (modHandler.isEnabled("Mekanism")) {
            MoltenMetals.addMekanismMetals();
        }
        MoltenMetals.addFunStuffMetals();
        if (modHandler.isEnabled("GalacticraftMars")) {
            MoltenMetals._addGCMarsMetals();
        }
        if (modHandler.isEnabled("ThaumicIntegration")) {
            MoltenMetals.addTIMetals();
        }
        if (modHandler.isEnabled("Generic")) {
            MoltenMetals.addGenericMetals();
        }
        if (modHandler.isEnabled("BluePower")) {
            MoltenMetals._addBluepower();
        }
        if (modHandler.isEnabled("EnderIO")) {
            MoltenMetals._addEnderIo();
        }
        if (modHandler.isEnabled("Botania")) {
            MoltenMetals._addBotania();
        }
        if (modHandler.isEnabled("Thaumcraft")) {
            MoltenMetals._addThaumcraft();
        }
        if (modHandler.isEnabled("BigReactors")) {
            MoltenMetals._addBigReactors();
        }
        if (modHandler.isEnabled("ExtraUtils")) {
            MoltenMetals._addExtraUtils();
        }
        if (modHandler.isEnabled("ProgAuto")) {
            MoltenMetals._addProgAuto();
        }
        if (modHandler.isEnabled("AoA")) {
            MoltenMetals._addNevermine();
        }
        if (ConfigurationHandler.getJadedEdition()) {
            MoltenMetals.changeThemalFluidTool();
        }
    }

    public static void addMekanismMetals() {
        MoltenMetals.addMoltenMetal("moltenRefinedGlowstone", "molten.refined.glowstone", "refined.glowstone.molten", "molten_refined_glowstone_flow", "molten_refined_glowstone_still");
        MoltenMetals.addMoltenMetal("moltenOsmium", "molten.osmium", "osmium.molten", "molten_osmium_flow", "molten_osmium_still");
    }

    public static void addFunStuffMetals() {
        MoltenMetals.addMoltenMetal("moltenPokefennium", "molten.pokefennium", "pokefennium.molten", "molten_pokefennium_flow", "molten_pokefennium_still");
        MoltenMetals.addMoltenMetal("moltenFairy", "molten.fairy", "fairy.molten", "molten_fairy_flow", "molten_fairy_still");
        MoltenMetals.addMoltenMetal("moltenRedAurum", "molten.red.aurum", "red.aurum.molten", "molten_red_aurum_flow", "molten_red_aurum_still");
    }

    private static void _addGCMarsMetals() {
        MoltenMetals.addMoltenMetal("moltenDesh", "molten.desh", "desh.molten", "molten_desh_flow", "molten_desh_still");
    }

    public static void addTIMetals() {
        MoltenMetals.addMoltenMetal("potatoSoup", "potato.soup", "potato.soup", "potato_soup_flow", "potato_soup_still");
        MoltenMetals.addMoltenMetal("moltenDrulloy", "molten.drulloy", "drulloy.molten", "molten_drulloy_flow", "molten_drulloy_still");
    }

    public static void addGenericMetals() {
        MoltenMetals.addMoltenMetal("moltenDarkSteel", "molten.dark.steel", "dark.steel.molten", "molten_darksteel_flow", "molten_darksteel_still");
        MoltenMetals.addMoltenMetal("moltenZinc", "molten.zinc", "zinc.molten", "molten_zinc_flow", "molten_zinc_still");
        MoltenMetals.addMoltenMetal("moltenBrass", "molten.brass", "brass.molten", "molten_brass_flow", "molten_brass_still");
        MoltenMetals.addMoltenMetal("moltenAdamantine.", "molten.adamantine", "adamantine.molten", "molten_adamantine_flow", "molten_adamantine_still");
    }

    private static void _addBluepower() {
        MoltenMetals.addMoltenMetal("moltenBlueAlloy", "molten.blue.alloy", "blue.alloy.molten", "molten_blue_alloy_flow", "molten_blue_alloy_still");
        MoltenMetals.addMoltenMetal("liquidInfusedTeslatite", "liquid.infused.teslatite", "infused.teslatite.liquid", "liquid_infused_teslatite_flow", "liquid_infused_teslatite_still");
        MoltenMetals.addMoltenMetal("moltenPurpleAlloy", "molten.purple.alloy", "purple.alloy.molten", "molten_purple_alloy_flow", "molten_purple_alloy_still");
        MoltenMetals.addMoltenMetal("moltenRedAlloy", "molten.red.alloy", "red.alloy.molten", "molten_red_alloy_flow", "molten_red_alloy_still");
        MoltenMetals.addMoltenMetal("liquidTeslatite", "liquid.teslatite", "teslatite.liquid", "liquid_teslatite_flow", "liquid_teslatite_still");
        MoltenMetals.addMoltenMetal("moltenTungsten", "molten.tungsten", "tungsten.molten", "molten_tungsten_flow", "molten_tungsten_still");
    }

    private static void _addEnderIo() {
        MoltenMetals.addMoltenMetal("moltenConductiveIron", "molten.conductive.iron", "conductive.iron.molten", "molten_conductive_iron_flow", "molten_conductive_iron_still");
        MoltenMetals.addMoltenMetal("moltenElectricalSteel", "molten.electrical.steel", "electrical.steel.molten", "molten_electrical_steel_flow", "molten_electrical_steel_still");
        MoltenMetals.addMoltenMetal("moltenEnergeticAlloy", "molten.energetic.alloy", "energetic.alloy.molten", "molten_energetic_alloy_flow", "molten_energetic_alloy_still");
        MoltenMetals.addMoltenMetal("moltenPhasedGold", "molten.phased.gold", "phased.gold.molten", "molten_phased_gold_flow", "molten_phased_gold_still");
        MoltenMetals.addMoltenMetal("moltenPhasedIron", "molten.phased.iron", "phased.iron.molten", "molten_phased_iron_flow", "molten_phased_iron_still");
        MoltenMetals.addMoltenMetal("moltenRedstoneAlloy", "molten.redstone.alloy", "redstone.alloy.molten", "molten_redstone_alloy_flow", "molten_redstone_alloy_still");
        MoltenMetals.addMoltenMetal("liquidSilicon", "liquid.silicon", "silicon.liquid", "liquid_silicon_flow", "liquid_silicon_still");
        MoltenMetals.addMoltenMetal("moltenSoularium", "molten.soularium", "soularium.molten", "molten_soularium_flow", "molten_soularium_still");
    }

    private static void _addBotania() {
        MoltenMetals.addMoltenMetal("moltenManasteel", "molten.manasteel", "manasteel.molten", "molten_manasteel_flow", "molten_manasteel_still");
        MoltenMetals.addMoltenMetal("moltenTerrasteel", "molten.terrasteel", "terrasteel.molten", "molten_terrasteel_flow", "molten_terrasteel_still");
        MoltenMetals.addMoltenMetal("moltenElementium", "molten.elementium", "elementium.molten", "molten_elementium_flow", "molten_elementium_still");
    }

    private static void _addThaumcraft() {
        MoltenMetals.addMoltenMetal("moltenVoidmetal", "molten.voidmetal", "voidmetal.molten", "molten_voidmetal_flow", "molten_voidmetal_still");
    }

    private static void _addBigReactors() {
        MoltenMetals.addMoltenMetal("moltenblutonium", "molten.blutonium", "blutonium.molten", "molten_blutonium_flow", "molten_blutonium_still");
        MoltenMetals.addMoltenMetal("moltenLudicrite", "molten.ludicrite", "ludicrite.molten", "molten_ludicrite_flow", "molten_ludicrite_still");
    }

    private static void _addExtraUtils() {
        MoltenMetals.addMoltenMetal("moltenBedrockium", "molten.bedrockium", "bedrockium.molten", "molten_bedrockium_flow", "molten_bedrockium_still");
    }

    private static void _addProgAuto() {
        MoltenMetals.addMoltenMetal("moltenWitheriron", "molten.witheriron", "witheriron.molten", "molten_witheriron_flow", "molten_witheriron_still");
    }

    private static void _addNevermine() {
        MoltenMetals.addMoltenMetal("moltenAmethyst", "molten.amethyst", "amethyst.molten", "molten_amethyst_flow", "molten_amethyst_still");
        MoltenMetals.addMoltenMetal("moltenEmberstone", "molten.emberstone", "emberstone.molten", "molten_emberstone_flow", "molten_emberstone_still");
        MoltenMetals.addMoltenMetal("moltenJade", "molten.jade", "jade.molten", "molten_jade_flow", "molten_jade_still");
        MoltenMetals.addMoltenMetal("moltenLimonite", "molten.limonite", "limonite.molten", "molten_limonite_flow", "molten_limonite_still");
        MoltenMetals.addMoltenMetal("moltenRosite", "molten.rosite", "rosite.molten", "molten_rosite_flow", "molten_rosite_still");
        MoltenMetals.addMoltenMetal("moltenSapphire", "molten.sapphire", "sapphire.molten", "molten_sapphire_flow", "molten_sapphire_still");
        MoltenMetals.addMoltenMetal("moltenSkeletal", "molten.skeletal", "skeletal.molten", "molten_skeletal_flow", "molten_skeletal_still");
        MoltenMetals.addMoltenMetal("moltenBaronyte", "molten.baronyte", "baronyte.molten", "molten_baronyte_flow", "molten_baronyte_still");
        MoltenMetals.addMoltenMetal("molten_blazium_still", "molten.blazium", "blazium.molten", "molten_blazium_flow", "molten_blazium_still");
        MoltenMetals.addMoltenMetal("moltenElecanium", "molten.elecanium", "elecanium.molten", "molten_elecanium_flow", "molten_elecanium_still");
        MoltenMetals.addMoltenMetal("moltenGhastly", "molten.ghastly", "ghastly.molten", "molten_ghastly_flow", "molten_ghastly_still");
        MoltenMetals.addMoltenMetal("moltenGhoulish", "molten.ghoulish", "ghoulish.molten", "molten_ghoulish_flow", "molten_ghoulish_still");
        MoltenMetals.addMoltenMetal("moltenLyon", "molten.lyon", "lyon.molten", "molten_lyon_flow", "molten_lyon_still");
        MoltenMetals.addMoltenMetal("moltenMystite", "molten.mystite", "mystite.molten", "molten_mystite_flow", "molten_mystite_still");
        MoltenMetals.addMoltenMetal("moltenVarsium", "molten.varsium", "varsium.molten", "molten_varsium_flow", "molten_varsium_still");
    }

    private static void changeThemalFluidTool() {
        HashMap tempFluidTypes = new HashMap();
        for (Map.Entry entry : FluidType.fluidTypes.entrySet()) {
            if (!MoltenMetals.isThermal((String)entry.getKey())) continue;
            FluidType oldFluidType = (FluidType)entry.getValue();
            FluidType newFluidType = new FluidType(oldFluidType.renderBlock, oldFluidType.renderMeta, oldFluidType.baseTemperature, oldFluidType.fluid, true);
            tempFluidTypes.put(entry.getKey(), newFluidType);
        }
        for (Map.Entry entry : tempFluidTypes.entrySet()) {
            FluidType.fluidTypes.put(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isThermal(String name) {
        if (name.equalsIgnoreCase("Lumium")) {
            return true;
        }
        if (name.equalsIgnoreCase("Signalum")) {
            return true;
        }
        if (name.equalsIgnoreCase("Mithril")) {
            return true;
        }
        return name.equalsIgnoreCase("Enderium");
    }
}

