/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileVibrationChamber
extends AENetworkInvTile
implements IGridTickable {
    private static final int FUEL_SLOT_INDEX = 0;
    private static final double POWER_PER_TICK = 5.0;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};
    private static final int MAX_BURN_SPEED = 200;
    private static final double DILATION_SCALING = 100.0;
    private static final int MIN_BURN_SPEED = 20;
    private final IInventory inv = new AppEngInternalInventory(this, 1);
    public int burnSpeed = 100;
    public double burnTime = 0.0;
    public double maxBurnTime = 0.0;
    public boolean isOn;

    public TileVibrationChamber() {
        this.gridProxy.setIdlePowerUsage(0.0);
        this.gridProxy.setFlags(new GridFlags[0]);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean hasUpdate(ByteBuf data) {
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToNetwork(ByteBuf data) {
        data.writeBoolean(this.burnTime > 0.0);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileVibrationChamber(NBTTagCompound data) {
        data.func_74780_a("burnTime", this.burnTime);
        data.func_74780_a("maxBurnTime", this.maxBurnTime);
        data.func_74768_a("burnSpeed", this.burnSpeed);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileVibrationChamber(NBTTagCompound data) {
        this.burnTime = data.func_74769_h("burnTime");
        this.maxBurnTime = data.func_74769_h("maxBurnTime");
        this.burnSpeed = data.func_74762_e("burnSpeed");
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) > 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.burnTime <= 0.0 && this.canEatFuel()) {
            try {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        return false;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return ACCESSIBLE_SLOTS;
    }

    private boolean canEatFuel() {
        int newBurnTime;
        ItemStack is = this.func_70301_a(0);
        return is != null && (newBurnTime = TileEntityFurnace.func_145952_a((ItemStack)is)) > 0 && is.field_77994_a > 0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.burnTime <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber.min, TickRates.VibrationChamber.max, this.burnTime <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.burnTime <= 0.0) {
            this.eatFuel();
            if (this.burnTime > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.burnSpeed = 100;
            return TickRateModulation.SLEEP;
        }
        this.burnSpeed = Math.max(20, Math.min(this.burnSpeed, 200));
        double dilation = (double)this.burnSpeed / 100.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.burnTime -= timePassed;
        if (this.burnTime < 0.0) {
            timePassed += this.burnTime;
            this.burnTime = 0.0;
        }
        try {
            IEnergyGrid grid = this.gridProxy.getEnergy();
            double newPower = timePassed * 5.0;
            double overFlow = grid.injectPower(newPower, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
            this.burnSpeed = overFlow > 0.0 ? (this.burnSpeed -= ticksSinceLastCall) : (this.burnSpeed += ticksSinceLastCall);
            this.burnSpeed = Math.max(20, Math.min(this.burnSpeed, 200));
            return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
        }
        catch (GridAccessException e) {
            this.burnSpeed -= ticksSinceLastCall;
            this.burnSpeed = Math.max(20, Math.min(this.burnSpeed, 200));
            return TickRateModulation.SLOWER;
        }
    }

    private void eatFuel() {
        int newBurnTime;
        ItemStack is = this.func_70301_a(0);
        if (is != null && (newBurnTime = TileEntityFurnace.func_145952_a((ItemStack)is)) > 0 && is.field_77994_a > 0) {
            this.burnTime += (double)newBurnTime;
            this.maxBurnTime = this.burnTime;
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                ItemStack container = null;
                if (is.func_77973_b() != null && is.func_77973_b().hasContainerItem(is)) {
                    container = is.func_77973_b().getContainerItem(is);
                }
                this.func_70299_a(0, container);
            } else {
                this.func_70299_a(0, is);
            }
            this.func_70296_d();
        }
        if (this.burnTime > 0.0) {
            try {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (!this.isOn && this.burnTime > 0.0 || this.isOn && this.burnTime <= 0.0) {
            this.isOn = this.burnTime > 0.0;
            this.markForUpdate();
            if (this.func_145830_o()) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }
}

