/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEPassThrough;
import appeng.util.Platform;
import appeng.util.inv.ItemListIgnoreCrafting;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MEMonitorPassThrough<T extends IAEStack<T>>
extends MEPassThrough<T>
implements IMEMonitor<T>,
IMEMonitorHandlerReceiver<T> {
    final HashMap<IMEMonitorHandlerReceiver<T>, Object> listeners = new HashMap();
    public BaseActionSource changeSource;
    IMEMonitor<T> monitor;

    public MEMonitorPassThrough(IMEInventory<T> i, StorageChannel channel) {
        super(i, channel);
        if (i instanceof IMEMonitor) {
            this.monitor = (IMEMonitor)i;
        }
    }

    @Override
    public void setInternal(IMEInventory<T> i) {
        IItemList after;
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
        this.monitor = null;
        IItemList before = this.getInternal() == null ? this.channel.createList() : this.getInternal().getAvailableItems(new ItemListIgnoreCrafting(this.channel.createList()));
        super.setInternal(i);
        if (i instanceof IMEMonitor) {
            this.monitor = (IMEMonitor)i;
        }
        IItemList iItemList = after = this.getInternal() == null ? this.channel.createList() : this.getInternal().getAvailableItems(new ItemListIgnoreCrafting(this.channel.createList()));
        if (this.monitor != null) {
            this.monitor.addListener(this, this.monitor);
        }
        Platform.postListChanges(before, after, this, this.changeSource);
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList out) {
        super.getAvailableItems((IItemList)new ItemListIgnoreCrafting(out));
        return out;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<T> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<T> l) {
        this.listeners.remove(l);
    }

    @Override
    public IItemList<T> getStorageList() {
        if (this.monitor == null) {
            IItemList out = this.channel.createList();
            this.getInternal().getAvailableItems(new ItemListIgnoreCrafting(out));
            return out;
        }
        return this.monitor.getStorageList();
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return verificationToken == this.monitor;
    }

    @Override
    public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, BaseActionSource source) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<T>, Object> e = i.next();
            IMEMonitorHandlerReceiver<T> receiver = e.getKey();
            if (receiver.isValid(e.getValue())) {
                receiver.postChange(this, change, source);
                continue;
            }
            i.remove();
        }
    }

    @Override
    public void onListUpdate() {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<T>, Object> e = i.next();
            IMEMonitorHandlerReceiver<T> receiver = e.getKey();
            if (receiver.isValid(e.getValue())) {
                receiver.onListUpdate();
                continue;
            }
            i.remove();
        }
    }
}

