/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.core.BlockPool;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.core.SideOffset;

public class FluidFillingManager
implements IHarvestManager {
    private BlockPool _blocks;
    private boolean _isDone;
    private Area _area;
    private World _world;

    public FluidFillingManager(World world, Area area) {
        this.reset(world, area, null, null);
        this._isDone = true;
    }

    @Override
    public BlockPosition getNextBlock() {
        BlockPool.BlockNode blockNode = this._blocks.poke();
        return new BlockPosition(blockNode.x, blockNode.y, blockNode.z);
    }

    @Override
    public void moveNext() {
        this.searchForFreeBlocks(this._blocks.shift());
        if (this._blocks.size() == 0) {
            this._isDone = true;
        }
    }

    private void searchForFreeBlocks(BlockPool.BlockNode blockNode) {
        for (SideOffset sideOffset : SideOffset.ADJACENT) {
            BlockPool.BlockNode blockNode2 = BlockPool.getNext(blockNode.x + sideOffset.offsetX, blockNode.y + sideOffset.offsetY, blockNode.z + sideOffset.offsetZ);
            if (this.isValid(blockNode2)) {
                this._blocks.push(blockNode2);
                continue;
            }
            blockNode2.free();
        }
        blockNode.free();
    }

    private boolean isValid(BlockPool.BlockNode blockNode) {
        Area area = this._area;
        if (blockNode.x < area.xMin || blockNode.x > area.xMax || blockNode.y < area.yMin || blockNode.y > area.yMax || blockNode.z < area.zMin || blockNode.z > area.zMax || !this._world.func_72899_e(blockNode.x, blockNode.y, blockNode.z)) {
            return false;
        }
        Block block = this._world.func_147439_a(blockNode.x, blockNode.y, blockNode.z);
        return block.isReplaceable((IBlockAccess)this._world, blockNode.x, blockNode.y, blockNode.z);
    }

    @Override
    public void reset(World world, Area area, HarvestMode harvestMode, Map<String, Boolean> map) {
        this.setWorld(world);
        this._area = area;
        this.free();
        this._isDone = false;
        this._blocks = new BlockPool();
        BlockPosition blockPosition = area.getOrigin();
        this._blocks.push(BlockPool.getNext(blockPosition.x, blockPosition.y, blockPosition.z));
    }

    @Override
    public void setWorld(World world) {
        this._world = world;
    }

    @Override
    public boolean getIsDone() {
        return this._isDone;
    }

    @Override
    public BlockPosition getOrigin() {
        return this._area.getOrigin();
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("done", this._isDone);
        BlockPosition blockPosition = this.getOrigin();
        nBTTagCompound2.func_74783_a("area", new int[]{blockPosition.x - this._area.xMin, blockPosition.y - this._area.yMin, this._area.yMax - blockPosition.y});
        nBTTagCompound2.func_74783_a("origin", new int[]{blockPosition.x, blockPosition.y, blockPosition.z});
        NBTTagList nBTTagList = new NBTTagList();
        BlockPool.BlockNode blockNode = this._blocks.poke();
        while (blockNode != null) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.func_74768_a("x", blockNode.x);
            nBTTagCompound3.func_74768_a("y", blockNode.y);
            nBTTagCompound3.func_74768_a("z", blockNode.z);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound3);
            blockNode = blockNode.next;
        }
        nBTTagCompound2.func_74782_a("curPos", (NBTBase)nBTTagList);
        nBTTagCompound.func_74782_a("harvestManager", (NBTBase)nBTTagCompound2);
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.free();
        this._blocks = new BlockPool();
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("harvestManager");
        this._isDone = nBTTagCompound2.func_74767_n("done");
        int[] nArray = nBTTagCompound2.func_74759_k("area");
        int[] nArray2 = nBTTagCompound2.func_74759_k("origin");
        if (nArray == null | nArray2 == null || nArray2.length < 3 | nArray.length < 3) {
            this._area = new Area(new BlockPosition(0, -1, 0), 0, 0, 0);
            this._isDone = true;
            return;
        }
        this._area = new Area(new BlockPosition(nArray2[0], nArray2[1], nArray2[2]), nArray[0], nArray[1], nArray[2]);
        NBTTagList nBTTagList = (NBTTagList)nBTTagCompound2.func_74781_a("curPos");
        int n = nBTTagList.func_74745_c();
        for (int i = 0; i < n; ++i) {
            NBTTagCompound nBTTagCompound3 = nBTTagList.func_150305_b(i);
            this._blocks.push(BlockPool.getNext(nBTTagCompound3.func_74762_e("x"), nBTTagCompound3.func_74762_e("y"), nBTTagCompound3.func_74762_e("z")));
        }
    }

    @Override
    public void free() {
        if (this._blocks != null) {
            while (this._blocks.poke() != null) {
                this._blocks.shift().free();
            }
        }
        this._isDone = true;
    }
}

