/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

public class ArrayQueue<T> {
    private Object[] _values;
    private int _positionRead;
    private int _positionWrite;

    public ArrayQueue(int n) {
        this._values = new Object[n];
        this._positionRead = 0;
        this._positionWrite = 0;
    }

    private void moveNextRead() {
        ++this._positionRead;
        if (this._positionRead >= this._values.length) {
            this._positionRead = 0;
        }
    }

    private void moveNextWrite() {
        ++this._positionWrite;
        if (this._positionWrite >= this._values.length) {
            this._positionWrite = 0;
        }
    }

    public T peek() {
        return (T)this._values[this._positionRead];
    }

    public T pop() {
        T t = this.peek();
        this.moveNextRead();
        return t;
    }

    public void push(T t) {
        this._values[this._positionWrite] = t;
        this.moveNextWrite();
    }

    public int size() {
        return this._values.length;
    }

    public void clear() {
        this._positionRead = 0;
        this._positionWrite = 0;
        for (int i = 0; i < this._values.length; ++i) {
            this._values[i] = null;
        }
    }

    public void fill(T t) {
        for (int i = 0; i < this._values.length; ++i) {
            this._values[i] = t;
        }
    }

    public T[] toArray(T[] TArray) {
        int n = Math.min(TArray.length, this._values.length);
        for (int i = 0; i < n; ++i) {
            int n2 = this._positionRead + i;
            if (n2 >= this._values.length) {
                n2 -= this._values.length;
            }
            TArray[i] = this._values[n2];
        }
        return TArray;
    }
}

