/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import cofh.api.item.IAugmentItem;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import com.enderio.core.common.Lang;
import com.enderio.core.common.util.BlockCoord;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import tterrag.wailaplugins.WailaPlugins;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugin_ThermalExpansion
extends PluginBase {
    private Lang teLang = new Lang("info.thermalexpansion");

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TileMachineBase.class);
        this.registerNBT(TileMachineBase.class);
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileAugmentable) {
            if (WailaPlugins.proxy.isShiftKeyDown()) {
                currenttip.add(EnumChatFormatting.AQUA.toString() + "> " + lang.localize("augments.shown"));
                NBTTagList augments = accessor.getNBTData().func_150295_c("augments", 10);
                for (int i = 0; i < augments.func_74745_c(); ++i) {
                    ItemStack augmentStack = ItemStack.func_77949_a((NBTTagCompound)augments.func_150305_b(i));
                    if (augmentStack == null) continue;
                    IAugmentItem augment = (IAugmentItem)augmentStack.func_77973_b();
                    Set descs = augment.getAugmentTypes(augmentStack);
                    for (String s : descs) {
                        currenttip.add(EnumChatFormatting.WHITE + "-" + SpecialChars.TAB + EnumChatFormatting.WHITE + this.teLang.localize("augment." + s));
                    }
                }
            } else {
                currenttip.add(EnumChatFormatting.AQUA.toString() + "<" + EnumChatFormatting.ITALIC + lang.localize("augments.hidden") + EnumChatFormatting.AQUA + ">");
            }
        }
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        if (te instanceof TileAugmentable) {
            NBTTagList stacks = new NBTTagList();
            for (ItemStack stack : ((TileAugmentable)te).getAugmentSlots()) {
                if (stack == null) continue;
                NBTTagCompound stackTag = new NBTTagCompound();
                stack.func_77955_b(stackTag);
                stacks.func_74742_a((NBTBase)stackTag);
            }
            tag.func_74782_a("augments", (NBTBase)stacks);
        }
        te.func_145841_b(tag);
    }
}

