/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import cofh.api.energy.IEnergyHandler;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.alpha.TileCokeOven;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.blocks.machine.beta.TileBoilerTank;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackElectric;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.BoilerFuelTank;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.items.ItemElectricMeter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import tterrag.wailaplugins.config.WPConfigHandler;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugin_Railcraft
extends PluginBase
implements IWailaEntityProvider {
    private static final DecimalFormat fmtCharge = new DecimalFormat("#.##");

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TileMachineBase.class, TileTrack.class);
        this.registerEntityBody(this, EntityLocomotive.class);
        this.registerNBT(TileEngineSteam.class, IElectricGrid.class, TileTrack.class, EntityLocomotive.class, TileMultiBlock.class);
        this.addConfig("multiblocks");
        this.addConfig("heat");
        this.addConfig("tanks");
        this.addConfig("energy");
        this.addConfig("engines");
        this.addConfig("charge");
        this.addConfig("locomotives");
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        int energy;
        boolean hasMeter;
        TileEntity tile = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        ItemStack current = accessor.getPlayer().func_71045_bC();
        boolean bl = hasMeter = !WPConfigHandler.meterInHand || current != null && ItemUtil.stacksEqual((ItemStack)current, (ItemStack)ItemElectricMeter.getItem());
        if (tile instanceof TileMultiBlock && this.getConfig("multiblocks")) {
            currenttip.add(String.format(lang.localize("formed"), lang.localize(((TileMultiBlock)tile).isStructureValid() ? "yes" : "no")));
        }
        if ((tile instanceof TileEngineSteamHobby || tile instanceof TileBoilerFirebox || tile instanceof TileBoilerTank) && this.getConfig("heat")) {
            Plugin_Railcraft.addHeatTooltip(currenttip, tag);
        }
        if (tile instanceof IEnergyHandler && this.getConfig("energy") && tag.func_74764_b("Energy")) {
            energy = tag.func_74762_e("Energy");
            currenttip.add(energy + " / " + ((IEnergyHandler)tile).getMaxEnergyStored(ForgeDirection.UP) + " RF");
        }
        if (tile instanceof TileEngine && this.getConfig("engines")) {
            energy = tag.func_74762_e("energyRF");
            int gen = Math.round(tag.func_74760_g("currentOutput"));
            currenttip.add(energy + " / " + ((TileEngine)tile).maxEnergy() + " RF");
            currenttip.add(String.format(lang.localize("generating"), gen));
        }
        if (this.getConfig("tanks")) {
            int end = currenttip.size();
            TankManager dummy = null;
            Fluids[] fluids = null;
            if (tile instanceof TileCokeOven) {
                dummy = ((TileCokeOven)tile).getTankManager();
                fluids = new Fluids[]{Fluids.CREOSOTE};
            } else if (tile instanceof TileEngineSteamHobby) {
                dummy = ((TileEngineSteamHobby)tile).getTankManager();
                fluids = new Fluids[]{Fluids.STEAM, Fluids.WATER};
            } else if (tile instanceof TileEngineSteam) {
                dummy = ((TileEngineSteam)tile).getTankManager();
                fluids = new Fluids[]{Fluids.STEAM};
            } else if ("RCBoilerFireboxLiquidTile".equals(tag.func_74779_i("id"))) {
                dummy = ((TileBoiler)tile).getTankManager();
                if (dummy != null) {
                    TankManager manager = new TankManager(new StandardTank[]{new FilteredTank(dummy.get(0).getCapacity(), Fluids.WATER.get(), tile), new FilteredTank(dummy.get(1).getCapacity(), Fluids.STEAM.get(), tile), new BoilerFuelTank(dummy.get(2).getCapacity(), tile)});
                    manager.readTanksFromNBT(tag);
                    if (Plugin_Railcraft.addTankTooltip(currenttip, manager)) {
                        currenttip.add(end, "");
                    }
                }
            } else if ("RCBoilerFireboxSoildTile".equals(tag.func_74779_i("id"))) {
                dummy = ((TileBoiler)tile).getTankManager();
                fluids = new Fluids[]{Fluids.WATER, Fluids.STEAM};
            }
            if (fluids != null && dummy != null && Plugin_Railcraft.addTankTooltip(currenttip, Plugin_Railcraft.getTankManager(tile, tag, dummy, fluids))) {
                currenttip.add(end, "");
            }
        }
        if (this.getConfig("charge") && (tile instanceof IElectricGrid && tag.func_74764_b("chargeHandler") || tile instanceof TileTrack && ((TileTrack)tile).getTrackInstance() instanceof TrackElectric)) {
            Plugin_Railcraft.addChargeTooltip(currenttip, tag, hasMeter);
        }
    }

    private static void addChargeTooltip(List<String> currenttip, NBTTagCompound tag, boolean hasMeter) {
        double charge = tag.func_74775_l("chargeHandler").func_74769_h("charge");
        String chargeFmt = fmtCharge.format(charge) + "c";
        currenttip.add(EnumChatFormatting.RESET + String.format(lang.localize("charge"), hasMeter ? chargeFmt : EnumChatFormatting.ITALIC + lang.localize("needMeter")));
    }

    private static void addHeatTooltip(List<String> currenttip, NBTTagCompound tag) {
        int heat = Math.round(tag.func_74760_g("heat"));
        int max = Math.round(tag.func_74760_g("maxHeat"));
        currenttip.add(String.format(lang.localize("engineTemp"), heat, max));
    }

    private static TankManager getTankManager(TileEntity tile, NBTTagCompound tag, TankManager dummy, Fluids ... fluids) {
        FilteredTank[] tanks = new FilteredTank[fluids.length];
        for (int i = 0; i < tanks.length; ++i) {
            tanks[i] = new FilteredTank(dummy.get(i).getCapacity(), fluids[i].get(), tile);
        }
        TankManager manager = new TankManager((StandardTank[])tanks);
        manager.readTanksFromNBT(tag);
        return manager;
    }

    private static boolean addTankTooltip(List<String> currenttip, TankManager manager) {
        StandardTank tank = null;
        boolean ret = false;
        for (int i = 0; i < manager.getTankInfo().length; ++i) {
            FluidStack stored;
            tank = manager.get(i);
            if (tank == null || (stored = tank.getFluid()) == null) continue;
            ret = true;
            currenttip.add(stored.amount + " / " + tank.getCapacity() + " mB " + stored.getLocalizedName());
        }
        return ret;
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        if (te instanceof TileMultiBlock && ((TileMultiBlock)te).getMasterBlock() != null) {
            ((TileMultiBlock)te).getMasterBlock().func_145841_b(tag);
        } else {
            te.func_145841_b(tag);
        }
    }

    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (!this.getConfig("locomotives")) {
            return currenttip;
        }
        if (entity instanceof EntityLocomotiveElectric) {
            Plugin_Railcraft.addChargeTooltip(currenttip, tag, true);
        }
        if (entity instanceof EntityLocomotiveSteam) {
            Plugin_Railcraft.addHeatTooltip(currenttip, tag);
        }
        return currenttip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        return tag;
    }
}

