/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.util.BlockCoord;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugin_Forge
extends PluginBase {
    public static final String DSU_STACK = "dsuStack";
    public static final String DSU_AMNT = "dsuAmnt";

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(IDeepStorageUnit.class);
        this.registerNBT(IDeepStorageUnit.class);
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        ItemStack stored;
        TileEntity te = accessor.getTileEntity();
        NBTTagCompound tag = accessor.getNBTData();
        if (te instanceof IDeepStorageUnit && (stored = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(DSU_STACK))) != null) {
            int amount = tag.func_74762_e(DSU_AMNT);
            int overflow = 0;
            if (amount < 0) {
                overflow = Integer.MAX_VALUE + amount + 1;
            }
            int maxStack = stored.func_77976_d();
            int stacks = (amount < 0 ? Integer.MAX_VALUE : amount) / maxStack;
            String stacksStr = "" + stacks;
            if (stacks >= 10000000) {
                stacksStr = stacks / 1000000 + "M";
            } else if (stacks >= 1000000) {
                int num = stacks / 100000;
                float dec = (float)num / 10.0f;
                stacksStr = dec + "M";
            } else if (stacks >= 10000) {
                stacksStr = (float)(stacks / 100) / 10.0f + "K";
            }
            int leftover = amount - stacks * maxStack + overflow;
            String str = stacksStr + "*" + maxStack + " + " + leftover + " " + stored.func_82833_r();
            currenttip.add(str);
        }
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        if (te instanceof IDeepStorageUnit) {
            NBTTagCompound stackTag = new NBTTagCompound();
            ItemStack stack = ((IDeepStorageUnit)te).getStoredItemType();
            if (stack != null) {
                stack.func_77955_b(stackTag);
                tag.func_74782_a(DSU_STACK, (NBTBase)stackTag);
                tag.func_74768_a(DSU_AMNT, stack.field_77994_a);
            }
        }
    }
}

