/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.enderio.core.common.Lang;
import com.enderio.core.common.util.BlockCoord;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.apiculture.genetics.Bee;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TilePowered;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginApiculture;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import tterrag.wailaplugins.plugins.PluginBase;

public class Plugin_Forestry
extends PluginBase {
    private static Field _throttle;
    private static Field _maxHeat;
    private static NumberFormat pctFmt;
    private static Lang forLang;

    public Plugin_Forestry() {
        try {
            _throttle = BeekeepingLogic.class.getDeclaredField("throttle");
        }
        catch (NoSuchFieldException e) {
            _throttle = BeekeepingLogic.class.getDeclaredField("queenWorkCycleThrottle");
        }
        _throttle.setAccessible(true);
        _maxHeat = Engine.class.getDeclaredField("maxHeat");
        _maxHeat.setAccessible(true);
        pctFmt.setMinimumFractionDigits(2);
    }

    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(TilePowered.class, Engine.class, TileSapling.class, TileLeaves.class, TileBeehouse.class);
        this.registerNBT(TilePowered.class, Engine.class, TileBeehouse.class);
        this.addConfig("power");
        this.addConfig("heat");
        this.addConfig("sapling");
        this.addConfig("leaves");
        this.addConfig("apiary");
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        TileLeaves leaf;
        Block block = accessor.getBlock();
        TileEntity tile = accessor.getTileEntity();
        World world = accessor.getWorld();
        EntityPlayer player = accessor.getPlayer();
        MovingObjectPosition pos = accessor.getPosition();
        NBTTagCompound tag = accessor.getNBTData();
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        if ((tile instanceof TilePowered || tile instanceof Engine) && this.getConfig("power")) {
            EnergyStorage storage = new EnergyStorage(Integer.MAX_VALUE).readFromNBT(tag.func_74775_l("EnergyManager").func_74775_l("EnergyStorage"));
            currenttip.add(storage.getEnergyStored() + " / " + ((IEnergyHandler)tile).getMaxEnergyStored(accessor.getSide()) + " RF");
            if (tile instanceof Engine && this.getConfig("heat")) {
                double heat = tag.func_74762_e("EngineHeat");
                double maxHeat = _maxHeat.getInt(tile);
                currenttip.add(String.format(lang.localize("engineHeat"), pctFmt.format(heat / maxHeat)));
            }
        }
        if (tile instanceof TileSapling && this.getConfig("sapling")) {
            this.addGenomeTooltip((TileTreeContainer)((TileSapling)tile), player, currenttip);
        }
        if (tile instanceof TileLeaves && this.getConfig("leaves") && (leaf = (TileLeaves)tile).isPollinated()) {
            currenttip.add(String.format(lang.localize("pollinated"), leaf.getTree().getMate().getActiveAllele((IChromosomeType)EnumTreeChromosome.SPECIES).getName()));
        }
        if (tile instanceof TileBeehouse && this.getConfig("apiary")) {
            TileBeehouse apiary = (TileBeehouse)tile;
            InventoryAdapter inv = new InventoryAdapter(12, "Items");
            inv.readFromNBT(tag);
            ItemStack queenstack = inv.func_70301_a(0);
            ItemStack dronestack = inv.func_70301_a(1);
            Bee queen = null;
            if (inv.func_70301_a(0) != null) {
                queen = new Bee(queenstack.func_77978_p());
                String queenSpecies = this.getSpeciesName((IGenome)queen.getGenome(), true);
                currenttip.add(EnumChatFormatting.WHITE + String.format(lang.localize("mainbee"), this.getNameForBeeType(queenstack), EnumChatFormatting.GREEN + queenSpecies));
                if (queen.isAnalyzed()) {
                    this.addIndentedBeeInfo(queen, currenttip);
                }
            }
            Bee drone = null;
            if (queen != null && queen.getMate() != null) {
                drone = new Bee(queen.getMate());
            } else if (dronestack != null) {
                drone = new Bee(dronestack.func_77978_p());
            }
            if (drone != null) {
                currenttip.add(String.format(EnumChatFormatting.WHITE + lang.localize("secondarybee"), lang.localize("drone"), EnumChatFormatting.GREEN + this.getSpeciesName((IGenome)drone.getGenome(), true)));
                if (drone.isAnalyzed()) {
                    this.addIndentedBeeInfo(drone, currenttip);
                }
            }
            BeekeepingLogic logic = new BeekeepingLogic((IBeeHousing)apiary);
            logic.readFromNBT(tag);
            IErrorState err = logic.getHousing().getErrorState();
            if (err != EnumErrorCode.OK) {
                currenttip.add(EnumChatFormatting.WHITE + String.format(lang.localize("breedError"), EnumChatFormatting.RED + forLang.localize(err.getDescription())));
            } else if (queen != null && ForestryItem.beeQueenGE.isItemEqual(queenstack.func_77973_b())) {
                float throttle = _throttle.getInt(logic);
                float maxAge = queen.getMaxHealth();
                float age = Math.abs((float)queen.getHealth() - maxAge);
                float step = 1.0f / maxAge;
                float progress = step * (throttle / (float)PluginApiculture.ticksPerBeeWorkCycle);
                currenttip.add(EnumChatFormatting.WHITE + String.format(lang.localize("breedProgress"), EnumChatFormatting.AQUA + pctFmt.format(age / maxAge + progress)));
            }
        }
    }

    private void addGenomeTooltip(TileTreeContainer te, EntityPlayer player, List<String> currenttip) {
        ITree tree = te.getTree();
        if (te.isOwner(player) && (tree.isAnalyzed() || te instanceof TileLeaves)) {
            this.addTreeTooltip(tree, currenttip);
        } else if (tree != null) {
            currenttip.add(EnumChatFormatting.ITALIC + (tree.isAnalyzed() ? lang.localize("notOwner") : lang.localize("notAnalyzed")));
        }
    }

    private void addTreeTooltip(ITree tree, List<String> currenttip) {
        if (Proxies.common.isShiftDown()) {
            tree.addTooltip(currenttip);
        } else {
            currenttip.add(this.getTMI());
        }
    }

    private String getTMI() {
        return EnumChatFormatting.ITALIC + "<" + StringUtil.localize((String)"gui.tooltip.tmi") + ">";
    }

    private String getSpeciesName(IGenome genome, boolean active) {
        return active ? genome.getActiveAllele((IChromosomeType)EnumBeeChromosome.SPECIES).getName() : genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.SPECIES).getName();
    }

    private String getNameForBeeType(ItemStack bee) {
        return ForestryItem.beeDroneGE.isItemEqual(bee.func_77973_b()) ? lang.localize("drone") : (ForestryItem.beePrincessGE.isItemEqual(bee.func_77973_b()) ? lang.localize("princess") : lang.localize("queen"));
    }

    private void addIndentedBeeInfo(Bee bee, List<String> currenttip) {
        if (Proxies.common.isShiftDown()) {
            ArrayList<String> tt = new ArrayList<String>();
            bee.addTooltip(tt);
            for (int i = 0; i < tt.size(); ++i) {
                tt.set(i, (i == 0 ? ">" : "") + SpecialChars.TAB + (String)tt.get(i));
            }
            currenttip.addAll(tt);
        } else {
            currenttip.add(this.getTMI());
        }
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        te.func_145841_b(tag);
    }

    static {
        pctFmt = NumberFormat.getPercentInstance();
        forLang = new Lang("for");
    }
}

