/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.BlockCoord;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tterrag.wailaplugins.WailaPlugins;
import tterrag.wailaplugins.api.IPlugin;
import tterrag.wailaplugins.plugins.Plugins;

public abstract class PluginBase
implements IPlugin {
    protected static final Lang lang = WailaPlugins.lang;
    protected static final Lang wailaLang = new Lang("hud.msg");
    private static final Lang configLang = new Lang("wp");
    private IWailaRegistrar reg;

    @Override
    public void load(IWailaRegistrar registrar) {
        this.reg = registrar;
    }

    protected void registerHead(Class<?> ... classes) {
        this.registerAll(RegType.HEAD, classes);
    }

    protected void registerBody(Class<?> ... classes) {
        this.registerAll(RegType.BODY, classes);
    }

    protected void registerTail(Class<?> ... classes) {
        this.registerAll(RegType.TAIL, classes);
    }

    protected void registerStack(Class<?> ... classes) {
        this.registerAll(RegType.STACK, classes);
    }

    protected void registerNBT(Class<?> ... classes) {
        this.registerAll(RegType.NBT, classes);
    }

    protected void registerEntityBody(IWailaEntityProvider inst, Class<?> ... classes) {
        this.registerAll(RegType.ENTITY_BODY, classes);
    }

    protected void registerAll(RegType type, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            type.register(this, clazz);
        }
    }

    protected void addConfig(String key) {
        this.addConfig(key, true);
    }

    protected void addConfig(String key, boolean def) {
        ConfigHandler.instance().addConfig(Plugins.getModName(this.getClass()), this.getKey(key), configLang.localize(String.format("config.%s.%s", Plugins.getModid(this.getClass()), key)), def);
    }

    protected boolean getConfig(String key) {
        return ConfigHandler.instance().getConfig("modules", this.getKey(key), true);
    }

    private String getKey(String key) {
        return Plugins.getModid(this.getClass()) + ":" + key;
    }

    public final ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.enabled()) {
            return this.getWailaStack(accessor);
        }
        return null;
    }

    protected ItemStack getWailaStack(IWailaDataAccessor accessor) {
        return null;
    }

    public final List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.enabled()) {
            this.getHead(itemStack, currenttip, accessor);
        }
        return currenttip;
    }

    protected void getHead(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
    }

    public final List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.enabled()) {
            this.getBody(itemStack, currenttip, accessor);
        }
        return currenttip;
    }

    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
    }

    public final List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.enabled()) {
            this.getTail(itemStack, currenttip, accessor);
        }
        return currenttip;
    }

    protected void getTail(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
    }

    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (this.enabled()) {
            this.getNBTData(te, tag, world, new BlockCoord(x, y, z));
            tag.func_74768_a("x", x);
            tag.func_74768_a("y", y);
            tag.func_74768_a("z", z);
        }
        return tag;
    }

    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
    }

    protected boolean enabled() {
        return ConfigHandler.instance().getConfig("modules", Plugins.getModid(this.getClass()), true);
    }

    private static enum RegType {
        HEAD{

            @Override
            void register(PluginBase inst, Class<?> c) {
                inst.reg.registerHeadProvider((IWailaDataProvider)inst, c);
            }
        }
        ,
        BODY{

            @Override
            void register(PluginBase inst, Class<?> c) {
                inst.reg.registerBodyProvider((IWailaDataProvider)inst, c);
            }
        }
        ,
        TAIL{

            @Override
            void register(PluginBase inst, Class<?> c) {
                inst.reg.registerTailProvider((IWailaDataProvider)inst, c);
            }
        }
        ,
        NBT{

            @Override
            void register(PluginBase inst, Class<?> c) {
                inst.reg.registerNBTProvider((IWailaDataProvider)inst, c);
            }
        }
        ,
        STACK{

            @Override
            void register(PluginBase inst, Class<?> c) {
                inst.reg.registerStackProvider((IWailaDataProvider)inst, c);
            }
        }
        ,
        ENTITY_BODY{

            @Override
            void register(PluginBase inst, Class<?> c) {
                inst.reg.registerBodyProvider((IWailaEntityProvider)inst, c);
            }
        };


        abstract void register(PluginBase var1, Class<?> var2);
    }
}

