/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeDecoratorMoon;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeGenBaseMoon;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import micdoodle8.mods.galacticraft.core.world.gen.MapGenCavesMoon;
import micdoodle8.mods.galacticraft.core.world.gen.MapGenVillageMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomBossMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomChestsMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomEmptyMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomSpawnerMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasureMoon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkProviderMoon
extends ChunkProviderGenerate {
    final Block topBlockID = GCBlocks.blockMoon;
    final byte topBlockMeta = (byte)5;
    final Block fillBlockID = GCBlocks.blockMoon;
    final byte fillBlockMeta = (byte)3;
    final Block lowerBlockID = GCBlocks.blockMoon;
    final byte lowerBlockMeta = (byte)4;
    private final Random rand;
    private final NoiseModule noiseGen1;
    private final NoiseModule noiseGen2;
    private final NoiseModule noiseGen3;
    private final NoiseModule noiseGen4;
    public BiomeDecoratorMoon biomedecoratorplanet = new BiomeDecoratorMoon(BiomeGenBaseMoon.moonFlat);
    private final World worldObj;
    private final MapGenVillageMoon villageGenerator = new MapGenVillageMoon();
    private final MapGenDungeon dungeonGenerator = new MapGenDungeon(GCBlocks.blockMoon, 14, 8, 16, 3);
    private BiomeGenBase[] biomesForGeneration;
    private final MapGenBaseMeta caveGenerator;
    private static final int CRATER_PROB = 300;
    private static final int MID_HEIGHT = 63;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;

    public ChunkProviderMoon(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.dungeonGenerator.otherRooms.add(new RoomEmptyMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new RoomBossMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new RoomTreasureMoon(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.biomesForGeneration = new BiomeGenBase[]{BiomeGenBaseMoon.moonFlat};
        this.caveGenerator = new MapGenCavesMoon();
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 1, 0.25f);
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.noiseGen1.setFrequency(0.0125f);
        this.noiseGen2.setFrequency(0.015f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.02f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d = this.noiseGen1.getNoise(x + chunkX * 16, z + chunkZ * 16) * 8.0f;
                double d2 = this.noiseGen2.getNoise(x + chunkX * 16, z + chunkZ * 16) * 24.0f;
                double d3 = (double)this.noiseGen3.getNoise(x + chunkX * 16, z + chunkZ * 16) - 0.1;
                double yDev = 0.0;
                yDev = d3 < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * (d3 *= 4.0));
                for (int y = 0; y < 128; ++y) {
                    if (!((double)y < 63.0 + yDev)) continue;
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockID;
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockMeta;
                }
            }
        }
    }

    public void func_147422_a(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)((double)this.noiseGen4.getNoise(var8 + par1 * 16, var9 * par2 * 16) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = this.topBlockID;
                int var14m = this.topBlockMeta;
                Block var15 = this.fillBlockID;
                int var15m = this.fillBlockMeta;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    arrayOfMeta[index] = 0;
                    if (var16 <= 0 + this.rand.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                        continue;
                    }
                    Block var18 = arrayOfIDs[index];
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.lowerBlockID) continue;
                    arrayOfMeta[index] = this.lowerBlockMeta;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var14m = 0;
                            var15 = this.lowerBlockID;
                            var15m = this.lowerBlockMeta;
                        } else if (var16 >= 36 && var16 <= 21) {
                            var14 = this.topBlockID;
                            var14m = this.topBlockMeta;
                            var14 = this.fillBlockID;
                            var14m = this.fillBlockMeta;
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        if (var16 >= 19 || var16 < 18) continue;
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Object[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        Arrays.fill(ids, Blocks.field_150350_a);
        this.generateTerrain(par1, par2, (Block[])ids, meta);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.createCraters(par1, par2, (Block[])ids, meta);
        this.func_147422_a(par1, par2, (Block[])ids, meta, this.biomesForGeneration);
        this.caveGenerator.generate((IChunkProvider)this, this.worldObj, par1, par2, (Block[])ids, meta);
        this.dungeonGenerator.generateUsingArrays(this.worldObj, this.worldObj.func_72905_C(), par1 * 16, 25, par2 * 16, par1, par2, (Block[])ids, meta);
        Chunk var4 = new Chunk(this.worldObj, (Block[])ids, meta, par1, par2);
        var4.func_76603_b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, Block[] chunkArray, byte[] metaArray) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen4.getNoise(x * 16 + x, cz * 16 + z) / 300.0f))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, Block[] chunkArray, byte[] metaArray) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != chunkArray[this.getIndex(x, y, z)] && (double)helper <= yDev) {
                        chunkArray[this.getIndex((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public int func_73152_e() {
        return 0;
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void decoratePlanet(World par1World, Random par2Random, int par3, int par4) {
        this.biomedecoratorplanet.decorate(par1World, par2Random, par3, par4);
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockFalling.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.worldObj.func_72905_C());
        this.dungeonGenerator.handleTileEntities(this.rand);
        if (!ConfigManagerCore.disableMoonVillageGen) {
            this.villageGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
        }
        this.decoratePlanet(this.worldObj, this.rand, var4, var5);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "MoonLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            return monsters;
        }
        return null;
    }

    public void func_82695_e(int par1, int par2) {
        if (!ConfigManagerCore.disableMoonVillageGen) {
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, null);
        }
    }
}

