/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemOilCanister;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemOilExtractor
extends Item {
    protected IIcon[] icons = new IIcon[5];

    public ItemOilExtractor(String assetName) {
        this.func_77625_d(1);
        this.func_77655_b(assetName);
        this.func_111206_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
    }

    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        if (this.getNearestOilBlock(player) != null && this.openCanister(player) != null) {
            player.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[5];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.func_111208_A() + "_" + (i + 1));
        }
        this.field_77791_bV = this.icons[0];
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        ItemStack canister;
        int z;
        int y;
        int x;
        Vector3 blockHit = this.getNearestOilBlock(player);
        if (blockHit != null && this.isOilBlock(player, player.field_70170_p, x = MathHelper.func_76128_c((double)blockHit.x), y = MathHelper.func_76128_c((double)blockHit.y), z = MathHelper.func_76128_c((double)blockHit.z), false) && this.openCanister(player) != null && (canister = this.openCanister(player)) != null && count % 5 == 0 && canister.func_77960_j() > 1) {
            this.isOilBlock(player, player.field_70170_p, x, y, z, true);
            canister.func_77964_b(Math.max(canister.func_77960_j() - 200, 1));
        }
    }

    private ItemStack openCanister(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemOilCanister) || stack.func_77958_k() - stack.func_77960_j() < 0 || stack.func_77958_k() - stack.func_77960_j() >= GCItems.oilCanister.func_77612_l() - 1) continue;
            return stack;
        }
        return null;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
        return par1ItemStack;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int count2 = useRemaining / 2;
        switch (count2 % 5) {
            case 0: {
                if (useRemaining == 0) {
                    return this.icons[0];
                }
                return this.icons[4];
            }
            case 1: {
                return this.icons[3];
            }
            case 2: {
                return this.icons[2];
            }
            case 3: {
                return this.icons[1];
            }
            case 4: {
                return this.icons[0];
            }
        }
        return this.icons[0];
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer player, int par4) {
        if (par2World.field_72995_K) {
            this.field_77791_bV = this.icons[0];
        }
    }

    private boolean isOilBlock(EntityPlayer player, World world, int x, int y, int z, boolean doDrain) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlockHit = (IFluidBlock)block;
            boolean flag = false;
            if (block == GCBlocks.crudeOilStill) {
                flag = true;
            } else {
                Fluid fluidHit = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluidHit != null && fluidHit.getName().equalsIgnoreCase("oil")) {
                    flag = true;
                }
            }
            if (flag) {
                FluidStack stack = fluidBlockHit.drain(world, x, y, z, doDrain);
                return stack != null && stack.amount > 0;
            }
        }
        return false;
    }

    private Vector3 getNearestOilBlock(EntityPlayer par1EntityPlayer) {
        float var4 = 1.0f;
        float var5 = par1EntityPlayer.field_70127_C + (par1EntityPlayer.field_70125_A - par1EntityPlayer.field_70127_C) * 1.0f;
        float var6 = par1EntityPlayer.field_70126_B + (par1EntityPlayer.field_70177_z - par1EntityPlayer.field_70126_B) * 1.0f;
        double var7 = par1EntityPlayer.field_70169_q + (par1EntityPlayer.field_70165_t - par1EntityPlayer.field_70169_q) * 1.0;
        double var9 = par1EntityPlayer.field_70167_r + (par1EntityPlayer.field_70163_u - par1EntityPlayer.field_70167_r) * 1.0 + 1.62 - (double)par1EntityPlayer.field_70129_M;
        double var11 = par1EntityPlayer.field_70166_s + (par1EntityPlayer.field_70161_v - par1EntityPlayer.field_70166_s) * 1.0;
        Vector3 var13 = new Vector3(var7, var9, var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 5.0;
        if (par1EntityPlayer instanceof EntityPlayerMP) {
            var21 = ((EntityPlayerMP)par1EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        for (double dist = 0.0; dist <= var21; dist += 1.0) {
            Vector3 var23 = var13.translate(new Vector3((double)var18 * dist, (double)var17 * dist, (double)var20 * dist));
            if (!this.isOilBlock(par1EntityPlayer, par1EntityPlayer.field_70170_p, MathHelper.func_76128_c((double)var23.x), MathHelper.func_76128_c((double)var23.y), MathHelper.func_76128_c((double)var23.z), false)) continue;
            return var23;
        }
        return null;
    }
}

