/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.lang.reflect.Method;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyUtil {
    private static boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
    private static boolean isRFLoaded = EnergyConfigHandler.isRFAPILoaded();
    private static boolean isRF1Loaded = EnergyConfigHandler.isRFAPIv1Loaded();
    private static boolean isRF2Loaded = EnergyConfigHandler.isRFAPIv2Loaded();
    private static boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
    private static boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded();
    private static boolean isBC6Loaded = isBCLoaded && EnergyConfigHandler.getBuildcraftVersion() == 6;
    private static boolean isBCReallyLoaded = EnergyConfigHandler.isBuildcraftReallyLoaded();
    public static boolean voltageParameterIC2 = false;
    public static Method demandedEnergyIC2 = null;
    public static Method injectEnergyIC2 = null;
    private static Class<?> clazzMekCable = null;
    public static Class<?> clazzEnderIOCable = null;
    private static Class<?> clazzPipeTile = null;
    private static Class<?> clazzPipeWood = null;
    public static boolean initialisedIC2Methods = EnergyUtil.initialiseIC2Methods();

    public static TileEntity[] getAdjacentPowerConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[6];
        BlockVec3 thisVec = new BlockVec3(tile);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.func_145831_w(), direction);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.POWER)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isMekLoaded && (tileEntity instanceof IStrictEnergyAcceptor || tileEntity instanceof ICableOutputter)) {
                try {
                    if (clazzMekCable != null && clazzMekCable.isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tileEntity instanceof IStrictEnergyAcceptor && ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof ICableOutputter) || !((ICableOutputter)tileEntity).canOutputTo(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isRFLoaded && tileEntity instanceof IEnergyConnection) {
                if ((!isRF1Loaded || !(tileEntity instanceof IEnergyHandler)) && (!isRF2Loaded || !(tileEntity instanceof IEnergyProvider) && !(tileEntity instanceof IEnergyReceiver))) continue;
                try {
                    if (clazzEnderIOCable != null && clazzEnderIOCable.isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!((IEnergyConnection)tileEntity).canConnectEnergy(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isIC2Loaded && tileEntity instanceof IEnergyTile) {
                if (tileEntity instanceof IEnergyConductor) continue;
                if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof IEnergyEmitter) || !((IEnergyEmitter)tileEntity).emitsEnergyTo(tile, direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!isBCLoaded) continue;
            if (isBCReallyLoaded) {
                try {
                    Object pipe;
                    if (clazzPipeTile.isInstance(tileEntity) && clazzPipeWood.isInstance(pipe = clazzPipeTile.getField("pipe").get(tileEntity))) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (EnergyConfigHandler.getBuildcraftVersion() == 6 && MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)direction.getOpposite()) != null) {
                adjacentConnections[direction.ordinal()] = tileEntity;
            }
            if (!(tileEntity instanceof IPowerReceptor) || ((IPowerReceptor)tileEntity).getPowerReceiver(direction.getOpposite()) == null) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static float otherModsEnergyTransfer(TileEntity tileAdj, ForgeDirection inputAdj, float toSend, boolean simulate) {
        if (isMekLoaded && tileAdj instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor tileMek = (IStrictEnergyAcceptor)tileAdj;
            if (tileMek.canReceiveEnergy(inputAdj)) {
                float transferredMek = simulate ? (tileMek.canReceiveEnergy(inputAdj) ? (float)(tileMek.getMaxEnergy() - tileMek.getEnergy()) : 0.0f) : (float)tileMek.transferEnergyToAcceptor(inputAdj, (double)(toSend * EnergyConfigHandler.TO_MEKANISM_RATIO));
                return transferredMek / EnergyConfigHandler.TO_MEKANISM_RATIO;
            }
        } else if (isIC2Loaded && tileAdj instanceof IEnergySink) {
            double demanded;
            block17: {
                demanded = 0.0;
                try {
                    demanded = (Double)demandedEnergyIC2.invoke((Object)tileAdj, new Object[0]);
                }
                catch (Exception ex) {
                    if (!ConfigManagerCore.enableDebug) break block17;
                    ex.printStackTrace();
                }
            }
            double energySendingIC2 = Math.min((double)(toSend * EnergyConfigHandler.TO_IC2_RATIO), demanded);
            if (energySendingIC2 >= 1.0) {
                double result;
                block18: {
                    result = 0.0;
                    try {
                        result = voltageParameterIC2 ? energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2, 120.0) : energySendingIC2 - (Double)injectEnergyIC2.invoke((Object)tileAdj, inputAdj, energySendingIC2);
                    }
                    catch (Exception ex) {
                        if (!ConfigManagerCore.enableDebug) break block18;
                        ex.printStackTrace();
                    }
                }
                if (result < 0.0) {
                    result = 0.0;
                }
                return (float)result / EnergyConfigHandler.TO_IC2_RATIO;
            }
        } else {
            PowerHandler.PowerReceiver receiver;
            if (isRF1Loaded && tileAdj instanceof IEnergyHandler) {
                return (float)((IEnergyHandler)tileAdj).receiveEnergy(inputAdj, MathHelper.func_76141_d((float)(toSend * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
            }
            if (isRF2Loaded && tileAdj instanceof IEnergyReceiver) {
                return (float)((IEnergyReceiver)tileAdj).receiveEnergy(inputAdj, MathHelper.func_76141_d((float)(toSend * EnergyConfigHandler.TO_RF_RATIO)), simulate) / EnergyConfigHandler.TO_RF_RATIO;
            }
            if (isBC6Loaded && MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj) != null) {
                double toSendBC = Math.min((double)(toSend * EnergyConfigHandler.TO_BC_RATIO), MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj).getEnergyRequested());
                if (simulate) {
                    return (float)toSendBC / EnergyConfigHandler.TO_BC_RATIO;
                }
                return (float)MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj).addEnergy(toSendBC) / EnergyConfigHandler.TO_BC_RATIO;
            }
            if (isBCLoaded && tileAdj instanceof IPowerReceptor && (receiver = ((IPowerReceptor)tileAdj).getPowerReceiver(inputAdj)) != null) {
                double toSendBC = Math.min((double)(toSend * EnergyConfigHandler.TO_BC_RATIO), Math.min(receiver.powerRequest(), receiver.getMaxEnergyReceived()));
                if (simulate) {
                    return (float)toSendBC / EnergyConfigHandler.TO_BC_RATIO;
                }
                float rec = (float)receiver.receiveEnergy(PowerHandler.Type.PIPE, toSendBC, inputAdj);
                return rec / EnergyConfigHandler.TO_BC_RATIO;
            }
        }
        return 0.0f;
    }

    public static boolean otherModCanReceive(TileEntity tileAdj, ForgeDirection inputAdj) {
        if (isMekLoaded && tileAdj instanceof IStrictEnergyAcceptor) {
            return ((IStrictEnergyAcceptor)tileAdj).canReceiveEnergy(inputAdj);
        }
        if (isIC2Loaded && tileAdj instanceof IEnergyAcceptor) {
            return ((IEnergyAcceptor)tileAdj).acceptsEnergyFrom(null, inputAdj);
        }
        if (isRF1Loaded && tileAdj instanceof IEnergyHandler || isRF2Loaded && tileAdj instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tileAdj).canConnectEnergy(inputAdj);
        }
        if (isBC6Loaded && MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)inputAdj) != null) {
            return true;
        }
        if (isBCLoaded && tileAdj instanceof IPowerReceptor) {
            return ((IPowerReceptor)tileAdj).getPowerReceiver(inputAdj) != null;
        }
        return false;
    }

    public static boolean initialiseIC2Methods() {
        try {
            clazzMekCable = Class.forName("codechicken.multipart.TileMultipart");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            clazzEnderIOCable = Class.forName("crazypants.enderio.conduit.TileConduitBundle");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            clazzPipeTile = Class.forName("buildcraft.transport.TileGenericPipe");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            clazzPipeWood = Class.forName("buildcraft.transport.pipes.PipePowerWood");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (isIC2Loaded) {
            if (ConfigManagerCore.enableDebug) {
                GCLog.info("Debug: Initialising IC2 methods OK");
            }
            try {
                Class<?> clazz = Class.forName("ic2.api.energy.tile.IEnergySink");
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Debug: Found IC2 IEnergySink class OK");
                }
                try {
                    demandedEnergyIC2 = clazz.getMethod("demandedEnergyUnits", new Class[0]);
                }
                catch (Exception e) {
                    try {
                        demandedEnergyIC2 = clazz.getMethod("getDemandedEnergy", new Class[0]);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Debug: Set IC2 demandedEnergy method OK");
                }
                try {
                    injectEnergyIC2 = clazz.getMethod("injectEnergyUnits", ForgeDirection.class, Double.TYPE);
                    if (ConfigManagerCore.enableDebug) {
                        GCLog.info("Debug: IC2 inject 1.7.2 succeeded");
                    }
                }
                catch (Exception e) {
                    try {
                        injectEnergyIC2 = clazz.getMethod("injectEnergy", ForgeDirection.class, Double.TYPE, Double.TYPE);
                        voltageParameterIC2 = true;
                        if (ConfigManagerCore.enableDebug) {
                            GCLog.info("Debug: IC2 inject 1.7.10 succeeded");
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

