/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpinThruster;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOrbit;
import micdoodle8.mods.galacticraft.core.dimension.OrbitSpinSaveData;
import micdoodle8.mods.galacticraft.core.entities.player.FreefallHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.world.gen.ChunkProviderOrbit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderOrbit
extends WorldProviderSpace
implements IOrbitDimension,
ISolarLevel,
IExitHeight {
    public int spaceStationDimensionID;
    private static final float GFORCE = 0.024525002f;
    private OrbitSpinSaveData savefile;
    public boolean doSpinning = true;
    private float angularVelocityRadians = 0.0f;
    private float skyAngularVelocity = (float)((double)(this.angularVelocityRadians * 180.0f) / Math.PI);
    private float angularVelocityTarget = 0.0f;
    private float angularVelocityAccel = 0.0f;
    private double spinCentreX;
    private double spinCentreZ;
    private float momentOfInertia;
    private float massCentreX;
    private float massCentreZ;
    private int ssBoundsMaxX;
    private int ssBoundsMinX;
    private int ssBoundsMaxY;
    private int ssBoundsMinY;
    private int ssBoundsMaxZ;
    private int ssBoundsMinZ;
    private LinkedList<BlockVec3> thrustersPlus = new LinkedList();
    private LinkedList<BlockVec3> thrustersMinus = new LinkedList();
    private BlockVec3 oneSSBlock;
    private HashSet<BlockVec3> checked = new HashSet();
    private float artificialG;
    public boolean thrustersFiring = false;
    private boolean dataNotLoaded = true;
    private List<Entity> loadedEntities = new LinkedList<Entity>();
    private double pPrevMotionX = 0.0;
    public double pPrevMotionY = 0.0;
    private double pPrevMotionZ = 0.0;
    private int pjumpticks = 0;
    private boolean pWasOnGround = false;

    @Override
    public void setDimension(int var1) {
        this.spaceStationDimensionID = var1;
        super.setDimension(var1);
    }

    @Override
    public CelestialBody getCelestialBody() {
        return GalacticraftCore.satelliteSpaceStation;
    }

    @Override
    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public boolean canRainOrSnow() {
        return false;
    }

    @Override
    public boolean hasSunset() {
        return false;
    }

    @Override
    public long getDayLength() {
        return 24000L;
    }

    @Override
    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @Override
    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderOrbit.class;
    }

    @Override
    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @Override
    public void updateWeather() {
        super.updateWeather();
        if (!this.field_76579_a.field_72995_K) {
            if (this.dataNotLoaded) {
                this.savefile = OrbitSpinSaveData.initWorldData(this.field_76579_a);
                this.readFromNBT(this.savefile.datacompound);
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Loading data from save: " + this.savefile.datacompound.func_74760_g("omegaSky"));
                }
                this.dataNotLoaded = false;
            }
            if (this.doSpinning) {
                float newAngle;
                boolean updateNeeded = true;
                if (this.angularVelocityTarget < this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians - this.angularVelocityAccel;
                    if (newAngle < this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.angularVelocityTarget > this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians + this.angularVelocityAccel;
                    if (newAngle > this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.thrustersFiring) {
                    this.thrustersFiring = false;
                } else {
                    updateNeeded = false;
                }
                if (updateNeeded) {
                    this.writeToNBT(this.savefile.datacompound);
                    this.savefile.func_76185_a();
                    ArrayList<Object> objList = new ArrayList<Object>();
                    objList.add(Float.valueOf(this.angularVelocityRadians));
                    objList.add(this.thrustersFiring);
                    GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), this.spaceStationDimensionID);
                }
                this.loadedEntities.clear();
                this.loadedEntities.addAll(this.field_76579_a.field_72996_f);
                for (Entity e : this.loadedEntities) {
                    if (!(e instanceof EntityItem) && (!(e instanceof EntityLivingBase) || e instanceof EntityPlayer) && !(e instanceof EntityTNTPrimed) && !(e instanceof EntityFallingBlock) || e.field_70122_E) continue;
                    boolean freefall = true;
                    if (e.field_70121_D.field_72336_d >= (double)this.ssBoundsMinX && e.field_70121_D.field_72340_a <= (double)this.ssBoundsMaxX && e.field_70121_D.field_72337_e >= (double)this.ssBoundsMinY && e.field_70121_D.field_72338_b <= (double)this.ssBoundsMaxY && e.field_70121_D.field_72334_f >= (double)this.ssBoundsMinZ && e.field_70121_D.field_72339_c <= (double)this.ssBoundsMaxZ) {
                        int xmx = MathHelper.func_76128_c((double)(e.field_70121_D.field_72336_d + 0.2));
                        int ym = MathHelper.func_76128_c((double)(e.field_70121_D.field_72338_b - 0.1));
                        int yy = MathHelper.func_76128_c((double)(e.field_70121_D.field_72337_e + 0.1));
                        int zm = MathHelper.func_76128_c((double)(e.field_70121_D.field_72339_c - 0.2));
                        int zz = MathHelper.func_76128_c((double)(e.field_70121_D.field_72334_f + 0.2));
                        block1: for (int x = MathHelper.func_76128_c((double)(e.field_70121_D.field_72340_a - 0.2)); x <= xmx; ++x) {
                            for (int y = ym; y <= yy; ++y) {
                                for (int z = zm; z <= zz; ++z) {
                                    if (!this.field_76579_a.func_72899_e(x, y, z) || Blocks.field_150350_a == this.field_76579_a.func_147439_a(x, y, z)) continue;
                                    freefall = false;
                                    break block1;
                                }
                            }
                        }
                    }
                    if (!freefall) continue;
                    if (this.angularVelocityRadians != 0.0f) {
                        double xx = e.field_70165_t - this.spinCentreX;
                        double zz = e.field_70161_v - this.spinCentreZ;
                        double arc = Math.sqrt(xx * xx + zz * zz);
                        float angle = xx == 0.0 ? (zz > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz / xx);
                        if (xx < 0.0) {
                            angle += (float)Math.PI;
                        }
                        double offsetX = -(arc *= (double)this.angularVelocityRadians) * (double)MathHelper.func_76126_a((float)(angle += this.angularVelocityRadians / 3.0f));
                        double offsetZ = arc * (double)MathHelper.func_76134_b((float)angle);
                        e.field_70165_t += offsetX;
                        e.field_70161_v += offsetZ;
                        e.field_70142_S += offsetX;
                        e.field_70136_U += offsetZ;
                        if (!this.field_76579_a.func_72899_e(MathHelper.func_76128_c((double)e.field_70165_t), 64, MathHelper.func_76128_c((double)e.field_70161_v))) {
                            e.func_70106_y();
                        }
                        e.field_70121_D.func_72317_d(offsetX, 0.0, offsetZ);
                        e.field_70177_z += this.skyAngularVelocity;
                        while (e.field_70177_z > 360.0f) {
                            e.field_70177_z -= 360.0f;
                        }
                    }
                    if (e instanceof EntityLivingBase) {
                        e.field_70159_w /= (double)0.91f;
                        e.field_70179_y /= (double)0.91f;
                        if (e instanceof EntityFlying) {
                            e.field_70181_x /= (double)0.91f;
                            continue;
                        }
                        e.field_70181_x /= (double)0.98f;
                        continue;
                    }
                    if (e instanceof EntityFallingBlock) {
                        e.field_70181_x /= (double)0.98f;
                        continue;
                    }
                    e.field_70159_w /= (double)0.98f;
                    e.field_70181_x /= (double)0.98f;
                    e.field_70179_y /= (double)0.98f;
                }
            }
        }
    }

    @Override
    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    @Override
    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    @Override
    public String func_80007_l() {
        return "Space Station " + this.spaceStationDimensionID;
    }

    @Override
    public float getGravity() {
        return 0.075f;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return false;
    }

    @Override
    public double getMeteorFrequency() {
        return 0.0;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    @Override
    public String getPlanetToOrbit() {
        return "Overworld";
    }

    @Override
    public int getYCoordToTeleportToPlanet() {
        return 30;
    }

    @Override
    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.spaceStationDimensionID;
    }

    @Override
    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    @Override
    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    @Override
    public boolean canSpaceshipTierPass(int tier) {
        return tier > 0;
    }

    @Override
    public float getFallDamageModifier() {
        return 0.4f;
    }

    @Override
    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void preVanillaMotion(EntityPlayerSP p) {
        FreefallHandler.setupFreefallPre(p);
        this.pWasOnGround = p.field_70122_E;
    }

    @SideOnly(value=Side.CLIENT)
    public void postVanillaMotion(EntityPlayerSP p) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(p);
        boolean freefall = stats.inFreefall;
        if (freefall) {
            p.field_70139_V = 0.0f;
        }
        stats.inFreefall = freefall = this.testFreefall(p, freefall);
        stats.inFreefallFirstCheck = true;
        boolean doGravity = true;
        if (freefall) {
            doGravity = false;
            this.pjumpticks = 0;
            if (this.doSpinning && this.angularVelocityRadians != 0.0f) {
                double xx = p.field_70165_t - this.spinCentreX;
                double zz = p.field_70161_v - this.spinCentreZ;
                double arc = Math.sqrt(xx * xx + zz * zz);
                float angle = xx == 0.0 ? (zz > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz / xx);
                if (xx < 0.0) {
                    angle += (float)Math.PI;
                }
                double offsetX = -(arc *= (double)this.angularVelocityRadians) * (double)MathHelper.func_76126_a((float)(angle += this.angularVelocityRadians / 3.0f));
                double offsetZ = arc * (double)MathHelper.func_76134_b((float)angle);
                if (this.field_76579_a.func_72945_a((Entity)p, p.field_70121_D).size() == 0) {
                    int collisions = 0;
                    do {
                        List list;
                        if ((collisions = (list = this.field_76579_a.func_72945_a((Entity)p, p.field_70121_D.func_72321_a(offsetX, 0.0, offsetZ))).size()) <= 0) continue;
                        if (!doGravity) {
                            p.field_70159_w += -offsetX;
                            p.field_70179_y += -offsetZ;
                        }
                        offsetX /= 2.0;
                        offsetZ /= 2.0;
                        if (offsetX < 0.01 && offsetX > -0.01) {
                            offsetX = 0.0;
                        }
                        if (offsetZ < 0.01 && offsetZ > -0.01) {
                            offsetZ = 0.0;
                        }
                        doGravity = true;
                    } while (collisions > 0);
                    p.field_70165_t += offsetX;
                    p.field_70161_v += offsetZ;
                    p.field_70121_D.func_72317_d(offsetX, 0.0, offsetZ);
                }
                p.field_70177_z += this.skyAngularVelocity;
                p.field_70126_B += this.skyAngularVelocity;
                while (p.field_70177_z > 360.0f) {
                    p.field_70177_z -= 360.0f;
                }
                while (p.field_70177_z < 0.0f) {
                    p.field_70177_z += 360.0f;
                }
                while (p.field_70126_B > 360.0f) {
                    p.field_70126_B -= 360.0f;
                }
                while (p.field_70126_B < 0.0f) {
                    p.field_70126_B += 360.0f;
                }
            }
            p.field_70159_w /= (double)0.91f;
            p.field_70179_y /= (double)0.91f;
            p.field_70181_x /= (double)0.98f;
            if (!p.field_71075_bZ.field_75098_d) {
                FreefallHandler.freefallMotion(p);
            } else {
                double dx = p.field_70159_w - this.pPrevMotionX;
                double dy = p.field_70181_x - this.pPrevMotionY;
                double dz = p.field_70179_y - this.pPrevMotionZ;
                p.field_70159_w -= dx / 2.0;
                p.field_70181_x -= dy / 2.0;
                p.field_70179_y -= dz / 2.0;
                if (p.field_70159_w > (double)1.2f) {
                    p.field_70159_w = 1.2f;
                }
                if (p.field_70159_w < (double)-1.2f) {
                    p.field_70159_w = -1.2f;
                }
                if (p.field_70181_x > (double)0.7f) {
                    p.field_70181_x = 0.7f;
                }
                if (p.field_70181_x < (double)-0.7f) {
                    p.field_70181_x = -0.7f;
                }
                if (p.field_70179_y > (double)1.2f) {
                    p.field_70179_y = 1.2f;
                }
                if (p.field_70179_y < (double)-1.2f) {
                    p.field_70179_y = -1.2f;
                }
            }
        } else {
            double dy = p.field_70181_x - this.pPrevMotionY;
            if (p.field_71158_b.field_78901_c) {
                if (p.field_70122_E || this.pWasOnGround) {
                    this.pjumpticks = 20;
                    p.field_70181_x -= 0.015;
                    p.field_70122_E = false;
                    p.field_70163_u -= 0.1;
                    p.field_70121_D.func_72317_d(0.0, -0.1, 0.0);
                } else {
                    p.field_70181_x += 0.015;
                    if (this.pjumpticks == 0) {
                        p.field_70181_x -= dy;
                    }
                }
            } else if (p.field_71158_b.field_78899_d) {
                if (!p.field_70122_E) {
                    p.field_70181_x -= 0.015;
                }
                this.pjumpticks = 0;
            }
            if (this.pjumpticks > 0) {
                --this.pjumpticks;
                p.field_70181_x -= dy;
                if (this.pjumpticks >= 17) {
                    p.field_70181_x += 0.03;
                }
            }
        }
        if (doGravity) {
            int quadrant = 0;
            double xd = p.field_70165_t - this.spinCentreX;
            double zd = p.field_70161_v - this.spinCentreZ;
            double accel = Math.sqrt(xd * xd + zd * zd) * (double)this.angularVelocityRadians * (double)this.angularVelocityRadians * 4.0;
            quadrant = xd < 0.0 ? (xd < -Math.abs(zd) ? 2 : (zd < 0.0 ? 3 : 1)) : (xd > Math.abs(zd) ? 0 : (zd < 0.0 ? 3 : 1));
            switch (quadrant) {
                case 0: {
                    p.field_70159_w += accel;
                    break;
                }
                case 1: {
                    p.field_70179_y += accel;
                    break;
                }
                case 2: {
                    p.field_70159_w -= accel;
                    break;
                }
                default: {
                    p.field_70179_y -= accel;
                }
            }
        }
        this.pPrevMotionX = p.field_70159_w;
        this.pPrevMotionY = p.field_70181_x;
        this.pPrevMotionZ = p.field_70179_y;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean testFreefall(EntityPlayerSP p, boolean flag) {
        if (this.pjumpticks > 0 || this.pWasOnGround && p.field_71158_b.field_78901_c) {
            return false;
        }
        if (!flag) {
            return false;
        }
        float rY = p.field_70177_z % 360.0f;
        double zreach = 0.0;
        double xreach = 0.0;
        if (rY < 80.0f || rY > 280.0f) {
            zreach = 0.2;
        }
        if (rY < 170.0f && rY > 10.0f) {
            xreach = 0.2;
        }
        if (rY < 260.0f && rY > 100.0f) {
            zreach = -0.2;
        }
        if (rY < 350.0f && rY > 190.0f) {
            xreach = -0.2;
        }
        AxisAlignedBB playerReach = p.field_70121_D.func_72321_a(xreach, 0.0, zreach);
        if (playerReach.field_72336_d >= (double)this.ssBoundsMinX && playerReach.field_72340_a <= (double)this.ssBoundsMaxX && playerReach.field_72337_e >= (double)this.ssBoundsMinY && playerReach.field_72338_b <= (double)this.ssBoundsMaxY && playerReach.field_72334_f >= (double)this.ssBoundsMinZ && playerReach.field_72339_c <= (double)this.ssBoundsMaxZ) {
            int xm = MathHelper.func_76128_c((double)playerReach.field_72340_a);
            int xx = MathHelper.func_76128_c((double)playerReach.field_72336_d);
            int ym = MathHelper.func_76128_c((double)playerReach.field_72338_b);
            int yy = MathHelper.func_76128_c((double)playerReach.field_72337_e);
            int zm = MathHelper.func_76128_c((double)playerReach.field_72339_c);
            int zz = MathHelper.func_76128_c((double)playerReach.field_72334_f);
            for (int x = xm; x <= xx; ++x) {
                for (int y = ym; y <= yy; ++y) {
                    for (int z = zm; z <= zz; ++z) {
                        Block b = this.field_76579_a.func_147439_a(x, y, z);
                        if (Blocks.field_150350_a == b || GCBlocks.brightAir == b) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public float getSpinRate() {
        return this.skyAngularVelocity;
    }

    public void setSpinRate(float angle) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.updateSkyProviderSpinRate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSkyProviderSpinRate() {
        IRenderHandler sky = this.getSkyRenderer();
        if (sky instanceof SkyProviderOrbit) {
            ((SkyProviderOrbit)sky).spinDeltaPerTick = this.skyAngularVelocity;
        }
    }

    public void setSpinRate(float angle, boolean firing) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        IRenderHandler sky = this.getSkyRenderer();
        if (sky instanceof SkyProviderOrbit) {
            ((SkyProviderOrbit)sky).spinDeltaPerTick = this.skyAngularVelocity;
        }
        this.thrustersFiring = firing;
    }

    public void setSpinCentre(double x, double z) {
        this.spinCentreX = x;
        this.spinCentreZ = z;
        if (this.field_76579_a.field_72995_K && ConfigManagerCore.enableDebug) {
            GCLog.info("Clientside update to spin centre: " + x + "," + z);
        }
    }

    public void setSpinBox(int mx, int xx, int my, int yy, int mz, int zz) {
        this.ssBoundsMinX = mx;
        this.ssBoundsMaxX = xx;
        this.ssBoundsMinY = my;
        this.ssBoundsMaxY = yy;
        this.ssBoundsMinZ = mz;
        this.ssBoundsMaxZ = zz;
    }

    public void addThruster(BlockVec3 thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.add(thruster);
            this.thrustersMinus.remove(thruster);
        } else {
            this.thrustersPlus.remove(thruster);
            this.thrustersMinus.add(thruster);
        }
    }

    public void removeThruster(BlockVec3 thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.remove(thruster);
        } else {
            this.thrustersMinus.remove(thruster);
        }
    }

    public boolean checkSS(BlockVec3 baseBlock, boolean placingThruster) {
        if (this.oneSSBlock == null || this.oneSSBlock.getBlockID(this.field_76579_a) instanceof BlockAir) {
            this.oneSSBlock = baseBlock != null ? baseBlock.clone() : new BlockVec3(0, 64, 0);
        }
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> foundThrusters = new LinkedList<BlockVec3>();
        this.checked.clear();
        currentLayer.add(this.oneSSBlock.clone());
        this.checked.add(this.oneSSBlock.clone());
        Block bStart = this.oneSSBlock.getBlockID(this.field_76579_a);
        if (bStart instanceof BlockSpinThruster) {
            foundThrusters.add(this.oneSSBlock);
        }
        float thismass = 0.1f;
        float thismassCentreX = 0.1f * (float)this.oneSSBlock.x;
        float thismassCentreY = 0.1f * (float)this.oneSSBlock.y;
        float thismassCentreZ = 0.1f * (float)this.oneSSBlock.z;
        float thismoment = 0.0f;
        int thisssBoundsMaxX = this.oneSSBlock.x;
        int thisssBoundsMinX = this.oneSSBlock.x;
        int thisssBoundsMaxY = this.oneSSBlock.y;
        int thisssBoundsMinY = this.oneSSBlock.y;
        int thisssBoundsMaxZ = this.oneSSBlock.z;
        int thisssBoundsMinZ = this.oneSSBlock.z;
        while (currentLayer.size() > 0) {
            for (BlockVec3 vec : currentLayer) {
                if (vec.x < thisssBoundsMinX) {
                    thisssBoundsMinX = vec.x;
                }
                if (vec.y < thisssBoundsMinY) {
                    thisssBoundsMinY = vec.y;
                }
                if (vec.z < thisssBoundsMinZ) {
                    thisssBoundsMinZ = vec.z;
                }
                if (vec.x > thisssBoundsMaxX) {
                    thisssBoundsMaxX = vec.x;
                }
                if (vec.y > thisssBoundsMaxY) {
                    thisssBoundsMaxY = vec.y;
                }
                if (vec.z > thisssBoundsMaxZ) {
                    thisssBoundsMaxZ = vec.z;
                }
                for (int side = 0; side < 6; ++side) {
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || this.checked.contains(sideVec = vec.newVecSide(side))) continue;
                    this.checked.add(sideVec);
                    Block b = sideVec.getBlockID(this.field_76579_a);
                    if (b instanceof BlockAir || b == null) continue;
                    nextLayer.add(sideVec);
                    if (bStart instanceof BlockAir) {
                        this.oneSSBlock = sideVec.clone();
                        bStart = b;
                    }
                    float m = 1.0f;
                    if (!(b instanceof BlockLiquid)) {
                        m = b.func_149712_f(this.field_76579_a, sideVec.x, sideVec.y, sideVec.z);
                        if (m < 0.1f) {
                            m = 0.1f;
                        } else if (m > 30.0f) {
                            m = 30.0f;
                        }
                        if (b.func_149688_o() == Material.field_151575_d) {
                            m /= 4.0f;
                        }
                    }
                    thismassCentreX += m * (float)sideVec.x;
                    thismassCentreY += m * (float)sideVec.y;
                    thismassCentreZ += m * (float)sideVec.z;
                    thismass += m;
                    thismoment += m * (float)(sideVec.x * sideVec.x + sideVec.z * sideVec.z);
                    if (!(b instanceof BlockSpinThruster)) continue;
                    foundThrusters.add(sideVec);
                }
            }
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
        if (placingThruster && !this.checked.contains(baseBlock)) {
            if (foundThrusters.size() > 0) {
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Thruster placed on wrong part of space station: base at " + this.oneSSBlock.x + "," + this.oneSSBlock.y + "," + this.oneSSBlock.z + " - baseBlock was " + baseBlock.x + "," + baseBlock.y + "," + baseBlock.z + " - found " + foundThrusters.size());
                }
                return false;
            }
            if (!this.oneSSBlock.equals(baseBlock)) {
                this.oneSSBlock = baseBlock.clone();
                if (this.oneSSBlock.getBlockID(this.field_76579_a).func_149688_o() != Material.field_151579_a) {
                    return this.checkSS(baseBlock, true);
                }
            }
            return false;
        }
        this.thrustersPlus.clear();
        this.thrustersMinus.clear();
        for (BlockVec3 thruster : foundThrusters) {
            int facing = thruster.getBlockMetadata((IBlockAccess)this.field_76579_a) & 8;
            if (facing == 0) {
                this.thrustersPlus.add(thruster.clone());
                continue;
            }
            this.thrustersMinus.add(thruster.clone());
        }
        float mass = thismass;
        this.massCentreX = thismassCentreX / thismass + 0.5f;
        float massCentreY = thismassCentreY / thismass + 0.5f;
        this.massCentreZ = thismassCentreZ / thismass + 0.5f;
        this.setSpinCentre(this.massCentreX, this.massCentreZ);
        this.ssBoundsMaxX = thisssBoundsMaxX + 1;
        this.ssBoundsMinX = thisssBoundsMinX;
        this.ssBoundsMaxY = thisssBoundsMaxY + 1;
        this.ssBoundsMinY = thisssBoundsMinY;
        this.ssBoundsMaxZ = thisssBoundsMaxZ + 1;
        this.ssBoundsMinZ = thisssBoundsMinZ;
        thismoment -= this.massCentreX * this.massCentreX * mass;
        this.momentOfInertia = thismoment -= this.massCentreZ * this.massCentreZ * mass;
        if (ConfigManagerCore.enableDebug) {
            System.out.println("MoI = " + this.momentOfInertia + " CoMx = " + this.massCentreX + " CoMz = " + this.massCentreZ);
        }
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), this.spaceStationDimensionID);
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), this.spaceStationDimensionID);
        this.updateSpinSpeed();
        return true;
    }

    public void updateSpinSpeed() {
        if (this.momentOfInertia > 0.0f) {
            float zz;
            float xx;
            float netTorque = 0.0f;
            int countThrusters = 0;
            int countThrustersReverse = 0;
            for (BlockVec3 thruster : this.thrustersPlus) {
                xx = (float)thruster.x - this.massCentreX;
                zz = (float)thruster.z - this.massCentreZ;
                netTorque += MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrusters;
            }
            for (BlockVec3 thruster : this.thrustersMinus) {
                xx = (float)thruster.x - this.massCentreX;
                zz = (float)thruster.z - this.massCentreZ;
                netTorque -= MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrustersReverse;
            }
            if (countThrusters == countThrustersReverse) {
                this.angularVelocityAccel = 4.0E-6f;
                this.angularVelocityTarget = 0.0f;
            } else {
                if ((countThrusters += countThrustersReverse) > 4) {
                    countThrusters = 4;
                }
                float maxRx = Math.max((float)this.ssBoundsMaxX - this.massCentreX, this.massCentreX - (float)this.ssBoundsMinX);
                float maxRz = Math.max((float)this.ssBoundsMaxZ - this.massCentreZ, this.massCentreZ - (float)this.ssBoundsMinZ);
                float maxR = Math.max(maxRx, maxRz);
                this.angularVelocityTarget = MathHelper.func_76129_c((float)(0.024525002f / maxR)) / 2.0f;
                float spinCap = 0.00125f * (float)countThrusters;
                this.angularVelocityAccel = netTorque / this.momentOfInertia / 20.0f;
                if (this.angularVelocityAccel < 0.0f) {
                    this.angularVelocityAccel = -this.angularVelocityAccel;
                    this.angularVelocityTarget = -this.angularVelocityTarget;
                    if (this.angularVelocityTarget < -spinCap) {
                        this.angularVelocityTarget = -spinCap;
                    }
                } else if (this.angularVelocityTarget > spinCap) {
                    this.angularVelocityTarget = spinCap;
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("MaxR = " + maxR + " Angular vel = " + this.angularVelocityTarget + " Angular accel = " + this.angularVelocityAccel);
                }
            }
        }
        if (!this.field_76579_a.field_72995_K) {
            if (this.savefile == null) {
                this.savefile = OrbitSpinSaveData.initWorldData(this.field_76579_a);
                this.dataNotLoaded = false;
            } else {
                this.writeToNBT(this.savefile.datacompound);
                this.savefile.func_76185_a();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.doSpinning = true;
        this.angularVelocityRadians = nbt.func_74760_g("omegaRad");
        this.skyAngularVelocity = nbt.func_74760_g("omegaSky");
        this.angularVelocityTarget = nbt.func_74760_g("omegaTarget");
        this.angularVelocityAccel = nbt.func_74760_g("omegaAcc");
        NBTTagCompound oneBlock = (NBTTagCompound)nbt.func_74781_a("oneBlock");
        this.oneSSBlock = oneBlock != null ? BlockVec3.readFromNBT(oneBlock) : null;
        this.checkSS(this.oneSSBlock, false);
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(this.thrustersFiring);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), this.spaceStationDimensionID);
        objList = new ArrayList();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), this.spaceStationDimensionID);
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), this.spaceStationDimensionID);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("doSpinning", this.doSpinning);
        nbt.func_74776_a("omegaRad", this.angularVelocityRadians);
        nbt.func_74776_a("omegaSky", this.skyAngularVelocity);
        nbt.func_74776_a("omegaTarget", this.angularVelocityTarget);
        nbt.func_74776_a("omegaAcc", this.angularVelocityAccel);
        if (this.oneSSBlock != null) {
            NBTTagCompound oneBlock = new NBTTagCompound();
            this.oneSSBlock.writeToNBT(oneBlock);
            nbt.func_74782_a("oneBlock", (NBTBase)oneBlock);
        }
    }

    public void sendPacketsToClient(EntityPlayerMP player) {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(this.thrustersFiring);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, objList), player);
        objList = new ArrayList();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, objList), player);
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, objList), player);
    }

    @Override
    public float getThermalLevelModifier() {
        return 0.0f;
    }

    @Override
    public float getWindLevel() {
        return 0.1f;
    }
}

