/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GameScreenBasic
implements IGameScreen {
    private TextureManager renderEngine;
    private float frameA;
    private float frameBx;
    private float frameBy;
    private float textureAx = 0.0f;
    private float textureAy = 0.0f;
    private float textureBx = 1.0f;
    private float textureBy = 1.0f;

    public GameScreenBasic() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
        }
    }

    @Override
    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    @Override
    public void render(int type, float ticks, float scaleX, float scaleY, IScreenManager scr) {
        this.frameBx = scaleX - this.frameA;
        this.frameBy = scaleY - this.frameA;
        if (scaleX == scaleY) {
            this.textureAx = 0.0f;
            this.textureAy = 0.0f;
            this.textureBx = 1.0f;
            this.textureBy = 1.0f;
        } else if (scaleX < scaleY) {
            this.textureAx = (1.0f - scaleX / scaleY) / 2.0f;
            this.textureAy = 0.0f;
            this.textureBx = 1.0f - this.textureAx;
            this.textureBy = 1.0f;
        } else if (scaleY < scaleX) {
            this.textureAx = 0.0f;
            this.textureAy = (1.0f - scaleY / scaleX) / 2.0f;
            this.textureBx = 1.0f;
            this.textureBy = 1.0f - this.textureAy;
        }
        switch (type) {
            case 0: {
                this.drawBlackBackground(0.09f);
                break;
            }
            case 1: {
                if (ClientProxyCore.overworldTextureLocal != null) {
                    GL11.glBindTexture((int)3553, (int)ClientProxyCore.overworldTextureLocal.func_110552_b());
                } else {
                    this.renderEngine.func_110577_a(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png"));
                    if (!ClientProxyCore.overworldTextureRequestSent) {
                        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, new Object[0]));
                        ClientProxyCore.overworldTextureRequestSent = true;
                    }
                }
                this.draw2DTexture();
            }
        }
    }

    private void draw2DTexture() {
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.func_78370_a(255, 255, 255, 255);
        tess.func_78382_b();
        tess.func_78374_a((double)this.frameA, (double)this.frameBy, 0.0, (double)this.textureAx, (double)this.textureBy);
        tess.func_78374_a((double)this.frameBx, (double)this.frameBy, 0.0, (double)this.textureBx, (double)this.textureBy);
        tess.func_78374_a((double)this.frameBx, (double)this.frameA, 0.0, (double)this.textureBx, (double)this.textureAy);
        tess.func_78374_a((double)this.frameA, (double)this.frameA, 0.0, (double)this.textureAx, (double)this.textureAy);
        tess.func_78381_a();
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        tess.func_78382_b();
        tess.func_78377_a((double)this.frameA, (double)this.frameBy, (double)0.005f);
        tess.func_78377_a((double)this.frameBx, (double)this.frameBy, (double)0.005f);
        tess.func_78377_a((double)this.frameBx, (double)this.frameA, (double)0.005f);
        tess.func_78377_a((double)this.frameA, (double)this.frameA, (double)0.005f);
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }
}

