/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStage;
import info.ata4.minecraft.dragon.server.entity.helper.DragonScaleModifier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonLifeStageHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    private DragonLifeStage lifeStagePrev;
    private DragonScaleModifier scaleModifier = new DragonScaleModifier();
    private int eggWiggleX;
    private int eggWiggleZ;

    public DragonLifeStageHelper(EntityTameableDragon dragon) {
        super(dragon);
    }

    @Override
    public void applyEntityAttributes() {
        this.scaleModifier.setScale(this.getScale());
        this.dragon.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a((AttributeModifier)this.scaleModifier);
        this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a((AttributeModifier)this.scaleModifier);
    }

    public void playEggCrackEffect() {
        int bx = (int)Math.round(this.dragon.field_70165_t - 0.5);
        int by = (int)Math.round(this.dragon.field_70163_u);
        int bz = (int)Math.round(this.dragon.field_70161_v - 0.5);
        this.dragon.field_70170_p.func_72926_e(2001, bx, by, bz, Block.func_149682_b((Block)Blocks.field_150380_bt));
    }

    public int getEggWiggleX() {
        return this.eggWiggleX;
    }

    public int getEggWiggleZ() {
        return this.eggWiggleZ;
    }

    public DragonLifeStage getLifeStage() {
        int age = this.dragon.func_70874_b();
        if (age >= DragonLifeStage.ADULT.ageLimit) {
            return DragonLifeStage.ADULT;
        }
        if (age >= DragonLifeStage.JUVENILE.ageLimit) {
            return DragonLifeStage.JUVENILE;
        }
        if (age >= DragonLifeStage.HATCHLING.ageLimit) {
            return DragonLifeStage.HATCHLING;
        }
        return DragonLifeStage.EGG;
    }

    public float getScale() {
        if (this.isEgg()) {
            return 0.225f;
        }
        return 1.0f - (float)this.dragon.func_70874_b() / (float)DragonLifeStage.EGG.ageLimit;
    }

    public void transformToEgg() {
        if (this.dragon.func_110143_aJ() <= 0.0f) {
            return;
        }
        L.debug("transforming to egg");
        float volume = 1.0f;
        float pitch = 0.5f + (0.5f - this.rand.nextFloat()) * 0.1f;
        this.dragon.field_70170_p.func_72956_a((Entity)this.dragon, "mob.endermen.portal", volume, pitch);
        if (this.dragon.isSaddled()) {
            this.dragon.func_145779_a(Items.field_151141_av, 1);
        }
        this.dragon.func_70099_a(new ItemStack(Blocks.field_150380_bt), 0.0f);
        this.dragon.func_70106_y();
    }

    public final void setLifeStage(DragonLifeStage lifeStage) {
        L.trace("setLifeStage({})", new Object[]{lifeStage});
        this.dragon.func_70873_a(lifeStage.ageLimit);
        this.updateLifeStage();
    }

    private void onNewLifeStage(DragonLifeStage lifeStage, DragonLifeStage prevLifeStage) {
        L.trace("onNewLifeStage({},{})", new Object[]{prevLifeStage, lifeStage});
        if (this.dragon.isClient()) {
            if (prevLifeStage != null && prevLifeStage == DragonLifeStage.EGG && lifeStage == DragonLifeStage.HATCHLING) {
                this.playEggCrackEffect();
            }
        } else {
            this.dragon.setCanFly(lifeStage != DragonLifeStage.EGG && lifeStage != DragonLifeStage.HATCHLING);
            this.dragon.func_70661_as().func_75490_c(lifeStage == DragonLifeStage.HATCHLING);
            if (lifeStage == DragonLifeStage.EGG) {
                this.dragon.func_70778_a(null);
                this.dragon.func_70624_b(null);
            }
            IAttributeInstance healthAttrib = this.dragon.func_110148_a(SharedMonsterAttributes.field_111267_a);
            IAttributeInstance damageAttrib = this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e);
            healthAttrib.func_111124_b((AttributeModifier)this.scaleModifier);
            damageAttrib.func_111124_b((AttributeModifier)this.scaleModifier);
            this.scaleModifier.setScale(this.getScale());
            healthAttrib.func_111121_a((AttributeModifier)this.scaleModifier);
            damageAttrib.func_111121_a((AttributeModifier)this.scaleModifier);
            this.dragon.func_70606_j(this.dragon.func_110138_aP());
        }
    }

    @Override
    public void onLivingUpdate() {
        this.updateLifeStage();
        this.updateEgg();
        this.updateScale();
    }

    private void updateLifeStage() {
        DragonLifeStage lifeStage = this.getLifeStage();
        if (this.lifeStagePrev != lifeStage) {
            this.onNewLifeStage(lifeStage, this.lifeStagePrev);
            this.lifeStagePrev = lifeStage;
        }
    }

    private void updateEgg() {
        int hatchAge;
        int eggAge;
        if (!this.isEgg()) {
            return;
        }
        int age = this.dragon.func_70874_b();
        float chance = (float)(age - (eggAge = DragonLifeStage.EGG.ageLimit)) / (float)((hatchAge = DragonLifeStage.HATCHLING.ageLimit) - eggAge);
        if (chance > 0.66f) {
            chance /= 60.0f;
            if (this.eggWiggleX > 0) {
                --this.eggWiggleX;
            } else if (this.rand.nextFloat() < chance) {
                this.eggWiggleX = this.rand.nextBoolean() ? 10 : 20;
                this.playEggCrackEffect();
            }
            if (this.eggWiggleZ > 0) {
                --this.eggWiggleZ;
            } else if (this.rand.nextFloat() < chance) {
                this.eggWiggleZ = this.rand.nextBoolean() ? 10 : 20;
                this.playEggCrackEffect();
            }
        }
        double px = this.dragon.field_70165_t + (this.rand.nextDouble() - 0.5);
        double py = this.dragon.field_70163_u + (this.rand.nextDouble() - 0.5);
        double pz = this.dragon.field_70161_v + (this.rand.nextDouble() - 0.5);
        double ox = (this.rand.nextDouble() - 0.5) * 2.0;
        double oy = (this.rand.nextDouble() - 0.5) * 2.0;
        double oz = (this.rand.nextDouble() - 0.5) * 2.0;
        this.dragon.field_70170_p.func_72869_a("portal", px, py, pz, ox, oy, oz);
    }

    private void updateScale() {
        this.dragon.setScalePublic(this.getScale());
    }

    @Override
    public void onDeath() {
        if (this.dragon.isClient() && this.isEgg()) {
            this.playEggCrackEffect();
        }
    }

    public boolean isEgg() {
        return this.getLifeStage() == DragonLifeStage.EGG;
    }

    public boolean isHatchling() {
        return this.getLifeStage() == DragonLifeStage.HATCHLING;
    }

    public boolean isJuvenile() {
        return this.getLifeStage() == DragonLifeStage.JUVENILE;
    }

    public boolean isAdult() {
        return this.getLifeStage() == DragonLifeStage.ADULT;
    }
}

