/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import openmods.integration.IIntegrationModule;
import openperipheral.api.ApiAccess;
import openperipheral.api.adapter.IPeripheralAdapterRegistry;
import openperipheral.api.converter.IConverterManager;
import openperipheral.api.meta.IEntityMetaBuilder;
import openperipheral.api.meta.IItemStackMetaBuilder;
import openperipheral.integration.vanilla.AdapterBeacon;
import openperipheral.integration.vanilla.AdapterBrewingStand;
import openperipheral.integration.vanilla.AdapterComparator;
import openperipheral.integration.vanilla.AdapterDaylightSensor;
import openperipheral.integration.vanilla.AdapterFluidHandler;
import openperipheral.integration.vanilla.AdapterFluidTank;
import openperipheral.integration.vanilla.AdapterFurnace;
import openperipheral.integration.vanilla.AdapterInventory;
import openperipheral.integration.vanilla.AdapterMobSpawner;
import openperipheral.integration.vanilla.AdapterNoteBlock;
import openperipheral.integration.vanilla.AdapterRecordPlayer;
import openperipheral.integration.vanilla.AdapterSign;
import openperipheral.integration.vanilla.AdapterWorldInventory;
import openperipheral.integration.vanilla.BurnTimeMetaProvider;
import openperipheral.integration.vanilla.ConverterItemFingerprint;
import openperipheral.integration.vanilla.EnchantedBookMetaProvider;
import openperipheral.integration.vanilla.EnchantmentMetaProvider;
import openperipheral.integration.vanilla.EntityBatMetaProvider;
import openperipheral.integration.vanilla.EntityCreeperMetaProvider;
import openperipheral.integration.vanilla.EntityHorseMetaProvider;
import openperipheral.integration.vanilla.EntityItemMetaProvider;
import openperipheral.integration.vanilla.EntityLivingMetaProvider;
import openperipheral.integration.vanilla.EntityPigMetaProvider;
import openperipheral.integration.vanilla.EntityPlayerMetaProvider;
import openperipheral.integration.vanilla.EntitySheepMetaProvider;
import openperipheral.integration.vanilla.EntityTameableMetaProvider;
import openperipheral.integration.vanilla.EntityVillagerMetaProvider;
import openperipheral.integration.vanilla.EntityWitchMetaProvider;
import openperipheral.integration.vanilla.EntityWolfMetaProvider;
import openperipheral.integration.vanilla.EntityZombieMetaProvider;
import openperipheral.integration.vanilla.FingerprintMetaProvider;
import openperipheral.integration.vanilla.FluidContainerMetaProvider;
import openperipheral.integration.vanilla.InventoryProviderMetaProvider;
import openperipheral.integration.vanilla.ItemArmorMetaProvider;
import openperipheral.integration.vanilla.ItemFrameMetaProvider;
import openperipheral.integration.vanilla.ItemSwordMetaProvider;
import openperipheral.integration.vanilla.ItemToolClassMetaProvider;
import openperipheral.integration.vanilla.ItemToolMetaProvider;
import openperipheral.integration.vanilla.OreDictMetaProvider;
import openperipheral.integration.vanilla.PaintingMetaProvider;

public class ModuleVanilla
implements IIntegrationModule {
    public static String DUMMY_VANILLA_MODID = "vanilla";

    public String name() {
        return "Vanilla CC integration module";
    }

    public boolean canLoad() {
        return true;
    }

    public void load() {
        IPeripheralAdapterRegistry adapterRegistry = ApiAccess.getApi(IPeripheralAdapterRegistry.class);
        adapterRegistry.register(new AdapterInventory());
        adapterRegistry.register(new AdapterWorldInventory());
        adapterRegistry.register(new AdapterNoteBlock());
        adapterRegistry.register(new AdapterComparator());
        adapterRegistry.register(new AdapterBeacon());
        adapterRegistry.register(new AdapterBrewingStand());
        adapterRegistry.register(new AdapterFluidHandler());
        adapterRegistry.register(new AdapterFluidTank());
        adapterRegistry.register(new AdapterFurnace());
        adapterRegistry.register(new AdapterMobSpawner());
        adapterRegistry.register(new AdapterRecordPlayer());
        adapterRegistry.register(new AdapterSign());
        adapterRegistry.register(new AdapterDaylightSensor());
        IItemStackMetaBuilder itemMeta = ApiAccess.getApi(IItemStackMetaBuilder.class);
        itemMeta.register(new EnchantedBookMetaProvider());
        itemMeta.register(new EnchantmentMetaProvider());
        itemMeta.register(new FluidContainerMetaProvider());
        itemMeta.register(new BurnTimeMetaProvider());
        itemMeta.register(new OreDictMetaProvider());
        itemMeta.register(new FingerprintMetaProvider());
        itemMeta.register(new ItemToolClassMetaProvider());
        itemMeta.register(new ItemToolMetaProvider());
        itemMeta.register(new ItemArmorMetaProvider());
        itemMeta.register(new ItemSwordMetaProvider());
        IEntityMetaBuilder entityMeta = ApiAccess.getApi(IEntityMetaBuilder.class);
        entityMeta.register(new EntityItemMetaProvider());
        entityMeta.register(new PaintingMetaProvider());
        entityMeta.register(new ItemFrameMetaProvider());
        entityMeta.register(new EntityBatMetaProvider());
        entityMeta.register(new EntityCreeperMetaProvider());
        entityMeta.register(new EntityHorseMetaProvider());
        entityMeta.register(new EntityLivingMetaProvider());
        entityMeta.register(new EntityPigMetaProvider());
        entityMeta.register(new EntityPlayerMetaProvider());
        entityMeta.register(new EntitySheepMetaProvider());
        entityMeta.register(new EntityTameableMetaProvider());
        entityMeta.register(new EntityVillagerMetaProvider());
        entityMeta.register(new EntityWitchMetaProvider());
        entityMeta.register(new EntityWolfMetaProvider());
        entityMeta.register(new EntityZombieMetaProvider());
        entityMeta.register(new InventoryProviderMetaProvider());
        IConverterManager converters = ApiAccess.getApi(IConverterManager.class);
        converters.register(new ConverterItemFingerprint());
    }

    public static Object listEnchantments(NBTTagList ench) {
        ArrayList response = Lists.newArrayList();
        for (int i = 0; i < ench.func_74745_c(); ++i) {
            NBTTagCompound enchTag = ench.func_150305_b(i);
            short id = enchTag.func_74765_d("id");
            short lvl = enchTag.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.field_77331_b[id];
            if (enchantment == null) continue;
            HashMap entry = Maps.newHashMap();
            entry.put("name", enchantment.func_77320_a());
            entry.put("level", lvl);
            entry.put("fullName", enchantment.func_77316_c((int)lvl));
            response.add(entry);
        }
        return response;
    }
}

