/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.api.meta.IItemStackCustomMetaProvider;

public class ItemToolClassMetaProvider
implements IItemStackCustomMetaProvider<Item> {
    @Override
    public Class<? extends Item> getTargetClass() {
        return Item.class;
    }

    @Override
    public String getKey() {
        return "tool_class";
    }

    @Override
    public boolean canApply(Item target, ItemStack stack) {
        return !target.getToolClasses(stack).isEmpty();
    }

    @Override
    public Object getMeta(Item target, ItemStack stack) {
        HashMap result = Maps.newHashMap();
        for (String tool : target.getToolClasses(stack)) {
            result.put(tool, target.getHarvestLevel(stack, tool));
        }
        return result;
    }
}

