/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.google.common.collect.Maps;
import com.xcompwiz.mystcraft.api.hook.PageAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.api.meta.IItemStackCustomMetaProvider;
import openperipheral.integration.mystcraft.v2.MystcraftAccess;

public class PageMetaProvider
implements IItemStackCustomMetaProvider<Item> {
    @Override
    public Class<? extends Item> getTargetClass() {
        return Item.class;
    }

    @Override
    public boolean canApply(Item target, ItemStack stack) {
        PageAPI pageApi = MystcraftAccess.pageApi;
        return pageApi != null && pageApi.getPageSymbol(stack) != null;
    }

    @Override
    public String getKey() {
        return "symbol";
    }

    @Override
    public Object getMeta(Item target, ItemStack stack) {
        IAgeSymbol symbol;
        if (MystcraftAccess.pageApi == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        String id = MystcraftAccess.pageApi.getPageSymbol(stack);
        if (id == null) {
            return null;
        }
        result.put("id", id);
        if (MystcraftAccess.symbolApi != null && (symbol = MystcraftAccess.symbolApi.getSymbol(id)) != null) {
            result.put("name", symbol.displayName());
            result.put("poem", symbol.getPoem());
        }
        return result;
    }
}

