/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.appeng;

import appeng.api.networking.IGridHost;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import openperipheral.api.ApiAccess;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.Env;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.converter.IConverter;
import openperipheral.api.meta.IItemStackPartialMetaBuilder;
import openperipheral.integration.appeng.AdapterGridBase;
import openperipheral.integration.vanilla.ItemFingerprint;

public class AdapterNetwork
extends AdapterGridBase {
    @Override
    public Class<?> getTargetClass() {
        return IGridHost.class;
    }

    @Override
    public String getSourceId() {
        return "me_network";
    }

    @ScriptCallable(description="Get a list of the stored and craftable items in the network.", returnTypes={ReturnType.TABLE})
    public List<?> getAvailableItems(IGridHost host, @Env(value="converter") IConverter converter, @Optionals @Arg(name="full", description="Whether to provide full item information") Boolean full) {
        IStorageGrid storageGrid = this.getStorageGrid(host);
        IItemList storageList = storageGrid.getItemInventory().getStorageList();
        IItemStackPartialMetaBuilder builder = ApiAccess.getApi(IItemStackPartialMetaBuilder.class);
        ArrayList result = Lists.newArrayList();
        for (IAEItemStack stack : storageList) {
            Map map = (Map)converter.fromJava(stack);
            if (full == Boolean.TRUE) {
                map.put("item", builder.createProxy(stack.getItemStack()));
            }
            result.add(map);
        }
        return result;
    }

    @ScriptCallable(description="Retrieves details about the specified item from the ME Network.", returnTypes={ReturnType.OBJECT})
    public Object getItemDetail(IGridHost host, @Arg(name="item", description="Details of the item you are looking for: { id, [ dmg, [nbt_hash]] }", type=ArgType.TABLE) ItemFingerprint needle, @Optionals @Arg(name="proxy", description="If false, method will compute whole table, instead of returning proxy") Boolean proxy) {
        IItemList items = this.getStorageGrid(host).getItemInventory().getStorageList();
        IAEItemStack stack = AdapterNetwork.findStack((IItemList<IAEItemStack>)items, needle);
        if (stack == null) {
            return null;
        }
        ItemStack vanillaStack = stack.getItemStack();
        return proxy != Boolean.FALSE ? ApiAccess.getApi(IItemStackPartialMetaBuilder.class).createProxy(vanillaStack) : vanillaStack;
    }

    @ScriptCallable(description="Get the average power injection into the network", returnTypes={ReturnType.NUMBER})
    public double getAvgPowerInjection(IGridHost host) {
        return this.getEnergyGrid(host).getAvgPowerInjection();
    }

    @ScriptCallable(description="Get the average power usage of the network.", returnTypes={ReturnType.NUMBER})
    public double getAvgPowerUsage(IGridHost host) {
        return this.getEnergyGrid(host).getAvgPowerUsage();
    }

    @ScriptCallable(description="Get the idle power usage of the network.", returnTypes={ReturnType.NUMBER})
    public double getIdlePowerUsage(IGridHost host) {
        return this.getEnergyGrid(host).getIdlePowerUsage();
    }

    @ScriptCallable(description="Get the maximum stored power in the network.", returnTypes={ReturnType.NUMBER})
    public double getMaxStoredPower(IGridHost host) {
        return this.getEnergyGrid(host).getMaxStoredPower();
    }

    @ScriptCallable(description="Get the stored power in the network.", returnTypes={ReturnType.NUMBER})
    public double getStoredPower(IGridHost host) {
        return this.getEnergyGrid(host).getStoredPower();
    }

    @ScriptCallable(description="Get a list of tables representing the available CPUs in the network.", returnTypes={ReturnType.TABLE})
    public List<Map<String, Object>> getCraftingCPUs(IGridHost host) {
        ICraftingGrid craftingGrid = this.getCraftingGrid(host);
        ArrayList cpus = Lists.newArrayList();
        for (ICraftingCPU cpu : craftingGrid.getCpus()) {
            HashMap cpuDetails = Maps.newHashMap();
            cpuDetails.put("name", cpu.getName());
            cpuDetails.put("storage", cpu.getAvailableStorage());
            cpuDetails.put("coprocessors", cpu.getCoProcessors());
            cpuDetails.put("busy", cpu.isBusy());
            cpus.add(cpuDetails);
        }
        return cpus;
    }
}

