/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.sensors;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openmods.utils.WorldUtils;
import openperipheral.addons.sensors.ISensorEnvironment;
import openperipheral.api.ApiAccess;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.meta.IEntityPartialMetaBuilder;
import openperipheral.api.meta.IMetaProviderProxy;

public class AdapterSensor
implements IPeripheralAdapter {
    private static final String DONT_EVER_CHANGE_THIS_TEXT_OTHERWISE_YOU_WILL_RUIN_EVERYTHING = "Entity not found";

    @Override
    public Class<?> getTargetClass() {
        return ISensorEnvironment.class;
    }

    @Override
    public String getSourceId() {
        return "openperipheral_sensor";
    }

    private static AxisAlignedBB getBoundingBox(Vec3 location, double range) {
        return AxisAlignedBB.func_72330_a((double)location.field_72450_a, (double)location.field_72448_b, (double)location.field_72449_c, (double)(location.field_72450_a + 1.0), (double)(location.field_72448_b + 1.0), (double)(location.field_72449_c + 1.0)).func_72314_b(range, range, range);
    }

    private static AxisAlignedBB getBoundingBox(ISensorEnvironment env) {
        return AdapterSensor.getBoundingBox(env.getLocation(), env.getSensorRange());
    }

    private static List<Integer> listEntityIds(ISensorEnvironment env, Class<? extends Entity> entityClass) {
        ArrayList ids = Lists.newArrayList();
        AxisAlignedBB aabb = AdapterSensor.getBoundingBox(env);
        for (Entity entity : WorldUtils.getEntitiesWithinAABB((World)env.getWorld(), entityClass, (AxisAlignedBB)aabb)) {
            ids.add(entity.func_145782_y());
        }
        return ids;
    }

    private static IMetaProviderProxy getEntityInfoById(ISensorEnvironment sensor, int mobId, Class<? extends Entity> cls) {
        Entity mob = sensor.getWorld().func_73045_a(mobId);
        Preconditions.checkArgument((boolean)cls.isInstance(mob), (Object)DONT_EVER_CHANGE_THIS_TEXT_OTHERWISE_YOU_WILL_RUIN_EVERYTHING);
        return AdapterSensor.getEntityInfo(sensor, mob);
    }

    private static IMetaProviderProxy getPlayerInfo(ISensorEnvironment sensor, String username) {
        EntityPlayer player = sensor.getWorld().func_72924_a(username);
        return AdapterSensor.getEntityInfo(sensor, (Entity)player);
    }

    private static IMetaProviderProxy getPlayerInfo(ISensorEnvironment sensor, UUID uuid) {
        EntityPlayer player = sensor.getWorld().func_152378_a(uuid);
        return AdapterSensor.getEntityInfo(sensor, (Entity)player);
    }

    private static IMetaProviderProxy getEntityInfo(ISensorEnvironment sensor, Entity mob) {
        Preconditions.checkNotNull((Object)mob, (Object)DONT_EVER_CHANGE_THIS_TEXT_OTHERWISE_YOU_WILL_RUIN_EVERYTHING);
        AxisAlignedBB aabb = AdapterSensor.getBoundingBox(sensor);
        Preconditions.checkArgument((boolean)mob.field_70121_D.func_72326_a(aabb), (Object)DONT_EVER_CHANGE_THIS_TEXT_OTHERWISE_YOU_WILL_RUIN_EVERYTHING);
        Vec3 sensorPos = sensor.getLocation();
        return ApiAccess.getApi(IEntityPartialMetaBuilder.class).createProxy(mob, sensorPos);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the ids of all the mobs in range. Deprecated, please use getEntityIds('mob')")
    public List<Integer> getMobIds(ISensorEnvironment env) {
        return AdapterSensor.listEntityIds(env, EntityLiving.class);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get full details of a particular mob if it's in range. Deprecated, please use getEntityData(id, 'mob')")
    public IMetaProviderProxy getMobData(ISensorEnvironment sensor, @Arg(name="mobId", description="The id retrieved from getMobIds()") int id) {
        return AdapterSensor.getEntityInfoById(sensor, id, EntityLiving.class);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the ids of all the minecarts in range. Deprecated, please use getEntityIds('minecart')")
    public List<Integer> getMinecartIds(ISensorEnvironment env) {
        return AdapterSensor.listEntityIds(env, EntityMinecart.class);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get full details of a particular minecart if it's in range. Deprecated, please use getEntityIds(id, 'minecraft')")
    public IMetaProviderProxy getMinecartData(ISensorEnvironment sensor, @Arg(name="minecartId", description="The id retrieved from getMinecartIds()") int id) {
        return AdapterSensor.getEntityInfoById(sensor, id, EntityMinecart.class);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the ids of all entities of single type in range")
    public List<Integer> getEntityIds(ISensorEnvironment env, @Arg(name="type") SupportedEntityTypes type) {
        return AdapterSensor.listEntityIds(env, type.cls);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get full details of a particular entity if it's in range")
    public IMetaProviderProxy getEntityData(ISensorEnvironment sensor, @Arg(name="id", description="The id retrieved from getEntityIds()") int id, @Arg(name="type") SupportedEntityTypes type) {
        return AdapterSensor.getEntityInfoById(sensor, id, type.cls);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the usernames of all the players in range")
    public List<GameProfile> getPlayers(ISensorEnvironment env) {
        List players = WorldUtils.getEntitiesWithinAABB((World)env.getWorld(), EntityPlayer.class, (AxisAlignedBB)AdapterSensor.getBoundingBox(env));
        ArrayList names = Lists.newArrayList();
        for (EntityPlayer player : players) {
            names.add(player.func_146103_bH());
        }
        return names;
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get full details of a particular player if they're in range")
    public IMetaProviderProxy getPlayerByName(ISensorEnvironment env, @Arg(name="username", description="The players username") String username) {
        return AdapterSensor.getPlayerInfo(env, username);
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get full details of a particular player if they're in range")
    public IMetaProviderProxy getPlayerByUUID(ISensorEnvironment env, @Arg(name="uuid", description="The players uuid") UUID uuid) {
        return AdapterSensor.getPlayerInfo(env, uuid);
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get a table of information about the surrounding area. Includes whether each block is UNKNOWN, AIR, LIQUID or SOLID")
    public Map<Integer, Map<String, Object>> sonicScan(ISensorEnvironment env) {
        int range = 1 + env.getSensorRange() / 2;
        World world = env.getWorld();
        HashMap results = Maps.newHashMap();
        Vec3 sensorPos = env.getLocation();
        int sx = MathHelper.func_76128_c((double)sensorPos.field_72450_a);
        int sy = MathHelper.func_76128_c((double)sensorPos.field_72448_b);
        int sz = MathHelper.func_76128_c((double)sensorPos.field_72449_c);
        int rangeSq = range * range;
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    int distSq;
                    int bx = sx + x;
                    int by = sy + y;
                    int bz = sz + z;
                    if (!world.func_72899_e(bx, by, bz) || (distSq = x * x + y * y + z * z) == 0 || distSq > rangeSq) continue;
                    Block block = world.func_147439_a(bx, by, bz);
                    String type = block == null || world.func_147437_c(bx, by, bz) ? "AIR" : (block.func_149688_o().func_76224_d() ? "LIQUID" : (block.func_149688_o().func_76220_a() ? "SOLID" : "UNKNOWN"));
                    HashMap tmp = Maps.newHashMap();
                    tmp.put("x", x);
                    tmp.put("y", y);
                    tmp.put("z", z);
                    tmp.put("type", type);
                    results.put(++i, tmp);
                }
            }
        }
        return results;
    }

    public static enum SupportedEntityTypes {
        MOB(EntityLiving.class),
        MINECART(EntityMinecart.class),
        ITEM(EntityItem.class),
        ITEM_FRAME(EntityItemFrame.class),
        PAINTING(EntityPainting.class);

        public final Class<? extends Entity> cls;

        private SupportedEntityTypes(Class<? extends Entity> cls) {
            this.cls = cls;
        }
    }
}

