/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.wrappers;

import java.lang.reflect.Method;
import java.util.Map;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.wrappers.AdapterWrapper;
import openperipheral.adapter.wrappers.MethodExecutorBase;
import openperipheral.api.adapter.IAdapter;
import openperipheral.api.adapter.IAdapterWithConstraints;

public class ExternalAdapterWrapper
extends AdapterWrapper {
    private final IAdapter adapter;

    public ExternalAdapterWrapper(IAdapter adapter) {
        super(adapter.getClass(), adapter.getTargetClass(), adapter.getSourceId());
        this.adapter = adapter;
    }

    @Override
    public boolean canUse(Class<?> cls) {
        return true;
    }

    @Override
    public String describe() {
        return "external (source: " + this.adapterClass.toString() + ")";
    }

    @Override
    protected void prepareDeclaration(MethodDeclaration decl) {
        decl.nameEnv(0, "target", this.targetClass);
    }

    @Override
    public IMethodExecutor createExecutor(Method method, MethodDeclaration decl) {
        return new MethodExecutorBase(decl, method, this.metaInfo){

            @Override
            public IMethodCall startCall(Object target) {
                return super.startCall(ExternalAdapterWrapper.this.adapter).setEnv("target", target);
            }

            @Override
            public Map<String, Class<?>> requiredEnv() {
                Map<String, Class<?>> requiredEnv = super.requiredEnv();
                requiredEnv.remove("target");
                return requiredEnv;
            }
        };
    }

    public static class WithConstraints
    extends ExternalAdapterWrapper {
        private final IAdapterWithConstraints adapter;

        public WithConstraints(IAdapterWithConstraints adapter) {
            super(adapter);
            this.adapter = adapter;
        }

        @Override
        public boolean canUse(Class<?> cls) {
            return this.adapter.canApply(cls);
        }

        @Override
        public String describe() {
            return "external object (w/ constraints) (source: " + this.adapterClass.toString() + ")";
        }
    }
}

