/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openmods.reflection.TypeUtils;
import openmods.utils.AnnotationMap;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodDescription;
import openperipheral.adapter.method.Argument;
import openperipheral.adapter.method.ArgumentBuilder;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Env;
import openperipheral.api.adapter.method.IMultiReturn;
import openperipheral.api.adapter.method.MultipleReturn;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.converter.IConverter;

public class MethodDeclaration
implements IMethodDescription {
    private final List<String> names;
    private final String source;
    private final Method method;
    private final String description;
    private final List<ReturnType> returnTypes;
    private final boolean validateReturn;
    private final boolean multipleReturn;
    private final Map<Integer, Class<?>> unnamedEnvArg = Maps.newHashMap();
    private final Map<String, EnvArg> envArgs = Maps.newHashMap();
    private final List<Argument> callArgs = Lists.newArrayList();
    private final int argCount;

    private static List<String> getNames(Method method, ScriptCallable meta) {
        ImmutableList.Builder names = ImmutableList.builder();
        String mainName = meta.name();
        if ("[none set]".equals(mainName)) {
            names.add((Object)method.getName());
        } else {
            names.add((Object)mainName);
        }
        Alias alias = method.getAnnotation(Alias.class);
        if (alias != null) {
            names.add((Object[])alias.value());
        }
        return names.build();
    }

    public MethodDeclaration(Method method, ScriptCallable meta, String source) {
        this.method = method;
        this.source = source;
        this.names = MethodDeclaration.getNames(method, meta);
        this.description = meta.description();
        this.returnTypes = ImmutableList.copyOf((Object[])meta.returnTypes());
        this.validateReturn = meta.validateReturn();
        this.multipleReturn = method.isAnnotationPresent(MultipleReturn.class);
        if (this.validateReturn) {
            this.validateResultCount();
        }
        Type[] methodArgs = method.getGenericParameterTypes();
        boolean isVarArg = method.isVarArgs();
        ArgParseState state = ArgParseState.ENV_UNNAMED;
        Annotation[][] argsAnnotations = method.getParameterAnnotations();
        for (int argIndex = 0; argIndex < methodArgs.length; ++argIndex) {
            try {
                TypeToken argType = TypeToken.of((Type)methodArgs[argIndex]);
                AnnotationMap argAnnotations = new AnnotationMap(argsAnnotations[argIndex]);
                boolean optionalStart = argAnnotations.get(Optionals.class) != null;
                Env envArg = (Env)argAnnotations.get(Env.class);
                Arg luaArg = (Arg)argAnnotations.get(Arg.class);
                Preconditions.checkState((envArg == null || luaArg == null ? 1 : 0) != 0, (Object)"@Arg and @Env are mutually exclusive");
                if (luaArg != null) {
                    if (state != ArgParseState.ARG_OPTIONAL) {
                        state = ArgParseState.ARG_REQUIRED;
                    }
                    if (optionalStart) {
                        Preconditions.checkState((state != ArgParseState.ENV_NAMED ? 1 : 0) != 0, (Object)"@Optional used more than once");
                        state = ArgParseState.ARG_OPTIONAL;
                    }
                    boolean isLastArg = argIndex == methodArgs.length - 1;
                    ArgumentBuilder builder = new ArgumentBuilder();
                    builder.setVararg(isLastArg && isVarArg);
                    builder.setOptional(state == ArgParseState.ARG_OPTIONAL);
                    builder.setNullable(luaArg.isNullable());
                    Argument arg = builder.build(luaArg.name(), luaArg.description(), luaArg.type(), argType, argIndex);
                    this.callArgs.add(arg);
                    continue;
                }
                Preconditions.checkState((state == ArgParseState.ENV_NAMED || state == ArgParseState.ENV_UNNAMED ? 1 : 0) != 0, (Object)"Unannotated arg in script part (perhaps missing @Arg annotation?)");
                Preconditions.checkState((!optionalStart ? 1 : 0) != 0, (Object)"@Optionals does not work for env arguments");
                Class rawArgType = argType.getRawType();
                if (envArg != null) {
                    Preconditions.checkState((state == ArgParseState.ENV_NAMED || state == ArgParseState.ENV_UNNAMED ? 1 : 0) != 0, (Object)"@Env annotation used in script part of arguments");
                    String envName = envArg.value();
                    EnvArg prev = this.envArgs.put(envName, new EnvArg(rawArgType, argIndex));
                    if (prev != null) {
                        throw new IllegalStateException(String.format("Conflict on name %s, args: %s, %s", envArg, prev.index, argIndex));
                    }
                    state = ArgParseState.ENV_NAMED;
                    continue;
                }
                Preconditions.checkState((state == ArgParseState.ENV_UNNAMED ? 1 : 0) != 0, (Object)"Unnamed env cannot occur after named");
                this.unnamedEnvArg.put(argIndex, rawArgType);
                continue;
            }
            catch (Throwable t) {
                throw new ArgumentDefinitionException(argIndex, t);
            }
        }
        this.argCount = this.unnamedEnvArg.size() + this.envArgs.size() + this.callArgs.size();
        Preconditions.checkState((this.argCount == methodArgs.length ? 1 : 0) != 0, (String)"Internal error for method %s", (Object[])new Object[]{method});
    }

    private void validateResultCount() {
        Class<?> javaReturn = this.method.getReturnType();
        int returnLength = this.returnTypes.size();
        for (ReturnType t : this.returnTypes) {
            Preconditions.checkArgument((t != ReturnType.VOID ? 1 : 0) != 0, (String)"Method '%s' declares Void as return type. Use empty list instead.", (Object[])new Object[]{this.method});
        }
        if (javaReturn == Void.TYPE) {
            Preconditions.checkArgument((returnLength == 0 ? 1 : 0) != 0, (String)"Method '%s' returns nothing, but declares at least one Lua result", (Object[])new Object[]{this.method});
        }
        if (returnLength == 0) {
            Preconditions.checkArgument((javaReturn == Void.TYPE ? 1 : 0) != 0, (String)"Method '%s' returns '%s', but declares no Lua results", (Object[])new Object[]{this.method, javaReturn});
        }
        if (this.multipleReturn) {
            Preconditions.checkArgument((IMultiReturn.class.isAssignableFrom(javaReturn) || Collection.class.isAssignableFrom(javaReturn) || javaReturn.isArray() ? 1 : 0) != 0, (String)"Method '%s' declared more than one Lua result, but returns single '%s' instead of array, collection or IMultiReturn", (Object[])new Object[]{this.method, javaReturn});
        }
        if (returnLength > 1) {
            Preconditions.checkArgument((IMultiReturn.class.isAssignableFrom(javaReturn) || this.multipleReturn ? 1 : 0) != 0, (String)"Method '%s' declared more than one Lua result, but returns single '%s' instead of array, collection or IMultiReturn", (Object[])new Object[]{this.method, javaReturn});
        }
    }

    private static void checkReturnType(int argIndex, ReturnType expected, Object actual) {
        Class<?> expectedJava = expected.getJavaType();
        Preconditions.checkArgument((actual == null || expectedJava.isInstance(actual) || TypeUtils.compareTypes(expectedJava, actual.getClass()) ? 1 : 0) != 0, (String)"Invalid type of return value %s: expected %s, got %s", (Object[])new Object[]{argIndex, expected, actual});
    }

    private void validateResult(Object ... result) {
        if (this.returnTypes.isEmpty()) {
            Preconditions.checkArgument((result.length == 1 && result[0] == null ? 1 : 0) != 0, (Object)"Returning value from null method");
        } else {
            Preconditions.checkArgument((result.length == this.returnTypes.size() ? 1 : 0) != 0, (String)"Returning invalid number of values from method %s, expected %s, got %s", (Object[])new Object[]{this.method, this.returnTypes.size(), result.length});
            for (int i = 0; i < result.length; ++i) {
                MethodDeclaration.checkReturnType(i, this.returnTypes.get(i), result[i]);
            }
        }
    }

    private static Object[] convertMultiResult(IConverter converter, IMultiReturn result) {
        return MethodDeclaration.convertVarResult(converter, result.getObjects());
    }

    private static Object[] convertCollectionResult(IConverter converter, Collection<?> result) {
        Object[] tmp = new Object[result.size()];
        int i = 0;
        for (Object o : result) {
            tmp[i++] = converter.fromJava(o);
        }
        return tmp;
    }

    private static Object[] convertArrayResult(IConverter converter, Object array) {
        int length = Array.getLength(array);
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = converter.fromJava(Array.get(array, i));
        }
        return result;
    }

    private static Object[] convertVarResult(IConverter converter, Object ... result) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = converter.fromJava(result[i]);
        }
        return result;
    }

    private Object[] convertResult(IConverter converter, Object result) {
        if (result instanceof IMultiReturn) {
            return MethodDeclaration.convertMultiResult(converter, (IMultiReturn)result);
        }
        if (this.multipleReturn) {
            if (result != null && result.getClass().isArray()) {
                return MethodDeclaration.convertArrayResult(converter, result);
            }
            if (result instanceof Collection) {
                return MethodDeclaration.convertCollectionResult(converter, (Collection)result);
            }
        }
        return MethodDeclaration.convertVarResult(converter, result);
    }

    public IMethodCall startCall(Object target) {
        return new CallWrap(target);
    }

    public void nameEnv(int index, String name, Class<?> expectedType) {
        Class<?> actualType = this.unnamedEnvArg.remove(index);
        Preconditions.checkState((actualType != null ? 1 : 0) != 0, (Object)"Argument at index %s not present or already named, can't name as %s");
        Preconditions.checkState((boolean)actualType.isAssignableFrom(expectedType), (String)"Field %s (new name: %s) is expected to be %s, but has %s", (Object[])new Object[]{index, name, expectedType, actualType});
        EnvArg prev = this.envArgs.put(name, new EnvArg(actualType, index));
        if (prev != null) {
            throw new IllegalStateException(String.format("Name %s is already used: prev index: %d, new index: %d", name, prev.index, index));
        }
    }

    public void verifyAllParamsNamed() {
        Preconditions.checkState((boolean)this.unnamedEnvArg.isEmpty(), (String)"Env parameters not named: %s", (Object[])new Object[]{this.unnamedEnvArg});
    }

    public void validateUnnamedEnvArgs(Class<?> ... providedArgs) {
        Preconditions.checkState((providedArgs.length == this.unnamedEnvArg.size() ? 1 : 0) != 0);
        for (int i = 0; i < providedArgs.length; ++i) {
            Class<?> needed = this.unnamedEnvArg.get(i);
            Class<?> provided = providedArgs[i];
            Preconditions.checkState((boolean)needed.isAssignableFrom(provided), (String)"Argument %s needs type %s, but %s provided", (Object[])new Object[]{i, needed, provided});
        }
    }

    public void validateEnvArgs(Map<String, Class<?>> providedArgs) {
        for (Map.Entry<String, EnvArg> e : this.envArgs.entrySet()) {
            EnvArg needed = e.getValue();
            String name = e.getKey();
            Class<?> provided = providedArgs.get(name);
            Preconditions.checkState((provided != null ? 1 : 0) != 0, (String)"Method needs argument named %s (position %s) but it's not provided", (Object[])new Object[]{name, needed.index});
            Class<?> neededCls = needed.cls;
            Preconditions.checkState((boolean)neededCls.isAssignableFrom(provided), (String)"Method needs argument named %s (position %s) of type %s, but %s was provided", (Object[])new Object[]{name, needed.index, neededCls, provided});
        }
    }

    public Map<String, Class<?>> getOptionalArgs() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, EnvArg> e : this.envArgs.entrySet()) {
            result.put(e.getKey(), e.getValue().cls);
        }
        return result;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public List<IMethodDescription.IArgumentDescription> arguments() {
        List<Argument> cast = this.callArgs;
        return ImmutableList.copyOf(cast);
    }

    @Override
    public List<ReturnType> returnTypes() {
        return this.returnTypes;
    }

    @Override
    public Set<String> attributes() {
        return Sets.newHashSet();
    }

    @Override
    public String description() {
        return this.description;
    }

    private class CallWrap
    implements IMethodCall {
        private final Object[] args;
        private final boolean[] isSet;
        private final Object target;
        private IConverter converter;

        public CallWrap(Object target) {
            this.args = new Object[MethodDeclaration.this.argCount];
            this.isSet = new boolean[MethodDeclaration.this.argCount];
            this.target = target;
        }

        private CallWrap setArg(int position, Object value) {
            boolean alreadyAdded = this.isSet[position];
            Preconditions.checkState((!alreadyAdded ? 1 : 0) != 0, (String)"Trying to set already defined argument %s in method %s", (Object[])new Object[]{position, MethodDeclaration.this.method});
            this.args[position] = value;
            this.isSet[position] = true;
            return this;
        }

        @Override
        public IMethodCall setEnv(String name, Object value) {
            EnvArg arg;
            if ("converter".equals(name)) {
                this.converter = (IConverter)value;
            }
            if ((arg = (EnvArg)MethodDeclaration.this.envArgs.get(name)) != null) {
                Preconditions.checkState((value == null || arg.cls.isInstance(value) ? 1 : 0) != 0, (String)"Object of type %s cannot be used as argument %s (name: %s) in method %s", (Object[])new Object[]{value != null ? value.getClass() : "<null>", arg.index, name, MethodDeclaration.this.method});
                this.setArg(arg.index, value);
            }
            return this;
        }

        private CallWrap setCallArgs(Object[] luaValues) {
            Preconditions.checkState((this.converter != null ? 1 : 0) != 0, (Object)"Converter not set!");
            try {
                UnmodifiableIterator it = Iterators.forArray((Object[])luaValues);
                try {
                    for (Argument arg : MethodDeclaration.this.callArgs) {
                        Object value = arg.convert(this.converter, (Iterator<Object>)it);
                        this.setArg(arg.javaArgIndex, value);
                    }
                    Preconditions.checkArgument((!it.hasNext() ? 1 : 0) != 0, (Object)"Too many arguments!");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException(String.format("Invalid Lua parameter count, needs %s, got %s", MethodDeclaration.this.callArgs.size(), luaValues.length));
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AdapterLogicException(e);
            }
            return this;
        }

        private Object[] call() throws Exception {
            Object result;
            Preconditions.checkState((this.converter != null ? 1 : 0) != 0, (Object)"Converter not set!");
            for (int i = 0; i < this.args.length; ++i) {
                Preconditions.checkState((boolean)this.isSet[i], (String)"Parameter %s value not set", (Object[])new Object[]{i});
            }
            try {
                result = MethodDeclaration.this.method.invoke(this.target, this.args);
            }
            catch (InvocationTargetException e) {
                Throwable wrapper = e.getCause();
                throw Throwables.propagate((Throwable)(wrapper != null ? wrapper : e));
            }
            Object[] converted = MethodDeclaration.this.convertResult(this.converter, result);
            if (MethodDeclaration.this.validateReturn) {
                MethodDeclaration.this.validateResult(converted);
            }
            return converted;
        }

        @Override
        public Object[] call(Object[] args) throws Exception {
            this.setCallArgs(args);
            return this.call();
        }
    }

    private static enum ArgParseState {
        ENV_UNNAMED,
        ENV_NAMED,
        ARG_REQUIRED,
        ARG_OPTIONAL;

    }

    private static class EnvArg {
        public final Class<?> cls;
        public final int index;

        public EnvArg(Class<?> cls, int index) {
            this.cls = cls;
            this.index = index;
        }
    }

    public static class ArgumentDefinitionException
    extends IllegalStateException {
        private static final long serialVersionUID = -6428721405547878927L;

        public ArgumentDefinitionException(int argument, Throwable cause) {
            super(String.format("Failed to parse annotations on argument %d", argument), cause);
        }
    }
}

