/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openperipheral.adapter.AdapterRegistry;
import openperipheral.adapter.IMethodDescription;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.wrappers.AdapterWrapper;
import openperipheral.adapter.wrappers.TechnicalAdapterWrapper;

public class ClassMethodsListBuilder {
    private final AdapterRegistry manager;
    private final Map<String, IMethodExecutor> methods = Maps.newHashMap();
    private final Set<String> sources = Sets.newHashSet();
    private final Predicate<IMethodExecutor> selector;

    public ClassMethodsListBuilder(AdapterRegistry manager, Predicate<IMethodExecutor> selector) {
        this.manager = manager;
        this.selector = selector;
    }

    public void addExternalAdapters(Class<?> targetCls, Class<?> superClass) {
        for (AdapterWrapper wrapper : this.manager.getExternalAdapters(superClass)) {
            if (wrapper.canUse(targetCls)) {
                this.addMethods(wrapper);
                continue;
            }
            Log.warn((String)"Adapter %s cannot be used for %s due to constraints", (Object[])new Object[]{wrapper.describe()});
        }
    }

    public void addInlineAdapter(Class<?> cls) {
        AdapterWrapper wrapper = this.manager.getInlineAdapter(cls);
        this.addMethods(wrapper);
    }

    public void addMethods(AdapterWrapper wrapper) {
        for (IMethodExecutor executor : wrapper.getMethods()) {
            IMethodDescription descriptable = executor.description();
            if (this.selector.apply((Object)executor)) {
                this.sources.add(descriptable.source());
                for (String name : descriptable.getNames()) {
                    IMethodExecutor previous = this.methods.put(name, executor);
                    if (previous == null) continue;
                    Log.trace((String)"Previous defininition of Lua method '%s' overwritten by %s adapter", (Object[])new Object[]{name, wrapper.describe()});
                }
                continue;
            }
            Log.trace((String)"Method %s from %s is was excluded by %s", (Object[])new Object[]{descriptable.getNames(), wrapper.source(), this.selector});
        }
    }

    public Map<String, IMethodExecutor> getMethodList() {
        return Collections.unmodifiableMap(this.methods);
    }

    public Set<String> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public boolean hasMethods() {
        return !this.methods.isEmpty();
    }

    public Map<String, IMethodExecutor> create() {
        return ImmutableMap.copyOf(this.methods);
    }

    public void addMethodsFromObject(Object obj, Class<?> targetCls, String source) {
        this.addMethods(new TechnicalAdapterWrapper(obj, targetCls, source));
    }
}

