/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RitualEffectEllipsoid
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        int x;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        TileEntity tile = world.func_147438_o(x = ritualStone.getXCoord(), (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IInventory) || ((IInventory)tile).func_70302_i_() < 3) {
            return;
        }
        ItemStack item1 = ((IInventory)tile).func_70301_a(0);
        ItemStack item2 = ((IInventory)tile).func_70301_a(1);
        ItemStack item3 = ((IInventory)tile).func_70301_a(2);
        int xSize = item1 == null ? 0 : item1.field_77994_a;
        int ySize = item2 == null ? 0 : item2.field_77994_a;
        int zSize = item3 == null ? 0 : item3.field_77994_a;
        int cost = 5;
        if (currentEssence < cost) {
            EntityPlayer entityOwner = SpellHelper.getPlayerForUsername(owner);
            if (entityOwner == null) {
                return;
            }
            entityOwner.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 80));
        } else {
            tile = world.func_147438_o(x, y - 1, z);
            if (!(tile instanceof IInventory)) {
                return;
            }
            ItemBlock placedBlock = null;
            ItemStack stack = null;
            int slot = 0;
            IInventory inv = (IInventory)tile;
            while (slot < inv.func_70302_i_()) {
                stack = inv.func_70301_a(slot);
                if (stack == null) {
                    ++slot;
                    continue;
                }
                if (stack.func_77973_b() instanceof ItemBlock) {
                    placedBlock = (ItemBlock)stack.func_77973_b();
                    break;
                }
                ++slot;
            }
            if (placedBlock == null || stack == null || slot >= inv.func_70302_i_()) {
                return;
            }
            int count = 10;
            Int3 lastPos = this.getLastPosition(ritualStone.getCustomRitualTag());
            int i = -xSize;
            int j = -ySize;
            int k = -zSize;
            if (lastPos != null) {
                i = Math.min(xSize, Math.max(-xSize, lastPos.xCoord));
                j = Math.min(ySize, Math.max(-ySize, lastPos.yCoord));
                k = Math.min(zSize, Math.max(-zSize, lastPos.zCoord));
            }
            boolean incrementNext = false;
            while (j <= ySize) {
                if (y + j < 0) {
                    ++j;
                    continue;
                }
                while (i <= xSize) {
                    while (k <= zSize) {
                        if (Math.pow((float)i * ((float)ySize - 0.5f) * ((float)zSize - 0.5f), 2.0) + Math.pow((float)j * ((float)xSize - 0.5f) * ((float)zSize - 0.5f), 2.0) + Math.pow((float)k * ((float)xSize - 0.5f) * ((float)ySize - 0.5f), 2.0) <= Math.pow(((float)(xSize - 1) + 0.5f) * ((float)(ySize - 1) + 0.5f) * ((float)(zSize - 1) + 0.5f), 2.0)) {
                            ++k;
                            continue;
                        }
                        if (Math.pow((float)i * ((float)ySize + 0.5f) * ((float)zSize + 0.5f), 2.0) + Math.pow((float)j * ((float)xSize + 0.5f) * ((float)zSize + 0.5f), 2.0) + Math.pow((float)k * ((float)xSize + 0.5f) * ((float)ySize + 0.5f), 2.0) >= Math.pow(((float)xSize + 0.5f) * ((float)ySize + 0.5f) * ((float)zSize + 0.5f), 2.0)) {
                            ++k;
                            continue;
                        }
                        if (incrementNext || count <= 0) {
                            this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(i, j, k));
                            return;
                        }
                        --count;
                        Block block = world.func_147439_a(x + i, y + j, z + k);
                        if (!block.isAir((IBlockAccess)world, x + i, y + j, z + k)) {
                            ++k;
                            continue;
                        }
                        int i1 = placedBlock.func_77647_b(stack.func_77960_j());
                        int j1 = placedBlock.field_150939_a.func_149660_a(world, x + i, y + j, z + k, 0, 0.0f, 0.0f, 0.0f, i1);
                        if (placedBlock.placeBlockAt(stack, null, world, x + i, y + j, z + k, 0, 0.0f, 0.0f, 0.0f, j1)) {
                            world.func_72908_a((double)((float)(x + i) + 0.5f), (double)((float)(y + j) + 0.5f), (double)((float)(z + k) + 0.5f), placedBlock.field_150939_a.field_149762_H.func_150496_b(), (placedBlock.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, placedBlock.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                            --stack.field_77994_a;
                            if (stack.field_77994_a <= 0) {
                                inv.func_70299_a(slot, null);
                            }
                            this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(i, j, k));
                            incrementNext = true;
                            SoulNetworkHandler.syphonFromNetwork(owner, cost);
                        }
                        ++k;
                    }
                    k = -zSize;
                    ++i;
                }
                i = -xSize;
                this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(i, ++j, k));
                return;
            }
            this.setLastPosition(ritualStone.getCustomRitualTag(), new Int3(-xSize, -ySize, -zSize));
        }
    }

    @Override
    public int getCostPerRefresh() {
        return 0;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> ellipsoidRitual = new ArrayList<RitualComponent>();
        ellipsoidRitual.add(new RitualComponent(-1, 0, -1, 5));
        ellipsoidRitual.add(new RitualComponent(-1, 0, 1, 5));
        ellipsoidRitual.add(new RitualComponent(1, 0, -1, 5));
        ellipsoidRitual.add(new RitualComponent(1, 0, 1, 5));
        ellipsoidRitual.add(new RitualComponent(4, 0, 0, 2));
        ellipsoidRitual.add(new RitualComponent(5, 0, 0, 2));
        ellipsoidRitual.add(new RitualComponent(5, 0, -1, 2));
        ellipsoidRitual.add(new RitualComponent(5, 0, -2, 2));
        ellipsoidRitual.add(new RitualComponent(-4, 0, 0, 2));
        ellipsoidRitual.add(new RitualComponent(-5, 0, 0, 2));
        ellipsoidRitual.add(new RitualComponent(-5, 0, 1, 2));
        ellipsoidRitual.add(new RitualComponent(-5, 0, 2, 2));
        ellipsoidRitual.add(new RitualComponent(0, 0, 4, 4));
        ellipsoidRitual.add(new RitualComponent(0, 0, 5, 4));
        ellipsoidRitual.add(new RitualComponent(1, 0, 5, 4));
        ellipsoidRitual.add(new RitualComponent(2, 0, 5, 4));
        ellipsoidRitual.add(new RitualComponent(0, 0, -4, 4));
        ellipsoidRitual.add(new RitualComponent(0, 0, -5, 4));
        ellipsoidRitual.add(new RitualComponent(-1, 0, -5, 4));
        ellipsoidRitual.add(new RitualComponent(-2, 0, -5, 4));
        ellipsoidRitual.add(new RitualComponent(3, 0, 1, 3));
        ellipsoidRitual.add(new RitualComponent(3, 0, 2, 3));
        ellipsoidRitual.add(new RitualComponent(3, 0, 3, 3));
        ellipsoidRitual.add(new RitualComponent(2, 0, 3, 3));
        ellipsoidRitual.add(new RitualComponent(-3, 0, -1, 3));
        ellipsoidRitual.add(new RitualComponent(-3, 0, -2, 3));
        ellipsoidRitual.add(new RitualComponent(-3, 0, -3, 3));
        ellipsoidRitual.add(new RitualComponent(-2, 0, -3, 3));
        ellipsoidRitual.add(new RitualComponent(1, 0, -3, 1));
        ellipsoidRitual.add(new RitualComponent(2, 0, -3, 1));
        ellipsoidRitual.add(new RitualComponent(3, 0, -3, 1));
        ellipsoidRitual.add(new RitualComponent(3, 0, -2, 1));
        ellipsoidRitual.add(new RitualComponent(-1, 0, 3, 1));
        ellipsoidRitual.add(new RitualComponent(-2, 0, 3, 1));
        ellipsoidRitual.add(new RitualComponent(-3, 0, 3, 1));
        ellipsoidRitual.add(new RitualComponent(-3, 0, 2, 1));
        return ellipsoidRitual;
    }

    public Int3 getLastPosition(NBTTagCompound tag) {
        if (tag != null && tag.func_74767_n("hasWorked")) {
            return Int3.readFromNBT(tag);
        }
        return null;
    }

    public void setLastPosition(NBTTagCompound tag, Int3 pos) {
        if (tag != null) {
            pos.writeToNBT(tag);
            tag.func_74757_a("hasWorked", true);
        }
    }
}

