/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectCrafting
extends RitualEffect {
    public static final boolean isTesting = false;
    public static final boolean limitToSingleStack = true;
    public static final int potentiaDrain = 2;
    public static final int virtusDrain = 2;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 2, false);
        if (world.func_72820_D() % (long)(hasPotentia ? 1 : 4) != 0L) {
            return;
        }
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            boolean hasVirtus;
            NBTTagCompound tag = ritualStone.getCustomRitualTag();
            if (tag == null) {
                ritualStone.setCustomRitualTag(new NBTTagCompound());
                tag = ritualStone.getCustomRitualTag();
            }
            boolean lastFailed = tag.func_74767_n("didLastCraftFail");
            int slotDesignation = tag.func_74762_e("slotDesignation");
            if (lastFailed) {
                tag.func_74768_a("slotDesignation", ++slotDesignation);
                tag.func_74757_a("didLastCraftFail", false);
            }
            int direction = ritualStone.getDirection();
            boolean canContinue = false;
            ItemStack[] recipe = new ItemStack[9];
            InventoryCrafting inventory = new InventoryCrafting(new Container(){

                public boolean func_75145_c(EntityPlayer player) {
                    return false;
                }
            }, 3, 3);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    ItemStack invStack;
                    int gridSpace = (i + 1) * 3 + (j + 1);
                    Int3 pos = this.getSlotPositionForDirection(gridSpace, direction);
                    TileEntity inv = world.func_147438_o(x + pos.xCoord, y + pos.yCoord, z + pos.zCoord);
                    if (!(inv instanceof IInventory) || ((IInventory)inv).func_70302_i_() <= slotDesignation || !((IInventory)inv).func_94041_b(slotDesignation, ((IInventory)inv).func_70301_a(slotDesignation)) || (invStack = ((IInventory)inv).func_70301_a(slotDesignation)) == null) continue;
                    inventory.func_70299_a(gridSpace, invStack);
                    recipe[gridSpace] = invStack;
                    canContinue = true;
                }
            }
            if (!canContinue) {
                tag.func_74768_a("slotDesignation", 0);
                return;
            }
            ItemStack returnStack = CraftingManager.func_77594_a().func_82787_a(inventory, world);
            if (returnStack == null) {
                tag.func_74757_a("didLastCraftFail", true);
                return;
            }
            boolean addOutputToInputs = hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 2, false);
            IInventory outputInv = null;
            ArrayList<IInventory> invList = new ArrayList<IInventory>();
            TileEntity northEntity = world.func_147438_o(x, y - 1, z - 2);
            TileEntity southEntity = world.func_147438_o(x, y - 1, z + 2);
            TileEntity eastEntity = world.func_147438_o(x + 2, y - 1, z);
            TileEntity westEntity = world.func_147438_o(x - 2, y - 1, z);
            switch (direction) {
                case 1: {
                    if (!(southEntity instanceof IInventory)) {
                        return;
                    }
                    outputInv = (IInventory)southEntity;
                    if (northEntity instanceof IInventory) {
                        invList.add((IInventory)northEntity);
                    }
                    if (eastEntity instanceof IInventory) {
                        invList.add((IInventory)eastEntity);
                    }
                    if (!(westEntity instanceof IInventory)) break;
                    invList.add((IInventory)westEntity);
                    break;
                }
                case 2: {
                    if (!(westEntity instanceof IInventory)) {
                        return;
                    }
                    outputInv = (IInventory)westEntity;
                    if (northEntity instanceof IInventory) {
                        invList.add((IInventory)northEntity);
                    }
                    if (eastEntity instanceof IInventory) {
                        invList.add((IInventory)eastEntity);
                    }
                    if (!(southEntity instanceof IInventory)) break;
                    invList.add((IInventory)southEntity);
                    break;
                }
                case 3: {
                    if (!(northEntity instanceof IInventory)) {
                        return;
                    }
                    outputInv = (IInventory)northEntity;
                    if (eastEntity instanceof IInventory) {
                        invList.add((IInventory)eastEntity);
                    }
                    if (southEntity instanceof IInventory) {
                        invList.add((IInventory)southEntity);
                    }
                    if (!(westEntity instanceof IInventory)) break;
                    invList.add((IInventory)westEntity);
                    break;
                }
                case 4: {
                    if (!(eastEntity instanceof IInventory)) {
                        return;
                    }
                    outputInv = (IInventory)eastEntity;
                    if (northEntity instanceof IInventory) {
                        invList.add((IInventory)northEntity);
                    }
                    if (southEntity instanceof IInventory) {
                        invList.add((IInventory)southEntity);
                    }
                    if (!(westEntity instanceof IInventory)) break;
                    invList.add((IInventory)westEntity);
                }
            }
            if (outputInv != null) {
                if (!SpellHelper.canInsertStackFullyIntoInventory(returnStack, outputInv, ForgeDirection.DOWN, true, returnStack.func_77976_d())) {
                    tag.func_74757_a("didLastCraftFail", true);
                    return;
                }
                if (addOutputToInputs) {
                    invList.add(outputInv);
                }
                HashMap syphonMap = new HashMap();
                for (int n = 0; n < recipe.length; ++n) {
                    ItemStack recipeStack = recipe[n];
                    if (recipeStack == null) continue;
                    boolean isItemTaken = false;
                    block9: for (int i = 0; i < invList.size() && !isItemTaken; ++i) {
                        IInventory inputInv = (IInventory)invList.get(i);
                        if (inputInv == null) continue;
                        for (int j = 0; j < inputInv.func_70302_i_(); ++j) {
                            ItemStack invItem;
                            if (!inputInv.func_94041_b(j, recipeStack) || (invItem = inputInv.func_70301_a(j)) == null || !this.areItemsEqualForCrafting(recipeStack, invItem)) continue;
                            inventory.func_70299_a(n, invItem);
                            HashMap<Integer, Integer> slotMap = (HashMap<Integer, Integer>)syphonMap.get(i);
                            if (slotMap == null) {
                                slotMap = new HashMap<Integer, Integer>();
                                syphonMap.put(i, slotMap);
                            }
                            if (slotMap.containsKey(j)) {
                                int syphoned = (Integer)slotMap.get(j);
                                if (invItem.field_77994_a - syphoned <= 0) continue;
                                slotMap.put(j, syphoned + 1);
                                isItemTaken = true;
                                continue block9;
                            }
                            slotMap.put(j, 1);
                            isItemTaken = true;
                            continue block9;
                        }
                    }
                    if (isItemTaken) continue;
                    tag.func_74757_a("didLastCraftFail", true);
                    return;
                }
                SpellHelper.insertStackIntoInventory(CraftingManager.func_77594_a().func_82787_a(inventory, world), outputInv, ForgeDirection.DOWN);
                for (Map.Entry entry1 : syphonMap.entrySet()) {
                    IInventory inputInv = (IInventory)invList.get((Integer)entry1.getKey());
                    for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                        ItemStack drainedStack = inputInv.func_70301_a(((Integer)entry2.getKey()).intValue());
                        Item item = drainedStack.func_77973_b();
                        if (item.hasContainerItem(drainedStack)) {
                            inputInv.func_70299_a(((Integer)entry2.getKey()).intValue(), item.getContainerItem(drainedStack));
                            continue;
                        }
                        drainedStack.field_77994_a -= ((Integer)entry2.getValue()).intValue();
                        if (drainedStack.field_77994_a > 0) continue;
                        inputInv.func_70299_a(((Integer)entry2.getKey()).intValue(), null);
                    }
                }
                if (addOutputToInputs && syphonMap.containsKey(invList.size())) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 2, true);
                }
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
                if (hasPotentia) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 2, true);
                }
                world.func_147471_g(x, y - 1, z + 2);
                world.func_147471_g(x, y - 1, z - 2);
                world.func_147471_g(x + 2, y - 1, z);
                world.func_147471_g(x - 2, y - 1, z);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return 10;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> autoCraftingRitual = new ArrayList<RitualComponent>();
        this.addCornerRunes(autoCraftingRitual, 1, 1, 3);
        this.addParallelRunes(autoCraftingRitual, 1, 1, 3);
        autoCraftingRitual.add(new RitualComponent(0, 1, 0, 4));
        this.addOffsetRunes(autoCraftingRitual, 1, 2, -1, 2);
        this.addCornerRunes(autoCraftingRitual, 1, -1, 2);
        autoCraftingRitual.add(new RitualComponent(-1, -1, 0, 3));
        autoCraftingRitual.add(new RitualComponent(1, -1, 0, 3));
        autoCraftingRitual.add(new RitualComponent(0, -1, -1, 3));
        autoCraftingRitual.add(new RitualComponent(0, -1, 0, 2));
        autoCraftingRitual.add(new RitualComponent(0, -1, 1, 1));
        return autoCraftingRitual;
    }

    public boolean areItemsEqualForCrafting(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77973_b().func_77614_k() || stack1.func_77960_j() == stack2.func_77960_j());
    }

    public boolean areItemStacksEqualWithWildcard(ItemStack recipeStack, ItemStack comparedStack) {
        return recipeStack.func_77969_a(comparedStack) || recipeStack.func_77960_j() == Short.MAX_VALUE && recipeStack.func_77973_b() == comparedStack.func_77973_b();
    }

    public Int3 getSlotPositionForDirection(int slot, int direction) {
        int x = slot % 3 - 1;
        int z = slot / 3 - 1;
        switch (direction) {
            case 1: {
                return new Int3(x, 2, z);
            }
            case 2: {
                return new Int3(z, 2, -x);
            }
            case 3: {
                return new Int3(-x, 2, -z);
            }
            case 4: {
                return new Int3(-z, 2, x);
            }
        }
        return new Int3(0, 0, 0);
    }
}

