/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFluidSigil
extends Item
implements IFluidContainerItem {
    private int capacity = 128000;
    private static final int STATE_SYPHON = 0;
    private static final int STATE_FORCE_SYPHON = 1;
    private static final int STATE_PLACE = 2;
    private static final int STATE_INPUT_TANK = 3;
    private static final int STATE_DRAIN_TANK = 4;
    private static final int STATE_BEAST_DRAIN = 5;
    private static final int maxNumOfStates = 6;

    public ItemFluidSigil() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.desc"));
        if (par1ItemStack.func_77978_p() != null) {
            switch (this.getActionState(par1ItemStack)) {
                case 0: {
                    par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.syphoningmode"));
                    break;
                }
                case 1: {
                    par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.forcesyphonmode"));
                    break;
                }
                case 2: {
                    par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.fluidplacementmode"));
                    break;
                }
                case 3: {
                    par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.filltankmode"));
                    break;
                }
                case 4: {
                    par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.draintankmode"));
                    break;
                }
                case 5: {
                    par3List.add(StatCollector.func_74838_a((String)"tooltip.fluidsigil.beastmode"));
                }
            }
            FluidStack fluid = this.getFluid(par1ItemStack);
            if (fluid != null && fluid.amount > 0) {
                String str = fluid.getFluid().getName();
                int amount = fluid.amount;
                par3List.add("" + amount + "mB of " + str);
            } else {
                par3List.add("Empty");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:WaterSigil");
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par3EntityPlayer.func_70093_af()) {
            int curState = this.cycleActionState(par1ItemStack);
            this.sendMessageViaState(curState, par3EntityPlayer);
            return par1ItemStack;
        }
        switch (this.getActionState(par1ItemStack)) {
            case 0: {
                return this.fillItemFromWorld(par1ItemStack, par2World, par3EntityPlayer, false);
            }
            case 1: {
                return this.fillItemFromWorld(par1ItemStack, par2World, par3EntityPlayer, true);
            }
            case 2: {
                return this.emptyItemToWorld(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 3: {
                return this.fillSelectedTank(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 4: {
                return this.drainSelectedTank(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 5: {
                return this.fillItemFromBeastWorld(par1ItemStack, par2World, par3EntityPlayer, true);
            }
        }
        return par1ItemStack;
    }

    public int getActionState(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74762_e("actionState");
    }

    public void setActionState(ItemStack item, int actionState) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74768_a("actionState", actionState);
    }

    public int cycleActionState(ItemStack item) {
        int state = this.getActionState(item);
        if (++state >= 6) {
            state = 0;
        }
        this.setActionState(item, state);
        return state;
    }

    public void sendMessageViaState(int state, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            ChatComponentText cmc = new ChatComponentText("");
            switch (state) {
                case 0: {
                    cmc.func_150258_a("Now in Syphoning Mode");
                    break;
                }
                case 1: {
                    cmc.func_150258_a("Now in Force-syphon Mode");
                    break;
                }
                case 2: {
                    cmc.func_150258_a("Now in Fluid Placement Mode");
                    break;
                }
                case 3: {
                    cmc.func_150258_a("Now in Fill Tank Mode");
                    break;
                }
                case 4: {
                    cmc.func_150258_a("Now in Drain Tank Mode");
                    break;
                }
                case 5: {
                    cmc.func_150258_a("Now in Beast Mode");
                }
            }
            player.func_146105_b((IChatComponent)cmc);
        }
    }

    public ItemStack fillItemFromBeastWorld(ItemStack container, World world, EntityPlayer player, boolean forceFill) {
        if (world.field_72995_K) {
            return container;
        }
        int range = 5;
        float f = 1.0f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        boolean flag = true;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return container;
            }
            if (!player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, container)) {
                return container;
            }
            boolean[][][] boolList = new boolean[range * 2 + 1][range * 2 + 1][range * 2 + 1];
            for (int i = 0; i < 2 * range + 1; ++i) {
                for (int j = 0; j < 2 * range + 1; ++j) {
                    for (int k = 0; k < 2 * range + 1; ++k) {
                        boolList[i][j][k] = false;
                    }
                }
            }
            ArrayList<Int3> positionList = new ArrayList<Int3>();
            boolList[range][range][range] = true;
            positionList.add(new Int3(range, range, range));
            boolean isReady = false;
            while (!isReady) {
                isReady = true;
                for (int i = 0; i < 2 * range + 1; ++i) {
                    for (int j = 0; j < 2 * range + 1; ++j) {
                        for (int k = 0; k < 2 * range + 1; ++k) {
                            Block block;
                            Fluid fluid;
                            if (!boolList[i][j][k]) continue;
                            if (i - 1 >= 0 && !boolList[i - 1][j][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.func_147439_a(x - range + i - 1, y - range + j, z - range + k)))) != null) {
                                boolList[i - 1][j][k] = true;
                                positionList.add(new Int3(i - 1, j, k));
                                isReady = false;
                            }
                            if (j - 1 >= 0 && !boolList[i][j - 1][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.func_147439_a(x - range + i, y - range + j - 1, z - range + k)))) != null) {
                                boolList[i][j - 1][k] = true;
                                positionList.add(new Int3(i, j - 1, k));
                                isReady = false;
                            }
                            if (k - 1 >= 0 && !boolList[i][j][k - 1] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.func_147439_a(x - range + i, y - range + j, z - range + k - 1)))) != null) {
                                boolList[i][j][k - 1] = true;
                                positionList.add(new Int3(i, j, k - 1));
                                isReady = false;
                            }
                            if (i + 1 <= 2 * range && !boolList[i + 1][j][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.func_147439_a(x - range + i + 1, y - range + j, z - range + k)))) != null) {
                                boolList[i + 1][j][k] = true;
                                positionList.add(new Int3(i + 1, j, k));
                                isReady = false;
                            }
                            if (j + 1 <= 2 * range && !boolList[i][j + 1][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.func_147439_a(x - range + i, y - range + j + 1, z - range + k)))) != null) {
                                boolList[i][j + 1][k] = true;
                                positionList.add(new Int3(i, j + 1, k));
                                isReady = false;
                            }
                            if (k + 1 > 2 * range || boolList[i][j][k + 1] || (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.func_147439_a(x - range + i, y - range + j, z - range + k + 1)))) == null) continue;
                            boolList[i][j][k + 1] = true;
                            positionList.add(new Int3(i, j, k + 1));
                            isReady = false;
                        }
                    }
                }
            }
            for (Int3 pos : positionList) {
                FluidStack fillStack;
                int amount;
                Block block;
                int i = pos.xCoord;
                int j = pos.yCoord;
                int k = pos.zCoord;
                if (!boolList[i][j][k] || world.func_147439_a(x + i - range, y + j - range, z + k - range) == null || !(world.func_147439_a(x + i - range, y + j - range, z + k - range).func_149688_o() instanceof MaterialLiquid) || (block = world.func_147439_a(x + i - range, y + j - range, z + k - range)) == null) continue;
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                AlchemicalWizardry.logger.info("x: " + (i - range) + " y: " + (j - range) + " z: " + (k - range));
                if (fluid == null || world.func_72805_g(x + i - range, y + j - range, z + k - range) != 0 || ((amount = this.fill(container, fillStack = new FluidStack(fluid, 1000), false)) <= 0 || !forceFill) && (amount < 1000 || forceFill)) continue;
                world.func_147468_f(x + i - range, y + j - range, z + k - range);
                this.fill(container, new FluidStack(fluid, 1000), true);
            }
        }
        return container;
    }

    public ItemStack fillItemFromWorld(ItemStack container, World world, EntityPlayer player, boolean forceFill) {
        float f = 1.0f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        boolean flag = true;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, i, j, k)) {
                return container;
            }
            if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, container)) {
                return container;
            }
            if (world.func_147439_a(i, j, k) != null && world.func_147439_a(i, j, k).func_149688_o() instanceof MaterialLiquid) {
                Block block = world.func_147439_a(i, j, k);
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluid == null) {
                    return container;
                }
                FluidStack fillStack = new FluidStack(fluid, 1000);
                int amount = this.fill(container, fillStack, false);
                if (amount > 0 && forceFill || amount >= 1000 && !forceFill) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        world.func_147468_f(i, j, k);
                    }
                    this.fill(container, new FluidStack(fluid, 1000), true);
                    if (player.field_71075_bZ.field_75098_d) {
                        return container;
                    }
                }
            }
        }
        return container;
    }

    public ItemStack emptyItemToWorld(ItemStack container, World world, EntityPlayer player) {
        FluidStack simStack = this.drain(container, 1000, false);
        if (simStack != null && simStack.amount >= 1000) {
            Block fluidBlock = simStack.getFluid().getBlock();
            float f = 1.0f;
            double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
            double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
            double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
            boolean flag = false;
            MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, flag);
            if (movingobjectposition == null) {
                return container;
            }
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int i = movingobjectposition.field_72311_b;
                int j = movingobjectposition.field_72312_c;
                int k = movingobjectposition.field_72309_d;
                if (!world.func_72962_a(player, i, j, k)) {
                    return container;
                }
                if (movingobjectposition.field_72310_e == 0) {
                    --j;
                }
                if (movingobjectposition.field_72310_e == 1) {
                    ++j;
                }
                if (movingobjectposition.field_72310_e == 2) {
                    --k;
                }
                if (movingobjectposition.field_72310_e == 3) {
                    ++k;
                }
                if (movingobjectposition.field_72310_e == 4) {
                    --i;
                }
                if (movingobjectposition.field_72310_e == 5) {
                    ++i;
                }
                if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, container)) {
                    return container;
                }
                if (this.tryPlaceContainedLiquid(world, fluidBlock, d0, d1, d2, i, j, k) && !player.field_71075_bZ.field_75098_d) {
                    this.drain(container, 1000, true);
                    return container;
                }
            }
            return container;
        }
        return container;
    }

    public boolean tryPlaceContainedLiquid(World par1World, Block block, double par2, double par4, double par6, int par8, int par9, int par10) {
        if (!par1World.func_147437_c(par8, par9, par10) && par1World.func_147439_a(par8, par9, par10).func_149730_j()) {
            return false;
        }
        if (par1World.func_147439_a(par8, par9, par10).func_149688_o() instanceof MaterialLiquid && par1World.func_72805_g(par8, par9, par10) == 0) {
            return false;
        }
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && par1World.field_73011_w.field_76575_d) {
            par1World.func_72908_a(par2 + 0.5, par4 + 0.5, par6 + 0.5, "random.fizz", 0.5f, 2.6f + (par1World.field_73012_v.nextFloat() - par1World.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                par1World.func_72869_a("largesmoke", (double)par8 + Math.random(), (double)par9 + Math.random(), (double)par10 + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            par1World.func_147465_d(par8, par9, par10, block, 0, 3);
        }
        return true;
    }

    public ItemStack fillSelectedTank(ItemStack container, World world, EntityPlayer player) {
        int k;
        int j;
        int i;
        TileEntity tile;
        FluidStack fluid = this.getFluid(container);
        if (fluid == null) {
            return container;
        }
        float f = 1.0f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        boolean flag = false;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (tile = world.func_147438_o(i = movingobjectposition.field_72311_b, j = movingobjectposition.field_72312_c, k = movingobjectposition.field_72309_d)) instanceof IFluidHandler) {
            int amount = ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e), fluid, true);
            this.drain(container, amount, true);
        }
        return container;
    }

    public ItemStack drainSelectedTank(ItemStack container, World world, EntityPlayer player) {
        FluidStack fluidAmount;
        int amount;
        int k;
        int j;
        int i;
        TileEntity tile;
        float f = 1.0f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        boolean flag = false;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (tile = world.func_147438_o(i = movingobjectposition.field_72311_b, j = movingobjectposition.field_72312_c, k = movingobjectposition.field_72309_d)) instanceof IFluidHandler && (amount = this.fill(container, fluidAmount = ((IFluidHandler)tile).drain(ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e), this.getCapacity(container), false), false)) > 0) {
            ((IFluidHandler)tile).drain(ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e), this.getCapacity(container), true);
            this.fill(container, fluidAmount, true);
        }
        return container;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return this.capacity;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
            if (stack == null || stack.amount <= 0) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", this.capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return this.capacity;
            }
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (stack == null || stack.amount <= 0) {
            NBTTagCompound fluidTag1 = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag1.func_74768_a("Amount", this.capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag1);
                return this.capacity;
            }
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag1);
            return resource.amount;
        }
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (maxDrain >= this.capacity) {
                container.func_77978_p().func_82580_o("Fluid");
                if (container.func_77978_p().func_82582_d()) {
                    container.func_77982_d(null);
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - maxDrain);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }
}

