/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.armour;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.renderer.model.ModelOmegaFire;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;

public class OmegaArmourFire
extends OmegaArmour {
    private static IIcon helmetIcon;
    private static IIcon plateIcon;
    private static IIcon leggingsIcon;
    private static IIcon bootsIcon;

    public OmegaArmourFire(int armorType) {
        super(armorType);
        this.storeBiomeID = true;
        this.illegalEnchantmentList.add(Enchantment.field_77329_d);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/OmegaFire.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getChestModel() {
        return new ModelOmegaFire(1.0f, true, true, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getLegsModel() {
        return new ModelOmegaFire(0.5f, false, false, true, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
        helmetIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaHelmet_fire");
        plateIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaPlate_fire");
        leggingsIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaLeggings_fire");
        bootsIcon = iconRegister.func_94245_a("AlchemicalWizardry:OmegaBoots_fire");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (this.equals(ModItems.boundHelmetFire)) {
            return helmetIcon;
        }
        if (this.equals(ModItems.boundPlateFire)) {
            return plateIcon;
        }
        if (this.equals(ModItems.boundLeggingsFire)) {
            return leggingsIcon;
        }
        if (this.equals(ModItems.boundBootsFire)) {
            return bootsIcon;
        }
        return this.field_77791_bV;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        int biomeID = this.getBiomeIDStored(stack);
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeID);
        if (biome != null) {
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(new UUID(895132L, this.field_77881_a), "Health modifier" + this.field_77881_a, (double)(this.getDefaultArmourBoost() * this.getHealthBoostModifierForBiome(biome)), 1));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(new UUID(196312L, this.field_77881_a), "Damage modifier" + this.field_77881_a, (double)(this.getDefaultArmourBoost() * this.getDamageModifierForBiome(biome)), 1));
        }
        return map;
    }

    public float getDefaultArmourBoost() {
        switch (this.field_77881_a) {
            case 0: {
                return 2.5f;
            }
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 3.5f;
            }
            case 3: {
                return 2.0f;
            }
        }
        return 0.25f;
    }

    public float getHealthBoostModifierForBiome(BiomeGenBase biome) {
        float modifier = 0.05f;
        if (biome.func_150569_a(BiomeGenBase.field_76778_j)) {
            return modifier * 2.0f;
        }
        if (biome.func_150569_a(BiomeGenBase.field_76771_b)) {
            return modifier * -0.5f;
        }
        if (biome.field_76750_F >= 1.0f) {
            return modifier * 1.5f;
        }
        return modifier * 0.5f;
    }

    public float getDamageModifierForBiome(BiomeGenBase biome) {
        float modifier = 0.03f;
        if (biome.func_150569_a(BiomeGenBase.field_76778_j)) {
            return modifier * 2.0f;
        }
        if (biome.func_150569_a(BiomeGenBase.field_76771_b)) {
            return modifier * -0.5f;
        }
        if (biome.field_76750_F >= 1.0f) {
            return modifier * 1.5f;
        }
        return modifier * 0.5f;
    }
}

