/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.book;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.book.compact.Entry;
import WayofTime.alchemicalWizardry.book.entries.EntryCraftingRecipeCustomText;
import WayofTime.alchemicalWizardry.book.entries.EntryImageCustomText;
import WayofTime.alchemicalWizardry.book.entries.EntryItemCustomText;
import WayofTime.alchemicalWizardry.book.entries.EntryTextCustomText;
import WayofTime.alchemicalWizardry.book.entries.IEntryCustomText;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class BookParser {
    @SideOnly(value=Side.CLIENT)
    public static List<Entry> parseTextFile(String location) {
        File textFiles = new File("config/BloodMagic/bookDocs");
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        try {
            System.out.println("I am in an island of files!");
            InputStream input = AlchemicalWizardry.class.getResourceAsStream(location);
            Minecraft.func_71410_x().field_71466_p.func_78264_a(true);
            if (input != null) {
                String strLine;
                int defMaxLines;
                DataInputStream in = new DataInputStream(input);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                int maxLines = defMaxLines = 16;
                int currentPage = 0;
                int pageIndex = 1;
                String currentTitle = "aw.entry.Magnus";
                String[] strings = new String[]{""};
                ArrayList<IEntryCustomText> iEntryList = new ArrayList<IEntryCustomText>();
                IEntryCustomText currentIEntry = new EntryTextCustomText();
                boolean lastPageWasSpecial = true;
                int entriesPerPage = 14;
                while ((strLine = br.readLine()) != null) {
                    String[] cutStrings;
                    List list;
                    String[] newStrings;
                    if (strLine.trim().isEmpty()) continue;
                    if (strLine.startsWith("//TITLE ")) {
                        String title;
                        lastPageWasSpecial = false;
                        newStrings = new String[currentPage + 1 + 1];
                        for (int i = 0; i < strings.length; ++i) {
                            newStrings[i] = strings[i];
                        }
                        if (currentPage != 0) {
                            currentIEntry.setText(strings[currentPage]);
                            iEntryList.add(currentIEntry);
                            Entry entry = new Entry(BookParser.getArrayForList(iEntryList), currentTitle, entryList.size() / entriesPerPage + 1);
                            entryList.add(entry);
                            iEntryList.clear();
                            currentIEntry = new EntryTextCustomText();
                        }
                        newStrings[++currentPage - 1] = currentTitle + "." + pageIndex + "=" + newStrings[currentPage - 1];
                        newStrings[currentPage] = "";
                        strings = newStrings;
                        pageIndex = 1;
                        currentTitle = title = strLine.replaceFirst("//TITLE ", " ").trim();
                        continue;
                    }
                    if (BookParser.containsSpecialInfo(strLine)) {
                        if (!strings[currentPage].isEmpty() || lastPageWasSpecial) {
                            newStrings = new String[currentPage + 1 + 1];
                            for (int i = 0; i < strings.length; ++i) {
                                newStrings[i] = strings[i];
                            }
                            currentIEntry.setText(strings[currentPage]);
                            iEntryList.add(currentIEntry);
                            newStrings[++currentPage - 1] = currentTitle + "." + pageIndex + "=" + newStrings[currentPage - 1];
                            newStrings[currentPage] = "";
                            strings = newStrings;
                        }
                        currentIEntry = BookParser.getEntryForStringTitle(strLine);
                        maxLines = BookParser.getlineLimitForStringTitle(strLine, defMaxLines);
                        lastPageWasSpecial = true;
                        continue;
                    }
                    strLine = strLine.replace('\ufffd', '\"').replace('\ufffd', '\"').replace("\ufffd", "...").replace('\ufffd', '\'').replace('\ufffd', '-');
                    if (Minecraft.func_71410_x() == null || Minecraft.func_71410_x().field_71466_p == null || (list = Minecraft.func_71410_x().field_71466_p.func_78271_c(strLine, 110)) != null) {
                        // empty if block
                    }
                    for (String word : cutStrings = strLine.split(" ")) {
                        lastPageWasSpecial = true;
                        boolean changePage = false;
                        int length = word.length();
                        word = word.replace('\t', ' ');
                        List list2 = Minecraft.func_71410_x().field_71466_p.func_78271_c(strings[currentPage] + " " + word, 110);
                        if (list2.size() > maxLines) {
                            changePage = true;
                        }
                        if (changePage) {
                            String[] newStrings2 = new String[currentPage + 1 + 1];
                            for (int i = 0; i < strings.length; ++i) {
                                newStrings2[i] = strings[i];
                            }
                            currentIEntry.setText(strings[currentPage]);
                            iEntryList.add(currentIEntry);
                            currentIEntry = new EntryTextCustomText();
                            newStrings2[++currentPage - 1] = currentTitle + "." + pageIndex + "=" + newStrings2[currentPage - 1];
                            newStrings2[currentPage] = word;
                            strings = newStrings2;
                            ++pageIndex;
                            maxLines = defMaxLines;
                            changePage = false;
                            continue;
                        }
                        strings[currentPage] = strings[currentPage] + " " + word;
                    }
                    int currentLines = Minecraft.func_71410_x().field_71466_p.func_78271_c(strings[currentPage], 110).size();
                    while (Minecraft.func_71410_x().field_71466_p.func_78271_c(strings[currentPage] + " ", 110).size() <= currentLines) {
                        strings[currentPage] = strings[currentPage] + " ";
                    }
                }
                strings[currentPage] = strings[currentPage];
                currentIEntry.setText(strings[currentPage]);
                iEntryList.add(currentIEntry);
                Entry entry = new Entry(BookParser.getArrayForList(iEntryList), currentTitle, entryList.size() / entriesPerPage + 1);
                entryList.add(entry);
                iEntryList.clear();
            }
            Minecraft.func_71410_x().field_71466_p.func_78264_a(false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entryList;
    }

    public static IEntryCustomText[] getArrayForList(List<IEntryCustomText> list) {
        Object[] tempArray = list.toArray();
        IEntryCustomText[] customTextArray = new IEntryCustomText[tempArray.length];
        for (int i = 0; i < tempArray.length; ++i) {
            if (!(tempArray[i] instanceof IEntryCustomText)) continue;
            customTextArray[i] = (IEntryCustomText)tempArray[i];
        }
        return customTextArray;
    }

    public static boolean containsSpecialInfo(String unparsedString) {
        return unparsedString.startsWith("//IMAGE") || unparsedString.startsWith("//CRAFTING") || unparsedString.startsWith("//ITEM");
    }

    public static IEntryCustomText getEntryForStringTitle(String unparsedString) {
        String lines;
        ItemStack stack;
        if (unparsedString.startsWith("//IMAGE ")) {
            String lines2 = unparsedString.replaceFirst("//IMAGE ", "");
            String[] arguments = lines2.split(" ");
            if (arguments.length < 4) {
                return null;
            }
            int xSize = Integer.decode(arguments[1]);
            int ySize = Integer.decode(arguments[2]);
            if (arguments.length >= 5) {
                return new EntryImageCustomText(arguments[3], xSize, ySize, arguments[4]);
            }
            return new EntryImageCustomText(arguments[3], xSize, ySize);
        }
        if (unparsedString.startsWith("//CRAFTING ")) {
            String lines3 = unparsedString.replaceFirst("//CRAFTING ", "");
            ItemStack stack2 = APISpellHelper.getItemStackForString(lines3);
            IRecipe recipe = APISpellHelper.getRecipeForItemStack(stack2);
            if (recipe != null) {
                return new EntryCraftingRecipeCustomText(recipe);
            }
        } else if (unparsedString.startsWith("//ITEM ") && (stack = APISpellHelper.getItemStackForString(lines = unparsedString.replaceFirst("//ITEM ", ""))) != null) {
            return new EntryItemCustomText(stack);
        }
        return new EntryTextCustomText();
    }

    public static int getlineLimitForStringTitle(String unparsedString, int def) {
        if (unparsedString.startsWith("//IMAGE ")) {
            String lines = unparsedString.replaceFirst("//IMAGE ", "");
            String[] arguments = lines.split(" ");
            if (arguments.length < 4) {
                return def;
            }
            return Integer.decode(arguments[0]);
        }
        if (unparsedString.startsWith("//CRAFTING ")) {
            return 0;
        }
        if (unparsedString.startsWith("//ITEM ")) {
            return 9;
        }
        return def;
    }
}

