/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemType {
    public final Item item;
    public final int meta;
    public final NBTTagCompound nbtTag;

    public ItemType(Item item, int meta, NBTTagCompound nbtTag) {
        this.item = Objects.requireNonNull(item);
        this.meta = meta;
        this.nbtTag = nbtTag;
    }

    public ItemType(Item item, int meta) {
        this(item, meta, null);
    }

    public ItemType(Item item) {
        this(item, 0, null);
    }

    public ItemType(Block block, int meta, NBTTagCompound nbtTag) {
        this(Item.func_150898_a((Block)block), meta, nbtTag);
    }

    public ItemType(Block block, int meta) {
        this(block, meta, null);
    }

    public ItemType(Block block) {
        this(block, 0, null);
    }

    public ItemStack createStack(int count) {
        ItemStack result = new ItemStack(this.item, count, this.meta);
        result.field_77990_d = this.nbtTag;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemType other = (ItemType)obj;
        return this.item == other.item && this.meta == other.meta && Objects.equals(this.nbtTag, other.nbtTag);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.item.hashCode();
        result = 31 * result + this.meta;
        result = 31 * result + (this.nbtTag == null ? 0 : this.nbtTag.hashCode());
        return result;
    }

    public static ItemType fromStack(ItemStack stack) {
        return new ItemType(stack.func_77973_b(), stack.func_77960_j(), stack.field_77990_d);
    }
}

