/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.renderer;

import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.client.renderer.HUDElement;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static boolean showEquippedItem = true;
    public static boolean enableItemName = false;
    public static boolean enabled = true;
    public static boolean showInChat = true;
    public static int lpBarX = 12;
    public static int lpBarY = 75;
    public static int zLevel = 0;
    private static int xOffsetDefault;
    public static int xOffset;
    private static int yOffsetDefault;
    public static int yOffset;
    private static int yOffsetBottomCenterDefault;
    public static int yOffsetBottomCenter;
    private static boolean applyXOffsetToCenterDefault;
    public static boolean applyXOffsetToCenter;
    private static boolean applyYOffsetToMiddleDefault;
    public static boolean applyYOffsetToMiddle;
    public static String listMode;
    public static String alignMode;
    private static ScaledResolution scaledResolution;

    public static boolean onTickInGame(Minecraft mc) {
        if (enabled && (mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P) {
            float maxHP;
            int max;
            int maxAmount;
            ItemStack stack;
            EntityClientPlayerMP player = mc.field_71439_g;
            player.getEntityData();
            WorldClient world = mc.field_71441_e;
            if (SpellHelper.canPlayerSeeAlchemy((EntityPlayer)player)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                RenderHelper.displayArmorStatus(mc);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if ((stack = player.field_71071_by.func_70440_f(2)) != null && stack.func_77973_b() instanceof OmegaArmour && (maxAmount = (int)APISpellHelper.getPlayerMaxReagentAmount((EntityPlayer)player)) > 0) {
                float val = APISpellHelper.getPlayerCurrentReagentAmount((EntityPlayer)player);
                ReagentStack reagentStack = new ReagentStack(APISpellHelper.getPlayerReagentType((EntityPlayer)player), (int)val);
                if (reagentStack != null && reagentStack.amount > 0) {
                    RenderHelper.renderTestHUD(mc, reagentStack, maxAmount);
                }
            }
            if (SpellHelper.canPlayerSeeLPBar((EntityPlayer)player) && (max = APISpellHelper.getPlayerMaxLPTag((EntityPlayer)player)) > 1) {
                RenderHelper.renderLPHUD(mc, APISpellHelper.getPlayerLPTag((EntityPlayer)player), max);
            }
            if ((maxHP = APISpellHelper.getCurrentAdditionalMaxHP((EntityPlayer)player)) > 0.0f) {
                RenderHelper.renderHPHUD(mc, APISpellHelper.getCurrentAdditionalHP((EntityPlayer)player), maxHP);
            }
        }
        return true;
    }

    private static void renderLPHUD(Minecraft mc, int lpAmount, int maxAmount) {
        GL11.glPushMatrix();
        int xSize = 32;
        int ySize = 32;
        int amount = Math.max((int)(256.0 * ((double)(maxAmount - lpAmount) / (double)maxAmount)), 0);
        int x = (lpBarX - xSize / 2) * 8;
        int y = (lpBarY - ySize / 2) * 8;
        ResourceLocation test2 = new ResourceLocation("alchemicalwizardry", "textures/gui/container1.png");
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(test2);
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        RenderHelper.drawTexturedModalRect(x, y + amount, 0, amount, 256.0, 256 - amount);
        ResourceLocation test = new ResourceLocation("alchemicalwizardry", "textures/gui/lpVial.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(test);
        RenderHelper.drawTexturedModalRect(x, y, 0, 0, 256.0, 256.0);
        GL11.glPopMatrix();
    }

    private static void renderHPHUD(Minecraft mc, float hpAmount, float maxAmount) {
        GL11.glPushMatrix();
        int xSize = 32;
        int ySize = 32;
        int amount = Math.max((int)(256.0 * ((double)hpAmount / (double)maxAmount)), 0);
        int x = (lpBarX + 8 - xSize / 2) * 8;
        int y = (lpBarY + 32 - ySize / 2) * 8;
        ResourceLocation test2 = new ResourceLocation("alchemicalwizardry", "textures/gui/HPBar2.png");
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(test2);
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        RenderHelper.drawTexturedModalRect(x, y, amount, 0, amount, 256.0);
        ResourceLocation test = new ResourceLocation("alchemicalwizardry", "textures/gui/HPBar1.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(test);
        RenderHelper.drawTexturedModalRect(x, y, 0, 0, 256.0, 256.0);
        GL11.glPopMatrix();
    }

    private static List<HUDElement> getHUDElements(Minecraft mc) {
        ArrayList<HUDElement> elements = new ArrayList<HUDElement>();
        MovingObjectPosition movingobjectposition = mc.field_71476_x;
        WorldClient world = mc.field_71441_e;
        if (movingobjectposition == null) {
            return elements;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof IReagentHandler)) {
                return elements;
            }
            IReagentHandler relay = (IReagentHandler)tile;
            ReagentContainerInfo[] infos = relay.getContainerInfo(ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e));
            if (infos != null) {
                for (ReagentContainerInfo info : infos) {
                    ItemStack itemStack;
                    if (info == null || info.reagent == null || info.reagent.reagent == null || (itemStack = ReagentRegistry.getItemForReagent(info.reagent.reagent)) == null) continue;
                    elements.add(new HUDElement(itemStack, 16, 16, 2, info.reagent.amount));
                }
            }
        }
        return elements;
    }

    private static int getX(int width) {
        if (alignMode.toLowerCase().contains("center")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.toLowerCase().contains("right")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.toLowerCase().contains("middle")) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private static int getElementsWidth(List<HUDElement> elements) {
        int r = 0;
        for (HUDElement he : elements) {
            r += he.width();
        }
        return r;
    }

    public static void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, double p_73729_5_, double p_73729_6_) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)p_73729_2_ + p_73729_6_, (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)((double)p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)p_73729_1_ + p_73729_5_, (double)p_73729_2_ + p_73729_6_, (double)zLevel, (double)((float)((double)p_73729_3_ + p_73729_5_) * f), (double)((float)((double)p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)p_73729_1_ + p_73729_5_, (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)((double)p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78381_a();
    }

    private static void renderTestHUD(Minecraft mc, ReagentStack reagentStack, int maxAmount) {
        GL11.glPushMatrix();
        Reagent reagent = reagentStack.reagent;
        int xSize = 32;
        int ySize = 32;
        int amount = Math.max((int)(256.0 * ((double)(maxAmount - reagentStack.amount) / (double)maxAmount)), 0);
        int x = (lpBarX + 16 - xSize / 2) * 8;
        int y = (lpBarY - ySize / 2) * 8;
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        ResourceLocation test2 = new ResourceLocation("alchemicalwizardry", "textures/gui/container1.png");
        GL11.glColor4f((float)((float)reagent.getColourRed() / 255.0f), (float)((float)reagent.getColourGreen() / 255.0f), (float)((float)reagent.getColourBlue() / 255.0f), (float)1.0f);
        mc.func_110434_K().func_110577_a(test2);
        RenderHelper.drawTexturedModalRect(x, y + amount, 0, amount, 256.0, 256 - amount);
        ResourceLocation test = new ResourceLocation("alchemicalwizardry", "textures/gui/container.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(test);
        RenderHelper.drawTexturedModalRect(x, y, 0, 0, 256.0, 256.0);
        GL11.glPopMatrix();
    }

    public static void renderIcon(int p_94149_1_, int p_94149_2_, IIcon p_94149_3_, int p_94149_4_, int p_94149_5_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_94149_1_ + 0), (double)(p_94149_2_ + p_94149_5_), (double)zLevel, (double)p_94149_3_.func_94209_e(), (double)p_94149_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94149_1_ + p_94149_4_), (double)(p_94149_2_ + p_94149_5_), (double)zLevel, (double)p_94149_3_.func_94212_f(), (double)p_94149_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94149_1_ + p_94149_4_), (double)(p_94149_2_ + 0), (double)zLevel, (double)p_94149_3_.func_94212_f(), (double)p_94149_3_.func_94206_g());
        tessellator.func_78374_a((double)(p_94149_1_ + 0), (double)(p_94149_2_ + 0), (double)zLevel, (double)p_94149_3_.func_94209_e(), (double)p_94149_3_.func_94206_g());
        tessellator.func_78381_a();
    }

    private static void displayArmorStatus(Minecraft mc) {
        List<HUDElement> elements = RenderHelper.getHUDElements(mc);
        if (elements.size() > 0) {
            int yOffset;
            int n = yOffset = enableItemName ? 18 : 16;
            if (listMode.equalsIgnoreCase("vertical")) {
                int yBase = RenderHelper.getY(elements.size(), yOffset);
                for (HUDElement e : elements) {
                    e.renderToHud(alignMode.toLowerCase().contains("right") ? RenderHelper.getX(0) : RenderHelper.getX(e.width()), yBase);
                    yBase += yOffset;
                }
            } else if (listMode.equalsIgnoreCase("horizontal")) {
                int totalWidth = RenderHelper.getElementsWidth(elements);
                int yBase = RenderHelper.getY(1, yOffset);
                int xBase = RenderHelper.getX(totalWidth);
                int prevX = 0;
                for (HUDElement e : elements) {
                    e.renderToHud(xBase + prevX + (alignMode.toLowerCase().contains("right") ? e.width() : 0), yBase);
                    prevX += e.width();
                }
            } else if (listMode.equalsIgnoreCase("compound")) {
                // empty if block
            }
        }
    }

    static {
        xOffset = xOffsetDefault = 50;
        yOffset = yOffsetDefault = 2;
        yOffsetBottomCenter = yOffsetBottomCenterDefault = 41;
        applyXOffsetToCenter = applyXOffsetToCenterDefault = true;
        applyYOffsetToMiddle = applyYOffsetToMiddleDefault = false;
        listMode = "horizontal";
        alignMode = "bottomcenter";
    }
}

