/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.items.ShapedBloodOrbRecipe;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.client.nei.NEIConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;

public class NEIBloodOrbShapedHandler
extends ShapedRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == NEIBloodOrbShapedHandler.class) {
            for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
                CachedBloodOrbRecipe recipe;
                if (!(irecipe instanceof ShapedBloodOrbRecipe) || (recipe = this.forgeShapedRecipe((ShapedBloodOrbRecipe)irecipe)) == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedBloodOrbRecipe recipe;
            if (!(irecipe instanceof ShapedBloodOrbRecipe) || (recipe = this.forgeShapedRecipe((ShapedBloodOrbRecipe)irecipe)) == null || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.result.item, (ItemStack)result)) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedBloodOrbRecipe recipe = null;
            if (irecipe instanceof ShapedBloodOrbRecipe) {
                recipe = this.forgeShapedRecipe((ShapedBloodOrbRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.func_77973_b())) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    private CachedBloodOrbRecipe forgeShapedRecipe(ShapedBloodOrbRecipe recipe) {
        Object[] items;
        int height;
        int width;
        try {
            width = recipe.width;
            height = recipe.height;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (Object item : items = recipe.getInput()) {
            if (!(item instanceof List) || !((List)item).isEmpty()) continue;
            return null;
        }
        return new CachedBloodOrbRecipe(width, height, items, recipe.func_77571_b());
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"bm.string.crafting.orb.shaped");
    }

    public class CachedBloodOrbRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe {
        public CachedBloodOrbRecipe(int width, int height, Object[] items, ItemStack out) {
            super((ShapedRecipeHandler)NEIBloodOrbShapedHandler.this, width, height, items, out);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    PositionedStack stack;
                    if (items[y * width + x] == null) continue;
                    Object o = items[y * width + x];
                    if (o instanceof ItemStack) {
                        stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                        continue;
                    }
                    if (o instanceof Integer) {
                        ArrayList<ItemStack> orbs = new ArrayList<ItemStack>();
                        for (Item item : NEIConfig.bloodOrbs) {
                            if (((IBloodOrb)item).getOrbLevel() < (Integer)o) continue;
                            orbs.add(new ItemStack(item));
                        }
                        PositionedStack stack2 = new PositionedStack(orbs, 25 + x * 18, 6 + y * 18, false);
                        stack2.setMaxSize(1);
                        this.ingredients.add(stack2);
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    stack = new PositionedStack((Object)((List)o), 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }
    }
}

