/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.book.entries;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.ShapedBloodOrbRecipe;
import WayofTime.alchemicalWizardry.book.classes.guide.GuiEntry;
import WayofTime.alchemicalWizardry.book.entries.IEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;

public class EntryCraftingRecipe
implements IEntry {
    public IRecipe recipes;
    public ItemStack[] recipe;
    public ItemStack output;
    public ArrayList<ItemIcon> icons = new ArrayList();

    public EntryCraftingRecipe(IRecipe recipes) {
        this.recipes = recipes;
        this.populate(recipes);
    }

    public void populate(IRecipe recipe) {
        block12: {
            block11: {
                if (!(recipe instanceof ShapedRecipes)) break block11;
                ShapedRecipes rec = (ShapedRecipes)recipe;
                if (rec == null || rec.field_77574_d == null || rec.field_77574_d.length <= 0) break block12;
                this.recipe = rec.field_77574_d;
                this.output = rec.func_77571_b();
                break block12;
            }
            if (recipe instanceof ShapedOreRecipe) {
                ShapedOreRecipe rec = (ShapedOreRecipe)recipe;
                this.recipe = new ItemStack[rec.getInput().length];
                for (int i = 0; i < rec.getInput().length; ++i) {
                    ItemStack s = null;
                    s = rec.getInput()[i] instanceof ItemStack ? (ItemStack)rec.getInput()[i] : (ItemStack)((ArrayList)rec.getInput()[i]).get(0);
                    this.recipe[i] = s;
                    this.output = rec.func_77571_b();
                }
            } else if (recipe instanceof ShapedBloodOrbRecipe) {
                ShapedBloodOrbRecipe rec = (ShapedBloodOrbRecipe)recipe;
                this.recipe = new ItemStack[rec.getInput().length];
                for (int i = 0; i < rec.getInput().length; ++i) {
                    ItemStack s = null;
                    if (rec.getInput()[i] instanceof ItemStack) {
                        s = (ItemStack)rec.getInput()[i];
                    } else if (rec.getInput()[i] instanceof Integer) {
                        s = AltarRecipeRegistry.orbMap.get((Integer)rec.getInput()[i]);
                    } else if (rec.getInput()[i] instanceof Object) {
                        System.out.println(rec.getInput()[i].getClass());
                        s = new ItemStack(ModItems.masterBloodOrb);
                    } else {
                        s = (ItemStack)((ArrayList)rec.getInput()[i]).get(0);
                    }
                    this.recipe[i] = s;
                    this.output = rec.func_77571_b();
                }
            }
        }
    }

    @Override
    public void draw(GuiEntry entry, int width, int height, int left, int top, EntityPlayer player, String key, int page, int mX, int mY) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        this.renderOverlay(entry, width, height, left, top);
        int x = left + width / 2 - 34;
        int y = height / 2 - 18 + 0;
        this.drawIcon(0, x, y);
        x = left + width / 2 - 17 + 1;
        y = height / 2 - 18 + 0;
        this.drawIcon(1, x, y);
        x = left + width / 2 - -2;
        y = height / 2 - 18 + 0;
        this.drawIcon(2, x, y);
        x = left + width / 2 - 34;
        y = height / 2 - 18 + 18;
        this.drawIcon(3, x, y);
        x = left + width / 2 - 17 + 1;
        y = height / 2 - 18 + 18;
        this.drawIcon(4, x, y);
        x = left + width / 2 - -2;
        y = height / 2 - 18 + 18;
        this.drawIcon(5, x, y);
        x = left + width / 2 - 34;
        y = height / 2 - 18 + 36;
        this.drawIcon(6, x, y);
        x = left + width / 2 - 17 + 1;
        y = height / 2 - 18 + 36;
        this.drawIcon(7, x, y);
        x = left + width / 2 - -2;
        y = height / 2 - 18 + 36;
        this.drawIcon(8, x, y);
        x = left + width / 2 - -36;
        y = height / 2 - 18 + 18;
        this.drawIcon(this.output, x, y);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        for (ItemIcon icon : this.icons) {
            if (icon.stack == null) continue;
            icon.onMouseBetween(mX, mY);
        }
    }

    public void drawIcon(int entry, int x, int y) {
        RenderItem ri = new RenderItem();
        if (this.recipe != null && this.recipe.length > 0 && this.recipe[entry] != null) {
            ri.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.recipe[entry], x, y);
            ri.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.recipe[entry], x, y);
            this.icons.add(new ItemIcon(this.recipe[entry], x, y));
        }
    }

    public void drawIcon(ItemStack stack, int x, int y) {
        RenderItem ri = new RenderItem();
        ri.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        ri.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        this.icons.add(new ItemIcon(stack, x, y));
    }

    public void renderOverlay(GuiEntry entry, int width, int height, int left, int top) {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(new ResourceLocation("bloodutils:textures/gui/crafting.png"));
        entry.func_73729_b(left, height / 2 - 18 + 0 - 17, 0, 0, width, height);
    }

    @Override
    public void initGui(int width, int height, int left, int top, EntityPlayer player, List buttonList) {
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    static class ItemIcon {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemIcon(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }

        public void onMouseBetween(int mX, int mY) {
            int xSize = this.x + 16;
            int ySize = this.y + 16;
            if (mX > this.x && mX < xSize && mY > this.y && mY < ySize) {
                GL11.glDisable((int)2929);
                if (this.stack != null && this.stack.func_82833_r() != null) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(this.stack.func_82833_r(), mX + 6, mY, new Color(139, 137, 137).getRGB());
                }
                GL11.glEnable((int)2929);
            }
        }
    }
}

