/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.book.classes.guide;

import WayofTime.alchemicalWizardry.book.classes.guide.GuiCategories;
import WayofTime.alchemicalWizardry.book.classes.guide.GuiEntry;
import WayofTime.alchemicalWizardry.book.classes.guide.buttons.ButtonNext;
import WayofTime.alchemicalWizardry.book.classes.guide.buttons.ButtonPage;
import WayofTime.alchemicalWizardry.book.classes.guide.elements.ElementCategory;
import WayofTime.alchemicalWizardry.book.compact.Category;
import WayofTime.alchemicalWizardry.book.compact.Entry;
import WayofTime.alchemicalWizardry.book.registries.EntryRegistry;
import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiIndex
extends GuiScreen {
    private static final ResourceLocation gui = new ResourceLocation("bloodutils:textures/gui/guide.png");
    GuiButton prev;
    GuiButton next;
    GuiButton back;
    Category category;
    EntityPlayer player;
    ElementCategory[] categories = new ElementCategory[EntryRegistry.categories.size()];
    int gwidth = 192;
    int gheight = 192;
    int left;
    int top;
    int currPage = 0;

    public GuiIndex(Category category, EntityPlayer player) {
        this.category = category;
        this.player = player;
    }

    public GuiIndex(Category category, EntityPlayer player, int currPage) {
        this.category = category;
        this.player = player;
        this.currPage = currPage;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.left = this.field_146294_l / 2 - this.gwidth / 2;
        this.top = this.field_146295_m / 2 - this.gheight / 2;
        this.field_146292_n.clear();
        this.populate();
        this.drawCategories();
        int k = (this.field_146294_l - this.gwidth) / 2;
        this.next = new ButtonNext(500, k + 120, this.top + 160, true);
        this.field_146292_n.add(this.next);
        this.prev = new ButtonNext(501, k + 38, this.top + 160, false);
        this.field_146292_n.add(this.prev);
    }

    public void drawCategories() {
        int pX = this.left - 1;
        int pY = this.top + 12;
        int iWidth = 20;
        int iHeight = 20;
        for (int i = 0; i < EntryRegistry.categories.size(); ++i) {
            Category category = EntryRegistry.categories.get(i);
            this.categories[i] = new ElementCategory(category, pX, pY + i * iHeight - 2, iWidth, iHeight, this.player);
        }
    }

    public void populate() {
        this.field_146292_n.clear();
        HashMap<String, Entry> entries = EntryRegistry.entries.get(this.category);
        if (entries != null && !entries.isEmpty()) {
            int j = 0;
            Entry[] entryList = EntryRegistry.getEntriesInOrderForCategory(this.category);
            for (int i = 0; i < entryList.length; ++i) {
                Entry entry = entryList[i];
                if (entry == null || entry.indexPage != this.currPage) continue;
                int x = this.left + this.gwidth / 2 - 75;
                int y = this.top + 15 + 10 * j;
                this.field_146292_n.add(new ButtonPage(j, x, y, 110, 10, ""));
                ++j;
            }
        }
        int k = (this.field_146294_l - this.gwidth) / 2;
        this.next = new ButtonNext(500, k + 120, this.top + 160, true);
        this.field_146292_n.add(this.next);
        this.prev = new ButtonNext(501, k + 38, this.top + 160, false);
        this.field_146292_n.add(this.prev);
    }

    public void func_73863_a(int mX, int mY, float f1) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(gui);
        this.func_73729_b(this.left, this.top, 0, 0, this.gwidth, this.gheight);
        String str = this.category.name;
        this.func_73732_a(this.field_146289_q, str, this.left + this.gwidth / 2, this.top - 15, 0x336666);
        if (this.category != null && EntryRegistry.maxEntries.containsKey(this.category)) {
            int size = EntryRegistry.maxEntries.get(this.category);
            this.func_73732_a(this.field_146289_q, this.currPage + 1 + "/" + (size + 1), this.left + this.gwidth / 2, this.top + 160, 0x336666);
            this.registerButtons();
        }
        for (int i = 0; i < EntryRegistry.categories.size(); ++i) {
            ElementCategory category = this.categories[i];
            category.drawElement();
            if (!category.isMouseInElement(mX, mY)) continue;
            category.onMouseEnter(mX, mY);
        }
        super.func_73863_a(mX, mY, f1);
    }

    public void registerButtons() {
        HashMap<String, Entry> entries = EntryRegistry.entries.get(this.category);
        if (entries != null && !entries.isEmpty()) {
            Entry[] entryList = EntryRegistry.getEntriesInOrderForCategory(this.category);
            int j = 0;
            for (int i = 0; i < entryList.length; ++i) {
                String title;
                Entry entry = entryList[i];
                if (entry == null || entry.indexPage != this.currPage || (title = entry.name) == null || this.field_146292_n.get(j) == null || !(this.field_146292_n.get(j) instanceof ButtonPage)) continue;
                ButtonPage button = (ButtonPage)((Object)this.field_146292_n.get(j));
                button.field_146126_j = title;
                ++j;
            }
        }
    }

    public void func_73864_a(int mX, int mY, int type) {
        super.func_73864_a(mX, mY, type);
        if (type == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCategories(this.player));
        }
        for (int i = 0; i < EntryRegistry.categories.size(); ++i) {
            ElementCategory category = this.categories[i];
            if (!category.isMouseInElement(mX, mY)) continue;
            category.onMouseClick(mX, mY, type);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        int size = EntryRegistry.maxEntries.containsKey(this.category) ? EntryRegistry.maxEntries.get(this.category) : 1;
        if (id == 500) {
            if (this.currPage + 1 < size + 1) {
                ++this.currPage;
                this.populate();
                this.registerButtons();
            }
        } else if (id == 501) {
            if (this.currPage > 0) {
                --this.currPage;
                this.populate();
                this.registerButtons();
            }
        } else {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiEntry(button.field_146126_j, this.player, this.category));
        }
    }

    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (Keyboard.getEventKeyState() && i == 14) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCategories(this.player));
            return;
        }
    }

    public void func_146281_b() {
        ItemStack held = this.player.func_70694_bm();
        if (held.func_77942_o()) {
            held.func_77978_p().func_74778_a("CATEGORY", this.category.name);
            held.func_77978_p().func_74778_a("KEY", "0");
            held.func_77978_p().func_74768_a("PAGE", this.currPage);
        }
    }
}

