/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class APISpellHelper {
    private static NBTTagCompound getPersistentDataTag(EntityPlayer player) {
        NBTTagCompound forgeData = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound beaconData = forgeData.func_74775_l("BloodMagic");
        if (!forgeData.func_74764_b("BloodMagic")) {
            forgeData.func_74782_a("BloodMagic", (NBTBase)beaconData);
        }
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)forgeData);
        }
        return beaconData;
    }

    public static float getCurrentIncense(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:CurrentIncense")) {
            return data.func_74760_g("BM:CurrentIncense");
        }
        return 0.0f;
    }

    public static void setCurrentIncense(EntityPlayer player, float amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:CurrentIncense", amount);
    }

    public static int getPlayerLPTag(EntityPlayer player) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        if (data.func_74764_b("BM:StoredLP")) {
            return data.func_74762_e("BM:StoredLP");
        }
        return 0;
    }

    public static void setPlayerLPTag(EntityPlayer player, int amount) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        data.func_74768_a("BM:StoredLP", amount);
    }

    public static int getPlayerMaxLPTag(EntityPlayer player) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        if (data.func_74764_b("BM:MaxStoredLP")) {
            return data.func_74762_e("BM:MaxStoredLP");
        }
        return 0;
    }

    public static void setPlayerMaxLPTag(EntityPlayer player, int amount) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        data.func_74768_a("BM:MaxStoredLP", amount);
    }

    public static float getPlayerCurrentReagentAmount(EntityPlayer player) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        if (data.func_74764_b("BM:StoredReagentAmount")) {
            return data.func_74760_g("BM:StoredReagentAmount");
        }
        return 0.0f;
    }

    public static void setPlayerCurrentReagentAmount(EntityPlayer player, float amount) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        data.func_74776_a("BM:StoredReagentAmount", amount);
    }

    public static float getPlayerMaxReagentAmount(EntityPlayer player) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        if (data.func_74764_b("BM:MaxReagentAmount")) {
            return data.func_74760_g("BM:MaxReagentAmount");
        }
        return 0.0f;
    }

    public static void setPlayerMaxReagentAmount(EntityPlayer player, float amount) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        data.func_74776_a("BM:MaxReagentAmount", amount);
    }

    public static Reagent getPlayerReagentType(EntityPlayer player) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        if (data.func_74764_b("BM:ReagentType")) {
            return ReagentRegistry.getReagentForKey(data.func_74779_i("BM:ReagentType"));
        }
        return null;
    }

    public static void setPlayerReagentType(EntityPlayer player, String str) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        data.func_74778_a("BM:ReagentType", str);
    }

    public static void setPlayerReagentType(EntityPlayer player, Reagent reagent) {
        APISpellHelper.setPlayerReagentType(player, ReagentRegistry.getKeyForReagent(reagent));
    }

    public static float getCurrentAdditionalHP(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:CurrentAddedHP")) {
            return data.func_74760_g("BM:CurrentAddedHP");
        }
        return 0.0f;
    }

    public static void setCurrentAdditionalHP(EntityPlayer player, float amount) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:CurrentAddedHP", amount);
    }

    public static float getCurrentAdditionalMaxHP(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74764_b("BM:MaxAddedHP")) {
            return data.func_74760_g("BM:MaxAddedHP");
        }
        return 0.0f;
    }

    public static void setCurrentAdditionalMaxHP(EntityPlayer player, float maxHP) {
        NBTTagCompound data = player.getEntityData();
        data.func_74776_a("BM:MaxAddedHP", maxHP);
    }

    public static int getPlayerReagentRegenCooldownTag(EntityPlayer player) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        if (data.func_74764_b("BM:ReagentRegenCooldown")) {
            return data.func_74762_e("BM:ReagentRegenCooldown");
        }
        return 0;
    }

    public static void setPlayerReagentRegenCooldownTag(EntityPlayer player, int amount) {
        NBTTagCompound data = APISpellHelper.getPersistentDataTag(player);
        data.func_74768_a("BM:ReagentRegenCooldown", amount);
    }

    public static ItemStack getOrbForLevel(int level) {
        switch (level) {
            case 1: {
                return new ItemStack(ModItems.weakBloodOrb);
            }
            case 2: {
                return new ItemStack(ModItems.apprenticeBloodOrb);
            }
            case 3: {
                return new ItemStack(ModItems.magicianBloodOrb);
            }
            case 4: {
                return new ItemStack(ModItems.masterBloodOrb);
            }
            case 5: {
                return new ItemStack(ModItems.archmageBloodOrb);
            }
            case 6: {
                return new ItemStack(ModItems.transcendentBloodOrb);
            }
        }
        return new ItemStack((Block)Blocks.field_150480_ab);
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = APISpellHelper.createVec3(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            // empty if block
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public static Vec3 createVec3(double x, double y, double z) {
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public static List<ItemStack> getItemsFromBlock(World world, Block block, int x, int y, int z, int meta, boolean silkTouch, int fortune) {
        boolean canSilk = block.canSilkHarvest(world, null, x, y, z, meta);
        if (canSilk && silkTouch) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack item = new ItemStack(block, 1, meta);
            items.add(item);
            return items;
        }
        return block.getDrops(world, x, y, z, meta, fortune);
    }

    public static void spawnItemListInWorld(List<ItemStack> items, World world, float x, float y, float z) {
        for (ItemStack stack : items) {
            EntityItem itemEntity = new EntityItem(world, (double)x, (double)y, (double)z, stack);
            itemEntity.field_145804_b = 10;
            world.func_72838_d((Entity)itemEntity);
        }
    }

    public static String getNumeralForInt(int num) {
        switch (num) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return "";
    }

    public static Block getBlockForString(String str) {
        String[] parts = str.split(":");
        String modId = parts[0];
        String name = parts[1];
        return GameRegistry.findBlock((String)modId, (String)name);
    }

    public static Item getItemForString(String str) {
        String[] parts = str.split(":");
        String modId = parts[0];
        String name = parts[1];
        return GameRegistry.findItem((String)modId, (String)name);
    }

    public static ItemStack getItemStackForString(String str) {
        String[] parts = str.split(":");
        int meta = 0;
        if (parts.length >= 3) {
            meta = Integer.decode(parts[2]);
        } else if (parts.length < 2) {
            return null;
        }
        String modId = parts[0];
        String name = parts[1];
        String itemString = modId + ":" + name;
        Item item = APISpellHelper.getItemForString(itemString);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Block block = APISpellHelper.getBlockForString(itemString);
        if (block != null) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }

    public static IRecipe getRecipeForItemStack(ItemStack reqStack) {
        if (reqStack == null) {
            return null;
        }
        List craftingList = CraftingManager.func_77594_a().func_77592_b();
        for (Object posRecipe : craftingList) {
            ItemStack outputStack;
            if (!(posRecipe instanceof IRecipe) || (outputStack = ((IRecipe)posRecipe).func_77571_b()) == null || outputStack.func_77973_b() != reqStack.func_77973_b() || outputStack.func_77973_b().func_77614_k() && outputStack.func_77960_j() != reqStack.func_77960_j()) continue;
            return (IRecipe)posRecipe;
        }
        return null;
    }
}

