/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.items;

import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.api.spell.SpellEffect;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigmTool;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSpellMultiTool
extends Item {
    private static final String harvestLevelSuffix = "harvestLvl";
    private static final String digLevelSuffix = "digLvl";
    private static final String tagName = "BloodMagicTool";
    private Random rand = new Random();

    public ItemSpellMultiTool() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:BoundTool");
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        float damage = this.getCustomItemAttack(par1ItemStack);
        float f = (float)par3EntityLivingBase.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        SpellParadigmTool parad = this.loadParadigmFromStack(par1ItemStack);
        if (parad != null) {
            parad.onLeftClickEntity(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase);
        }
        damage += parad.getAddedDamageForEntity((Entity)par2EntityLivingBase);
        if (this.rand.nextFloat() < this.getCritChance(par1ItemStack)) {
            damage *= 1.75f;
        }
        damage *= f;
        if (par3EntityLivingBase instanceof EntityPlayer) {
            par2EntityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)par3EntityLivingBase)), damage);
        } else {
            par2EntityLivingBase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)par3EntityLivingBase), damage);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        SpellParadigmTool parad = this.loadParadigmFromStack(stack);
        if (parad != null && entity instanceof EntityLivingBase) {
            parad.onLeftClickEntity(stack, (EntityLivingBase)entity, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        boolean cancelHarvest;
        float localHardness;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        World world = player.field_70170_p;
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        int hlvl = -1;
        float blockHardness = block.func_149712_f(world, x, y, z);
        MovingObjectPosition mop = APISpellHelper.raytraceFromEntity(world, (Entity)player, true, 5.0);
        Block localBlock = world.func_147439_a(x, y, z);
        int localMeta = world.func_72805_g(x, y, z);
        String toolClass = block.getHarvestTool(meta);
        if (toolClass != null && this.getHarvestLevel(stack, toolClass) != -1) {
            hlvl = block.getHarvestLevel(meta);
        }
        int toolLevel = this.getHarvestLevel(stack, toolClass);
        float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, x, y, z);
        if (hlvl <= toolLevel && (double)localHardness - 1.5 <= (double)blockHardness && !(cancelHarvest = false) && localBlock != null && !(localHardness < 0.0f)) {
            boolean isEffective = false;
            String localToolClass = this.getToolClassForMaterial(localBlock.func_149688_o());
            if (localToolClass != null && this.getHarvestLevel(stack, toolClass) >= localBlock.getHarvestLevel(localMeta)) {
                isEffective = true;
            }
            if (localBlock.func_149688_o().func_76229_l()) {
                isEffective = true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (isEffective) {
                    if (localBlock.removedByPlayer(world, player, x, y, z, true)) {
                        localBlock.func_149664_b(world, x, y, z, localMeta);
                    }
                    localBlock.func_149681_a(world, x, y, z, localMeta, player);
                    if (blockHardness > 0.0f) {
                        this.func_150894_a(stack, world, localBlock, x, y, z, (EntityLivingBase)player);
                    }
                    List<ItemStack> items = APISpellHelper.getItemsFromBlock(world, localBlock, x, y, z, localMeta, this.getSilkTouch(stack), this.getFortuneLevel(stack));
                    SpellParadigmTool parad = this.loadParadigmFromStack(stack);
                    List<ItemStack> newItems = parad.handleItemList(stack, items);
                    if (!world.field_72995_K) {
                        APISpellHelper.spawnItemListInWorld(newItems, world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                    }
                    world.func_147479_m(x, y, z);
                    int cost = 0;
                    cost += parad.digSurroundingArea(stack, world, player, mop, localToolClass, localHardness, toolLevel, this);
                    if ((cost += parad.onBreakBlock(stack, world, player, localBlock, localMeta, x, y, z, ForgeDirection.getOrientation((int)mop.field_72310_e))) > 0) {
                        SoulNetworkHandler.syphonAndDamageFromNetwork(stack, player, cost);
                    }
                } else {
                    world.func_147468_f(x, y, z);
                    world.func_147479_m(x, y, z);
                }
            } else {
                world.func_147468_f(x, y, z);
                world.func_147479_m(x, y, z);
            }
        }
        return true;
    }

    public Material[] getMaterialsForToolclass(String toolClass) {
        if ("pickaxe".equals(toolClass)) {
            return new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151594_q};
        }
        if ("shovel".equals(toolClass)) {
            return new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
        }
        if ("axe".equals(toolClass)) {
            return new Material[]{Material.field_151575_d, Material.field_151582_l, Material.field_151594_q, Material.field_151570_A};
        }
        return new Material[0];
    }

    public String getToolClassForMaterial(Material mat) {
        int i;
        String testString = "pickaxe";
        Material[] matList = this.getMaterialsForToolclass(testString);
        for (i = 0; i < matList.length; ++i) {
            if (matList[i] != mat) continue;
            return testString;
        }
        testString = "shovel";
        matList = this.getMaterialsForToolclass(testString);
        for (i = 0; i < matList.length; ++i) {
            if (matList[i] != mat) continue;
            return testString;
        }
        testString = "axe";
        matList = this.getMaterialsForToolclass(testString);
        for (i = 0; i < matList.length; ++i) {
            if (matList[i] != mat) continue;
            return testString;
        }
        return null;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (this.getHarvestLevel(stack, "pickaxe") > -1) {
            set.add("pickaxe");
        }
        if (this.getHarvestLevel(stack, "axe") > -1) {
            set.add("axe");
        }
        if (this.getHarvestLevel(stack, "shovel") > -1) {
            set.add("shovel");
        }
        return set;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        String toolClass = block.getHarvestTool(meta);
        if (toolClass == null || toolClass.equals("")) {
            return 1.0f;
        }
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            return tag.func_74760_g(digLevelSuffix + toolClass);
        }
        stack.func_77982_d(new NBTTagCompound());
        return 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            if (tag.func_74764_b(harvestLevelSuffix + toolClass)) {
                return tag.func_74762_e(harvestLevelSuffix + toolClass);
            }
            return -1;
        }
        stack.func_77982_d(new NBTTagCompound());
        return -1;
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemStack) {
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public void func_77663_a(ItemStack toolStack, World world, Entity par3Entity, int par4, boolean par5) {
        int duration;
        if (world.field_72995_K) {
            return;
        }
        SpellParadigmTool parad = this.loadParadigmFromStack(toolStack);
        int cost = parad.onUpdate(toolStack, world, par3Entity, par4, par5);
        if (par3Entity instanceof EntityPlayer && cost > 0) {
            SoulNetworkHandler.syphonAndDamageFromNetwork(toolStack, (EntityPlayer)par3Entity, cost);
        }
        if ((duration = Math.max(this.getDuration(toolStack, world), 0)) <= 0 && par3Entity instanceof EntityPlayer) {
            int banishCost = parad.onBanishTool(toolStack, world, par3Entity, par4, par5);
            SoulNetworkHandler.syphonAndDamageFromNetwork(toolStack, (EntityPlayer)par3Entity, banishCost);
            ((EntityPlayer)par3Entity).field_71071_by.field_70462_a[par4] = this.getContainedCrystal(toolStack);
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par3EntityPlayer.func_70093_af()) {
            par3EntityPlayer.func_70062_b(0, this.getContainedCrystal(par1ItemStack));
            return par1ItemStack;
        }
        SpellParadigmTool parad = this.loadParadigmFromStack(par1ItemStack);
        MovingObjectPosition mop = this.func_77621_a(par2World, par3EntityPlayer, false);
        int cost = 0;
        cost = mop != null && mop.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK) ? parad.onRightClickBlock(par1ItemStack, (EntityLivingBase)par3EntityPlayer, par2World, mop) : parad.onRightClickAir(par1ItemStack, par2World, par3EntityPlayer);
        if (cost > 0) {
            SoulNetworkHandler.syphonAndDamageFromNetwork(par1ItemStack, par3EntityPlayer, cost);
        }
        return par1ItemStack;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add("A mace filled with ancient alchemy");
        if (par1ItemStack.func_77978_p() != null) {
            if (!par1ItemStack.func_77978_p().func_74779_i("ownerName").equals("")) {
                par3List.add("Current owner: " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
            }
            for (String str : this.getToolListString(par1ItemStack)) {
                par3List.add(str);
            }
            par3List.add("");
            float damage = this.getCustomItemAttack(par1ItemStack);
            par3List.add("\u00a79+" + (float)((int)(damage * 10.0f)) / 10.0f + " " + "Attack Damage");
            float critChance = (float)((int)(this.getCritChance(par1ItemStack) * 1000.0f)) / 10.0f;
            par3List.add("\u00a79+" + critChance + "% " + "Crit Chance");
        }
    }

    public void setHarvestLevel(ItemStack stack, String toolClass, int harvestLevel) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74768_a(harvestLevelSuffix + toolClass, Math.max(-1, harvestLevel));
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74768_a(harvestLevelSuffix + toolClass, Math.max(-1, harvestLevel));
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public void setDigSpeed(ItemStack stack, String toolClass, float digSpeed) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74776_a(digLevelSuffix + toolClass, digSpeed);
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74776_a(digLevelSuffix + toolClass, digSpeed);
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public float getDigSpeed(ItemStack stack, String toolClass) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            return tag.func_74760_g(digLevelSuffix + toolClass);
        }
        stack.func_77982_d(new NBTTagCompound());
        return 0.0f;
    }

    public void setItemAttack(ItemStack stack, float damage) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74776_a("itemAttack", Math.max(damage, 0.0f));
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74776_a("itemAttack", Math.max(damage, 0.0f));
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public float getCustomItemAttack(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            return tag.func_74760_g("itemAttack");
        }
        stack.func_77982_d(new NBTTagCompound());
        return 0.0f;
    }

    public ItemStack getContainedCrystal(ItemStack container) {
        if (container.func_77942_o()) {
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName).func_74775_l("heldItem");
            return ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        container.func_77982_d(new NBTTagCompound());
        return null;
    }

    public void setContainedCrystal(ItemStack container, ItemStack crystal) {
        if (container.func_77942_o()) {
            NBTTagCompound compTag = container.func_77978_p().func_74775_l(tagName);
            NBTTagCompound tag = compTag.func_74775_l("heldItem");
            crystal.func_77955_b(tag);
            compTag.func_74782_a("heldItem", (NBTBase)tag);
            container.func_77978_p().func_74782_a(tagName, (NBTBase)compTag);
        } else {
            container.func_77982_d(new NBTTagCompound());
            NBTTagCompound compTag = container.func_77978_p().func_74775_l(tagName);
            NBTTagCompound tag = compTag.func_74775_l("heldItem");
            crystal.func_77955_b(tag);
            compTag.func_74782_a("heldItem", (NBTBase)tag);
            container.func_77978_p().func_74782_a(tagName, (NBTBase)compTag);
        }
    }

    public void setDuration(ItemStack container, World world, int duration) {
        if (world.field_72995_K) {
            return;
        }
        WorldServer overWorld = DimensionManager.getWorld((int)0);
        long worldtime = overWorld.func_82737_E();
        if (container.func_77942_o()) {
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName);
            tag.func_74772_a("duration", Math.max((long)duration + worldtime, worldtime));
            container.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            container.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName);
            tag.func_74772_a("duration", Math.max((long)duration + worldtime, worldtime));
            container.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public int getDuration(ItemStack container, World world) {
        if (world.field_72995_K) {
            return 0;
        }
        WorldServer overWorld = DimensionManager.getWorld((int)0);
        long worldtime = overWorld.func_82737_E();
        if (container.func_77942_o()) {
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName);
            return (int)(tag.func_74763_f("duration") - worldtime);
        }
        container.func_77982_d(new NBTTagCompound());
        return 0;
    }

    public void loadParadigmIntoStack(ItemStack container, List<SpellEffect> list) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagiest = container.func_77978_p().func_74775_l(tagName);
        NBTTagList effectList = new NBTTagList();
        for (SpellEffect eff : list) {
            effectList.func_74742_a((NBTBase)eff.getTag());
        }
        tagiest.func_74782_a("Effects", (NBTBase)effectList);
        container.func_77978_p().func_74782_a(tagName, (NBTBase)tagiest);
    }

    public SpellParadigmTool loadParadigmFromStack(ItemStack container) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagiest = container.func_77978_p().func_74775_l(tagName);
        NBTTagList tagList = tagiest.func_150295_c("Effects", 10);
        LinkedList<SpellEffect> spellEffectList = new LinkedList<SpellEffect>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            SpellEffect eff = SpellEffect.getEffectFromTag(tag);
            if (eff == null) continue;
            spellEffectList.add(eff);
        }
        return SpellParadigmTool.getParadigmForEffectArray(spellEffectList);
    }

    public void setSilkTouch(ItemStack stack, boolean silkTouch) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74757_a("silkTouch", silkTouch);
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74757_a("silkTouch", silkTouch);
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public boolean getSilkTouch(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            return tag.func_74767_n("silkTouch");
        }
        stack.func_77982_d(new NBTTagCompound());
        return false;
    }

    public void setFortuneLevel(ItemStack stack, int fortune) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74768_a("fortuneLevel", Math.max(fortune, 0));
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            tag.func_74768_a("fortuneLevel", Math.max(fortune, 0));
            stack.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public int getFortuneLevel(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(tagName);
            return tag.func_74762_e("fortuneLevel");
        }
        stack.func_77982_d(new NBTTagCompound());
        return 0;
    }

    public List<String> getToolListString(ItemStack container) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagiest = container.func_77978_p().func_74775_l(tagName);
        NBTTagList tagList = tagiest.func_150295_c("ToolTips", 10);
        LinkedList<String> toolTipList = new LinkedList<String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            String str = tag.func_74779_i("tip");
            if (str == null) continue;
            toolTipList.add(str);
        }
        return toolTipList;
    }

    public void setToolListString(ItemStack container, List<String> toolTipString) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagiest = container.func_77978_p().func_74775_l(tagName);
        NBTTagList stringList = new NBTTagList();
        for (String str : toolTipString) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("tip", str);
            stringList.func_74742_a((NBTBase)tag);
        }
        tagiest.func_74782_a("ToolTips", (NBTBase)stringList);
        container.func_77978_p().func_74782_a(tagName, (NBTBase)tagiest);
    }

    public void setCritChance(ItemStack container, float chance) {
        if (container.func_77942_o()) {
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName);
            tag.func_74776_a("critChance", Math.max(chance, 0.0f));
            container.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        } else {
            container.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName);
            tag.func_74776_a("critChance", Math.max(chance, 0.0f));
            container.func_77978_p().func_74782_a(tagName, (NBTBase)tag);
        }
    }

    public float getCritChance(ItemStack container) {
        if (container.func_77942_o()) {
            NBTTagCompound tag = container.func_77978_p().func_74775_l(tagName);
            return tag.func_74760_g("critChance");
        }
        container.func_77982_d(new NBTTagCompound());
        return 0.0f;
    }
}

