/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.guide;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.guide.PageMultiBlock;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PageRitualMultiBlock
extends PageMultiBlock {
    private static ItemStack blankStone = new ItemStack(ModBlocks.ritualStone, 1, 0);
    private static ItemStack waterStone = new ItemStack(ModBlocks.ritualStone, 1, 1);
    private static ItemStack fireStone = new ItemStack(ModBlocks.ritualStone, 1, 2);
    private static ItemStack earthStone = new ItemStack(ModBlocks.ritualStone, 1, 3);
    private static ItemStack airStone = new ItemStack(ModBlocks.ritualStone, 1, 4);
    private static ItemStack duskStone = new ItemStack(ModBlocks.ritualStone, 1, 5);
    private static ItemStack dawnStone = new ItemStack(ModBlocks.ritualStone, 1, 6);

    private PageRitualMultiBlock(ItemStack[][][] structure) {
        super(structure);
    }

    public static PageRitualMultiBlock getPageForRitual(String ritualID) {
        return PageRitualMultiBlock.getPageForRitual(Rituals.getRitualList(ritualID));
    }

    public static PageRitualMultiBlock getPageForRitual(List<RitualComponent> ritualComponents) {
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (RitualComponent comp : ritualComponents) {
            minX = Math.min(comp.getX(), minX);
            minY = Math.min(comp.getY(), minY);
            minZ = Math.min(comp.getZ(), minZ);
            maxX = Math.max(comp.getX(), maxX);
            maxY = Math.max(comp.getY(), maxY);
            maxZ = Math.max(comp.getZ(), maxZ);
        }
        System.out.println("Min: (" + minX + ", " + minY + ", " + minZ + "), Max: (" + maxX + ", " + maxY + ", " + maxZ + ")");
        ItemStack[][][] tempStructure = new ItemStack[maxY - minY + 1][maxX - minX + 1][maxZ - minZ + 1];
        for (RitualComponent comp : ritualComponents) {
            tempStructure[comp.getY() - minY][comp.getX() - minX][comp.getZ() - minZ] = PageRitualMultiBlock.getStackForRitualStone(comp.getStoneType());
        }
        tempStructure[-minY][-minX][-minZ] = new ItemStack(ModBlocks.blockMasterStone);
        return new PageRitualMultiBlock(tempStructure);
    }

    private static ItemStack getStackForRitualStone(int type) {
        switch (type) {
            case 0: {
                return blankStone;
            }
            case 1: {
                return waterStone;
            }
            case 2: {
                return fireStone;
            }
            case 3: {
                return earthStone;
            }
            case 4: {
                return airStone;
            }
            case 5: {
                return duskStone;
            }
            case 6: {
                return dawnStone;
            }
        }
        return blankStone;
    }
}

