/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.bindingRegistry;

import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRecipe;
import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRegistry;
import WayofTime.alchemicalWizardry.api.bindingRegistry.UnbindingRecipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class UnbindingRegistry {
    public static List<UnbindingRecipe> unbindingRecipes = new LinkedList<UnbindingRecipe>();

    public static void addAllUnbindingRecipesFromBinding() {
        for (BindingRecipe bindingRecipe : BindingRegistry.bindingRecipes) {
            unbindingRecipes.add(new UnbindingRecipe(bindingRecipe.requiredItem, bindingRecipe.outputItem));
        }
    }

    public static void registerRecipe(ItemStack output, ItemStack input) {
        unbindingRecipes.add(new UnbindingRecipe(output, input));
    }

    public static boolean isRequiredItemValid(ItemStack testItem) {
        for (UnbindingRecipe recipe : unbindingRecipes) {
            if (!recipe.doesRequiredItemMatch(testItem)) continue;
            return true;
        }
        return false;
    }

    public static int getIndexForItem(ItemStack testItem) {
        int i = 0;
        for (UnbindingRecipe recipe : unbindingRecipes) {
            if (recipe.doesRequiredItemMatch(testItem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ItemStack getOutputForIndex(int index) {
        if (unbindingRecipes.size() <= index) {
            return null;
        }
        return unbindingRecipes.get(index).getResult();
    }
}

