/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import codechicken.multipart.minecraft.PartMetaAccess;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LeverPart
extends McSidedMetaPart
implements IFaceRedstonePart {
    public static BlockLever lever = (BlockLever)Blocks.field_150442_at;
    public static int[] metaSideMap = new int[]{1, 4, 5, 2, 3, 0, 0, 1};
    public static int[] sideMetaMap = new int[]{6, 0, 3, 4, 1, 2};
    public static int[] metaSwapMap = new int[]{5, 7};

    public LeverPart() {
    }

    public LeverPart(int meta) {
        super(meta);
    }

    @Override
    public Block getBlock() {
        return lever;
    }

    @Override
    public String getType() {
        return "mc_lever";
    }

    public boolean active() {
        return (this.meta & 8) > 0;
    }

    @Override
    public Cuboid6 getBounds() {
        int m = this.meta & 7;
        double d = 0.1875;
        if (m == 1) {
            return new Cuboid6(0.0, 0.2, 0.5 - d, d * 2.0, 0.8, 0.5 + d);
        }
        if (m == 2) {
            return new Cuboid6(1.0 - d * 2.0, 0.2, 0.5 - d, 1.0, 0.8, 0.5 + d);
        }
        if (m == 3) {
            return new Cuboid6(0.5 - d, 0.2, 0.0, 0.5 + d, 0.8, d * 2.0);
        }
        if (m == 4) {
            return new Cuboid6(0.5 - d, 0.2, 1.0 - d * 2.0, 0.5 + d, 0.8, 1.0);
        }
        d = 0.25;
        if (m == 0 || m == 7) {
            return new Cuboid6(0.5 - d, 0.4, 0.5 - d, 0.5 + d, 1.0, 0.5 + d);
        }
        return new Cuboid6(0.5 - d, 0.0, 0.5 - d, 0.5 + d, 0.6, 0.5 + d);
    }

    @Override
    public int sideForMeta(int meta) {
        return metaSideMap[meta & 7];
    }

    public static McBlockPart placement(World world, BlockCoord pos, EntityPlayer player, int side) {
        pos = pos.copy().offset(side ^ 1);
        if (!world.isSideSolid(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        int meta = sideMetaMap[side ^ 1];
        if (side < 2 && (MathHelper.floor_double((double)((double)(player.field_70177_z / 90.0f) + 0.5)) & 1) == 0) {
            meta = metaSwapMap[side ^ 1];
        }
        return new LeverPart(meta);
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        World world = this.world();
        if (world.field_72995_K) {
            return true;
        }
        world.func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.click", 0.3f, !this.active() ? 0.6f : 0.5f);
        this.meta = (byte)(this.meta ^ 8);
        this.sendDescUpdate();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        this.tile().func_70296_d();
        return true;
    }

    @Override
    public void drawBreaking(RenderBlocks renderBlocks) {
        IBlockAccess actual = renderBlocks.field_147845_a;
        renderBlocks.field_147845_a = new PartMetaAccess(this);
        renderBlocks.func_147790_e((Block)lever, this.x(), this.y(), this.z());
        renderBlocks.field_147845_a = actual;
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        }
    }

    @Override
    public void onConverted() {
        if (this.active()) {
            this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.active() && side == metaSideMap[this.meta & 7] ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return metaSideMap[this.meta & 7];
    }
}

